/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraPartitioning;
import java.util.ArrayList;

public class DbOraFactory {
    private static Class dbPartitioningClass = null;

    public static DbOraPartitioning makePartitioning(XmlMap xmlPartitioning) {
        String type;
        XmlMap rangePartitioning = xmlPartitioning.getXmlMap("range-partitioning");
        if (rangePartitioning != null) {
            type = "Range";
        } else {
            XmlMap hashPartitioning = xmlPartitioning.getXmlMap("hash-partitioning");
            if (hashPartitioning != null) {
                type = "Hash";
            } else {
                XmlMap compositePartitioning = xmlPartitioning.getXmlMap("composite-partitioning");
                if (compositePartitioning != null) {
                    type = "Composite";
                } else {
                    System.err.println("No valid partitioning content given");
                    return null;
                }
            }
        }
        String packageName = "com.sap.jdd.ora.";
        try {
            dbPartitioningClass = Class.forName(packageName + "DbOra" + type + "Partitioning");
            return (DbOraPartitioning)dbPartitioningClass.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static DbOraPartitioning makePartitioning(String partitioningType, String subPartitioningType) {
        String type;
        if (partitioningType.equalsIgnoreCase("RANGE")) {
            type = subPartitioningType.equalsIgnoreCase("HASH") ? "Composite" : "Range";
        } else if (partitioningType.equalsIgnoreCase("HASH")) {
            type = "Hash";
        } else {
            System.err.println("Unsupported partitioning type: " + partitioningType);
            return null;
        }
        String packageName = "com.sap.jdd.ora.";
        try {
            dbPartitioningClass = Class.forName(packageName + "DbOra" + type + "Partitioning");
            return (DbOraPartitioning)dbPartitioningClass.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String listToString(ArrayList list, String listName) {
        if (list == null) {
            return "null\n";
        }
        String out = "\n";
        int j = 0;
        int i = 0;
        while (i < list.size()) {
            j = i + 1;
            out = out + list.get(i).toString() + "\n";
            ++i;
        }
        return out;
    }
}

