/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraEnvironment;
import com.sap.tc.logging.Location;

public class DbOraColumn
extends DbColumn {
    private static Location location = Logger.getLocation("ora.DbOraColumn");

    public DbOraColumn(DbFactory factory) {
        super(factory);
    }

    public DbOraColumn(DbFactory factory, DbColumn other) {
        super(factory, other);
    }

    public DbOraColumn(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
    }

    public DbOraColumn(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        if (dbType.equals("FLOAT")) {
            javaSqlType = 6;
        } else if (dbType.equals("NUMBER")) {
            if (decimals == 0) {
                if (length == 5L) {
                    javaSqlType = 5;
                } else if (length == 10L) {
                    javaSqlType = 4;
                } else if (length == 19L) {
                    javaSqlType = -5;
                }
            }
        } else if (dbType.equals("NCHAR")) {
            javaSqlType = 1;
            length /= 3L;
        } else if (dbType.equals("NVARCHAR2")) {
            javaSqlType = 12;
            length /= 3L;
        } else if (dbType.equals("NCLOB")) {
            javaSqlType = 2005;
            length = 0L;
        } else if (dbType.equals("BLOB")) {
            javaSqlType = 2004;
            length = 0L;
        } else if (dbType.equals("DATE")) {
            javaSqlType = 91;
            length = 0L;
            decimals = 0;
        } else if (dbType.equals("TIMESTAMP(6)")) {
            javaSqlType = 93;
            length = 0L;
            decimals = 0;
        }
        if (length > 0L && !factory.getJavaSqlTypes().getInfo(javaSqlType).hasLengthAttribute()) {
            length = 0L;
        }
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTypeClauseForDdl() throws Exception {
        String string;
        try {
            try {
                location.entering("getTypeClauseForDdl");
                string = super.getDdlTypeClause();
                Object var4_3 = null;
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("getTypeClauseForDdl failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDdlDefaultValueClause() throws Exception {
        String string;
        try {
            try {
                location.entering("getDdlDefaultValueClause");
                string = super.getDdlDefaultValueClause();
                Object var4_3 = null;
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("getDdlDefaultValueClause failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDdlClause() throws Exception {
        String string;
        try {
            try {
                location.entering("getDdlClause");
                string = super.getDdlClause();
                Object var4_3 = null;
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("getDdlClause failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getEquivalentJavaSqlType() {
        int n;
        block26: {
            int n2;
            block25: {
                int n3;
                block24: {
                    int n4;
                    block23: {
                        int n5;
                        block22: {
                            int n6;
                            block21: {
                                int n7;
                                block20: {
                                    int n8;
                                    block19: {
                                        int n9;
                                        block18: {
                                            int n10;
                                            block17: {
                                                int n11;
                                                block16: {
                                                    int n12;
                                                    block15: {
                                                        try {
                                                            location.entering("getEquivalentJavaSqlType");
                                                            switch (this.getJavaSqlType()) {
                                                                case -5: {
                                                                    n12 = 3;
                                                                    Object var14_2 = null;
                                                                    break block15;
                                                                }
                                                                case -7: {
                                                                    n11 = 3;
                                                                    break block16;
                                                                }
                                                                case 8: {
                                                                    n10 = 6;
                                                                    break block17;
                                                                }
                                                                case 4: {
                                                                    n9 = 3;
                                                                    break block18;
                                                                }
                                                                case -4: {
                                                                    n8 = -2;
                                                                    break block19;
                                                                }
                                                                case -1: {
                                                                    n7 = 12;
                                                                    break block20;
                                                                }
                                                                case 2: {
                                                                    n6 = 3;
                                                                    break block21;
                                                                }
                                                                case 5: {
                                                                    n5 = 3;
                                                                    break block22;
                                                                }
                                                                case 92: {
                                                                    n4 = 91;
                                                                    break block23;
                                                                }
                                                                case -6: {
                                                                    n3 = 3;
                                                                    break block24;
                                                                }
                                                                case -3: {
                                                                    n2 = -2;
                                                                    break block25;
                                                                }
                                                                default: {
                                                                    n = this.getJavaSqlType();
                                                                    break;
                                                                }
                                                            }
                                                            break block26;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var14_14 = null;
                                                            location.exiting();
                                                            throw throwable;
                                                        }
                                                    }
                                                    location.exiting();
                                                    return n12;
                                                }
                                                Object var14_3 = null;
                                                location.exiting();
                                                return n11;
                                            }
                                            Object var14_4 = null;
                                            location.exiting();
                                            return n10;
                                        }
                                        Object var14_5 = null;
                                        location.exiting();
                                        return n9;
                                    }
                                    Object var14_6 = null;
                                    location.exiting();
                                    return n8;
                                }
                                Object var14_7 = null;
                                location.exiting();
                                return n7;
                            }
                            Object var14_8 = null;
                            location.exiting();
                            return n6;
                        }
                        Object var14_9 = null;
                        location.exiting();
                        return n5;
                    }
                    Object var14_10 = null;
                    location.exiting();
                    return n4;
                }
                Object var14_11 = null;
                location.exiting();
                return n3;
            }
            Object var14_12 = null;
            location.exiting();
            return n2;
        }
        Object var14_13 = null;
        location.exiting();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DbColumnDifference compareTo(DbColumn target) throws Exception {
        DbColumnDifference dbColumnDifference;
        block24: {
            DbColumnDifference dbColumnDifference2;
            block23: {
                DbColumnDifference dbColumnDifference3;
                block22: {
                    DbColumnDifference dbColumnDifference4;
                    block21: {
                        DbColumnDifference dbColumnDifference5;
                        block20: {
                            DbColumnDifference dbColumnDifference6;
                            block19: {
                                DbColumnDifference dbColumnDifference7;
                                block18: {
                                    try {
                                        try {
                                            Object[] arguments2;
                                            location.entering("compareTo");
                                            DbOraColumn targetColumn = (DbOraColumn)target;
                                            DbColumnDifferencePlan columnDifferencePlan = new DbColumnDifferencePlan();
                                            if (this.getEquivalentJavaSqlType() != targetColumn.getEquivalentJavaSqlType()) {
                                                Object[] arguments2 = new Object[]{this.getName(), this.getJavaSqlTypeName(), target.getJavaSqlTypeName()};
                                                columnDifferencePlan.setTypeIsChanged(true);
                                                location.infoT("compareTo {0}: Java SQL type {1} not equivalent to target type {2}", arguments2);
                                                dbColumnDifference7 = new DbColumnDifference(this, target, columnDifferencePlan, Action.CONVERT);
                                                Object var8_14 = null;
                                                break block18;
                                            }
                                            if (this.getJavaSqlTypeInfo().hasLengthAttribute() && this.getLength() != targetColumn.getLength()) {
                                                arguments2 = new Object[]{this.getName(), new Long(this.getLength()), new Long(target.getLength())};
                                                columnDifferencePlan.setLengthIsChanged(true);
                                                if (this.getLength() > targetColumn.getLength()) {
                                                    location.infoT("compareTo {0}: column length {1} larger than length {2} of target column", arguments2);
                                                    dbColumnDifference6 = new DbColumnDifference(this, target, columnDifferencePlan, Action.CONVERT);
                                                    break block19;
                                                }
                                                location.infoT("compareTo {0}: column length {1} not equal to length {2} of target column", arguments2);
                                            }
                                            if (this.getJavaSqlTypeInfo().hasDecimals() && this.getDecimals() != targetColumn.getDecimals()) {
                                                arguments2 = new Object[]{this.getName(), new Integer(this.getDecimals()), new Integer(target.getDecimals())};
                                                columnDifferencePlan.setDecimalsAreChanged(true);
                                                if (this.getDecimals() > targetColumn.getDecimals()) {
                                                    location.infoT("compareTo {0}: number of decimal places ({1}) larger than decimal places of target column ({2})", arguments2);
                                                    dbColumnDifference5 = new DbColumnDifference(this, target, columnDifferencePlan, Action.CONVERT);
                                                    break block20;
                                                }
                                                location.infoT("compareTo {0}: number of decimal places ({1}) not equal to decimal places of target column ({2})", arguments2);
                                            }
                                            if (this.getJavaSqlTypeInfo().hasDecimals() && this.getLength() - (long)this.getDecimals() != targetColumn.getLength() - (long)targetColumn.getDecimals()) {
                                                arguments2 = new Object[]{this.getName(), new Long(this.getLength() - (long)this.getDecimals()), new Long(target.getLength() - (long)target.getDecimals())};
                                                if (this.getLength() - (long)this.getDecimals() > targetColumn.getLength() - (long)targetColumn.getDecimals()) {
                                                    location.infoT("compareTo {0}: column scale {1} larger than scale {2} of target column", arguments2);
                                                    dbColumnDifference4 = new DbColumnDifference(this, target, columnDifferencePlan, Action.CONVERT);
                                                    break block21;
                                                }
                                                location.infoT("compareTo {0}: column scale {1} not equal to scale {2} of target column", arguments2);
                                            }
                                            if (this.isNotNull() != targetColumn.isNotNull()) {
                                                arguments2 = new Object[]{this.getName()};
                                                columnDifferencePlan.setNullabilityIsChanged(true);
                                                if (targetColumn.isNotNull() && targetColumn.getDefaultValue() == null) {
                                                    location.infoT("compareTo {0}: target column is NOT NULL but has no default value", arguments2);
                                                    dbColumnDifference3 = new DbColumnDifference(this, target, columnDifferencePlan, Action.CONVERT);
                                                    break block22;
                                                }
                                                location.infoT("compareTo {0}: column and target column differ in NOT NULL constraint", arguments2);
                                            }
                                            if (this.getDefaultValue() == null) {
                                                if (targetColumn.getDefaultValue() != null) {
                                                    arguments2 = new Object[]{this.getName(), this.getDefaultValue(), targetColumn.getDefaultValue()};
                                                    columnDifferencePlan.setDefaultValueIsChanged(true);
                                                    location.infoT("compareTo {0}: column and target column have different default values: {1} and {2}", arguments2);
                                                }
                                            } else if (!this.getDefaultValue().equals(targetColumn.getDefaultValue())) {
                                                arguments2 = new Object[]{this.getName(), this.getDefaultValue(), targetColumn.getDefaultValue()};
                                                columnDifferencePlan.setDefaultValueIsChanged(true);
                                                location.infoT("compareTo {0}: column and target column have different default values: {1} and {2}", arguments2);
                                            }
                                            if (columnDifferencePlan.somethingIsChanged()) {
                                                dbColumnDifference2 = new DbColumnDifference(this, target, columnDifferencePlan, Action.ALTER);
                                                break block23;
                                            }
                                            dbColumnDifference = null;
                                            break block24;
                                        }
                                        catch (Exception exception) {
                                            Object[] arguments = new Object[]{this.getName(), exception.getMessage()};
                                            location.errorT("compareTo({0}) failed: {1}", arguments);
                                            throw JddException.createInstance(exception);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_21 = null;
                                        location.exiting();
                                        throw throwable;
                                    }
                                }
                                location.exiting();
                                return dbColumnDifference7;
                            }
                            Object var8_15 = null;
                            location.exiting();
                            return dbColumnDifference6;
                        }
                        Object var8_16 = null;
                        location.exiting();
                        return dbColumnDifference5;
                    }
                    Object var8_17 = null;
                    location.exiting();
                    return dbColumnDifference4;
                }
                Object var8_18 = null;
                location.exiting();
                return dbColumnDifference3;
            }
            Object var8_19 = null;
            location.exiting();
            return dbColumnDifference2;
        }
        Object var8_20 = null;
        location.exiting();
        return dbColumnDifference;
    }

    public boolean acceptedAdd() {
        return true;
    }

    public boolean acceptedDrop() {
        return true;
    }

    public boolean checkNameLength() {
        boolean correct;
        location.entering("checkNameLength");
        boolean bl = correct = this.getName().length() > 0 && this.getName().length() < 31;
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNameLength {0}: length invalid", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNameForReservedWord() {
        boolean correct;
        location.entering("checkNameForReservedWord");
        boolean bl = correct = !DbOraEnvironment.isReservedWord(this.getName());
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNameForReservedWord: {0} is reserved word", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkTypeAttributes() {
        location.entering("checkTypeAttributes");
        boolean correct = true;
        switch (this.getJavaSqlType()) {
            case -5: {
                correct = this.getLength() >= 0L && this.getLength() <= 19L;
                break;
            }
            case -2: {
                correct = this.getLength() >= 0L && this.getLength() <= 255L;
                break;
            }
            case 2004: {
                break;
            }
            case 1: {
                correct = this.getLength() >= 0L && this.getLength() <= 2000L;
                break;
            }
            case 2005: {
                break;
            }
            case 91: {
                break;
            }
            case 3: {
                correct = this.getLength() >= 0L && this.getLength() >= (long)this.getDecimals() && this.getLength() <= 38L;
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                correct = this.getLength() >= 0L && this.getLength() <= 10L;
                break;
            }
            case -4: {
                correct = this.getLength() >= 0L && this.getLength() <= 2000L;
                break;
            }
            case 2: {
                correct = this.getLength() >= 0L && this.getLength() >= (long)this.getDecimals() && this.getLength() <= 38L;
                break;
            }
            case 1111: {
                break;
            }
            case 5: {
                correct = this.getLength() >= 0L && this.getLength() <= 5L;
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case -3: {
                correct = this.getLength() >= 0L && this.getLength() <= 2000L;
                break;
            }
            case 12: {
                boolean bl = correct = this.getLength() >= 0L && this.getLength() <= 1333L;
            }
        }
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkTypeAttributes: type attributes of {0} are invalid", arguments);
        }
        location.exiting();
        return correct;
    }
}

