/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.mss;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexIterator;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.mss.DbMssEnvironment;
import com.sap.dictionary.database.mss.DbMssIndex;
import com.sap.dictionary.database.mss.DbMssPrimaryKey;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class DbMssTable
extends DbTable {
    private String dataFilegroup = "DEFAULT";
    private String textimageFilegroup = "DEFAULT";
    private static Location loc = Logger.getLocation("mss.DbMssTable");

    public DbMssTable() {
    }

    public DbMssTable(DbFactory factory) {
        super(factory);
    }

    public DbMssTable(DbFactory factory, String name) {
        super(factory, name);
    }

    public DbMssTable(DbFactory factory, DbSchema schema, String name) {
        super(factory, schema, name);
    }

    public DbMssTable(DbFactory factory, DbTable other) {
        super(factory, other);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering("setSpecificContentViaXml");
        try {
            XmlMap dbspecMap = xmlMap.getXmlMap("db-spec");
            if (dbspecMap.isEmpty()) {
                return;
            }
            XmlMap tableMap = dbspecMap.getXmlMap("table");
            if (tableMap.isEmpty()) {
                return;
            }
            String xmlName = tableMap.getString("name");
            if (!this.getName().equalsIgnoreCase(xmlName.trim())) {
                throw new JddException(ExType.XML_ERROR, "table name " + this.getName() + "differs from XML table name " + xmlName);
            }
            XmlMap storage = tableMap.getXmlMap("storage-parameters");
            if (!storage.isEmpty()) {
                this.dataFilegroup = storage.getString("filegroup");
                this.textimageFilegroup = storage.getString("textimage-filegroup");
            }
            XmlMap primaryKeyMap = tableMap.getXmlMap("primary-key");
            DbPrimaryKey primaryKey = this.getPrimaryKey();
            if (!primaryKey.isEmpty() && primaryKey != null) {
                ((DbMssPrimaryKey)primaryKey).setSpecificContentViaXml(primaryKeyMap);
            }
            XmlMap indexesMap = tableMap.getXmlMap("indexes");
            DbIndexes indexes = this.getIndexes();
            if (!indexesMap.isEmpty() && indexes != null) {
                XmlMap nextIndexMap = null;
                DbIndex nextDbIndex = null;
                int i = 0;
                while (!(nextIndexMap = indexesMap.getXmlMap("index" + (i == 0 ? "" : "" + i))).isEmpty()) {
                    nextDbIndex = indexes.getIndex(nextIndexMap.getString("name"));
                    if (nextDbIndex == null) {
                        throw new JddException(ExType.XML_ERROR, "table " + this.getName() + ": XML describes unknown index " + nextIndexMap.getString("name"));
                    }
                    ((DbMssIndex)nextDbIndex).setSpecificContentViaXml(nextIndexMap);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaXml failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setColumnsViaDb(DbFactory factory) throws JddException {
        loc.entering("setColumnsViaDb");
        Connection con = factory.getConnection();
        String name = this.getName();
        String tabname = " ";
        DatabaseMetaData dbmd = null;
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        DbColumns columns = new DbColumns(factory);
        try {
            dbmd = NativeSQLAccess.getNativeMetaData((Connection)con);
            tabname = dbmd.storesUpperCaseIdentifiers() ? name.toUpperCase() : (dbmd.storesLowerCaseIdentifiers() ? name.toLowerCase() : name);
            ResultSet rs = dbmd.getColumns(null, schemaName, tabname, null);
            while (rs.next()) {
                String defValUpper;
                String colName = rs.getString("COLUMN_NAME");
                short sqlType = rs.getShort("DATA_TYPE");
                String dbType = rs.getString("TYPE_NAME");
                int colSize = rs.getInt("COLUMN_SIZE");
                int decDigits = rs.getInt("DECIMAL_DIGITS");
                String defVal = rs.getString("COLUMN_DEF");
                if (dbType.equalsIgnoreCase("float") || dbType.equalsIgnoreCase("int") || dbType.equalsIgnoreCase("integer") || dbType.equalsIgnoreCase("smallint") || dbType.equalsIgnoreCase("image") || dbType.equalsIgnoreCase("text") || dbType.equalsIgnoreCase("ntext") || dbType.equalsIgnoreCase("datetime")) {
                    colSize = 0;
                    decDigits = 0;
                }
                boolean defaultBound = false;
                if (defVal != null && (defValUpper = (defVal = defVal.trim()).toUpperCase()).startsWith("CREATE DEFAULT")) {
                    int beg = defValUpper.indexOf(" AS ");
                    defVal = defVal.substring(beg += 4);
                    defVal = defVal.trim();
                    defaultBound = true;
                }
                if (defVal != null) {
                    boolean charType = dbType.endsWith("char") || dbType.endsWith("CHAR");
                    while (defVal.startsWith("(") && defVal.endsWith(")")) {
                        defVal = defVal.substring(defVal.indexOf(40) + 1, defVal.lastIndexOf(41));
                    }
                    if (charType) {
                        defVal = defVal.substring(defVal.indexOf(39) + 1, defVal.lastIndexOf(39));
                    }
                    if (dbType.endsWith("binary") || dbType.endsWith("BINARY")) {
                        if ((defVal = defVal.trim()).startsWith("0x") || defVal.startsWith("0X")) {
                            defVal = defVal.substring(2);
                        }
                        defVal = defVal.toUpperCase();
                    }
                    if (dbType.equalsIgnoreCase("float")) {
                        try {
                            Double v = Double.valueOf(defVal);
                            defVal = v.toString();
                        }
                        catch (NumberFormatException ex) {}
                    } else if (dbType.equalsIgnoreCase("integer") || dbType.equalsIgnoreCase("int") || dbType.equalsIgnoreCase("smallint")) {
                        try {
                            Integer v = Integer.valueOf(defVal);
                            defVal = v.toString();
                        }
                        catch (NumberFormatException ex) {}
                    } else if (dbType.equalsIgnoreCase("datetime") && defVal.startsWith("'") && defVal.endsWith("'")) {
                        defVal = defVal.substring(1, defVal.length() - 1);
                    }
                }
                int pos = rs.getInt("ORDINAL_POSITION");
                boolean isNotNull = rs.getString("IS_NULLABLE").trim().equalsIgnoreCase("NO");
                DbColumn column = factory.makeDbColumn(colName, pos, sqlType, dbType, colSize, decDigits, isNotNull, defVal);
                columns.add(column);
            }
            rs.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setColumnsViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        this.setColumns(columns);
        loc.exiting();
    }

    public void setIndexesViaDb() throws JddException {
        String indexName;
        loc.entering("setIndexesViaDb");
        ArrayList names = new ArrayList();
        DbFactory factory = this.getDbFactory();
        Connection con = factory.getConnection();
        String tabName = this.getName();
        DatabaseMetaData dbmd = null;
        Vector<String> iNames = new Vector<String>();
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        String pkName = "";
        Object primaryKey = null;
        try {
            Statement pkstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            String uidFct = "";
            uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
            ResultSet pkrs = pkstmt.executeQuery("select sopk.name from sysobjects sopk, sysobjects sotab  where sotab.name = '" + tabName + "' and sotab.uid = " + uidFct + " " + "and sotab.id = sopk.parent_obj and sopk.xtype = 'PK'");
            if (pkrs.next()) {
                pkName = pkrs.getString(1);
            }
            pkrs.close();
            pkstmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setIndexesViaDb (det. primary key) failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        try {
            dbmd = NativeSQLAccess.getNativeMetaData((Connection)con);
            ResultSet rs = dbmd.getIndexInfo(null, null, tabName, false, false);
            String actIndexName = "";
            while (rs.next()) {
                indexName = rs.getString("INDEX_NAME");
                if (indexName == null || indexName.equals(actIndexName)) continue;
                if (!indexName.equals(pkName)) {
                    iNames.add(indexName);
                }
                actIndexName = indexName;
            }
            rs.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setIndexesViaDb (listing of index names) failed: {0}", arguments);
            loc.exiting();
            throw new JddException(ExType.OTHER, ex.getMessage());
        }
        if (!iNames.isEmpty()) {
            DbIndexes dbIndexes = new DbIndexes(factory);
            int i = 0;
            while (i < iNames.size()) {
                indexName = (String)iNames.get(i);
                DbMssIndex dbIndex = new DbMssIndex(factory, this.getSchema(), tabName, indexName);
                dbIndex.setCommonContentViaDb();
                dbIndexes.add(dbIndex);
                ++i;
            }
            super.setIndexes(dbIndexes);
        }
        loc.exiting();
    }

    public void setPrimaryKeyViaDb() throws JddException {
        loc.entering("SetPrimaryKeyViaDb");
        DbFactory factory = this.getDbFactory();
        Connection con = this.getDbFactory().getConnection();
        String tabName = this.getName();
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        String pkName = "";
        DbMssPrimaryKey primaryKey = null;
        try {
            Statement pkstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            String uidFct = "";
            uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
            ResultSet pkrs = pkstmt.executeQuery("select sopk.name from sysobjects sopk, sysobjects sotab  where sotab.name = '" + tabName + "' and sotab.uid = " + uidFct + " " + "and sotab.id = sopk.parent_obj and sopk.xtype = 'PK'");
            if (pkrs.next()) {
                pkName = pkrs.getString(1);
            }
            pkrs.close();
            pkstmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setPrimaryKeyViaDb (det. of PK name) failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        if (!pkName.equals("")) {
            primaryKey = new DbMssPrimaryKey(factory, tabName);
            primaryKey.setCommonContentViaDb();
            super.setPrimaryKey(primaryKey);
        } else {
            super.setPrimaryKey(null);
        }
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        String hlp;
        ResultSet drs;
        Statement dstmt;
        loc.entering("setSpecificContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        String uidFct = "";
        uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
        try {
            dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            drs = dstmt.executeQuery("select groupname from sysfilegroups where groupid in (select groupid from sysindexes, sysobjects  where sysobjects.name = '" + this.getName() + "' " + "and sysobjects.uid = " + uidFct + " " + "and sysindexes.id = sysobjects.id and sysindexes.indid in (0,1))");
            if (drs.next()) {
                hlp = drs.getString(1);
                this.dataFilegroup = hlp.equals("PRIMARY") ? "DEFAULT" : hlp;
            }
            drs.close();
            dstmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb (det. filegroup) failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        try {
            dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            drs = dstmt.executeQuery("select groupname from sysfilegroups where groupid in (select groupid from sysindexes, sysobjects  where sysobjects.name = '" + this.getName() + "' " + "and sysobjects.uid = " + uidFct + " " + "and sysindexes.id = sysobjects.id and sysindexes.indid = 255)");
            if (drs.next()) {
                hlp = drs.getString(1);
                this.textimageFilegroup = hlp.equals("PRIMARY") ? "DEFAULT" : hlp;
            }
            drs.close();
            dstmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb (det. filegroup) failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        DbIndexes indexes = this.getIndexes();
        if (indexes != null) {
            DbIndexIterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                ((DbMssIndex)iterator.next()).setSpecificContentViaDb();
            }
        }
        super.setDbSpecificIsSet(true);
        loc.exiting();
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        loc.entering("writeSpecificContentToXmlFile");
        try {
            DbIndexIterator iterator;
            DbIndexes indexes;
            file.println(offset0 + "<?xml version=\"1.0\"?>");
            file.println(offset0 + "<db-spec>");
            file.println(offset0 + "<table name=" + "\"" + this.getName() + "\"" + ">");
            String offset1 = offset0 + XmlHelper.tabulate();
            String offset2 = offset1 + XmlHelper.tabulate();
            file.println(offset1 + "<storage-parameters>");
            file.println(offset2 + "<filegroup>" + this.dataFilegroup + "</filegroup>");
            file.println(offset2 + "<textimage-filegroup>" + this.textimageFilegroup + "</textimage-filegroup>");
            file.println(offset1 + "</storage-parameters>");
            DbPrimaryKey primaryKey = this.getPrimaryKey();
            if (primaryKey != null) {
                ((DbMssPrimaryKey)primaryKey).writeSpecificContentToXmlFile(file, offset1);
            }
            if ((indexes = this.getIndexes()) != null && (iterator = indexes.iterator()).hasNext()) {
                file.println(offset1 + "<indexes>");
                while (iterator.hasNext()) {
                    ((DbMssIndex)iterator.next()).writeSpecificContentToXmlFile(file, offset2);
                }
                file.println(offset1 + "</indexes>");
            }
            file.println(offset0 + "</table>");
            file.println(offset0 + "</db-spec>");
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeSpecificContentToXml failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() throws JddException {
        loc.entering("getDdlStatementsForDrop");
        try {
            DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName());
            DbSqlStatement dropLine = new DbSqlStatement(true);
            String schemaName = null;
            if (this.getSchema() != null) {
                schemaName = this.getSchema().getSchemaName();
            }
            String userdot = "";
            if (schemaName != null) {
                userdot = schemaName + ".";
            }
            dropLine.addLine("DROP TABLE " + userdot + "[" + this.getName() + "]");
            tableDef.add(dropLine);
            loc.exiting();
            return tableDef;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForDrop failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        loc.entering("getDdlStatementsForCreate");
        try {
            String schemaName = null;
            if (this.getSchema() != null) {
                schemaName = this.getSchema().getSchemaName();
            }
            String userdot = "";
            if (schemaName != null) {
                userdot = schemaName + ".";
            }
            DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName());
            DbSqlStatement createLine = new DbSqlStatement();
            createLine.addLine("CREATE TABLE " + userdot + "[" + this.getName() + "] ");
            createLine.merge(this.getColumns().getDdlClause());
            tableDef.add(createLine);
            DbSqlStatement storageLine = new DbSqlStatement();
            boolean addStorage = false;
            if (!this.dataFilegroup.equals("DEFAULT")) {
                storageLine.addLine(" ON " + this.dataFilegroup);
                addStorage = true;
            }
            if (!this.textimageFilegroup.equals("DEFAULT")) {
                storageLine.addLine("  TEXTIMAGE_ON " + this.textimageFilegroup);
                addStorage = true;
            }
            if (addStorage) {
                tableDef.add(storageLine);
            }
            if (this.getPrimaryKey() != null) {
                tableDef.merge(this.getPrimaryKey().getDdlStatementsForCreate());
            }
            if (this.getIndexes() != null) {
                tableDef.merge(this.getIndexes().getDdlStatementsForCreate());
            }
            loc.exiting();
            return tableDef;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForCreate failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public boolean existsOnDb() {
        loc.entering("existsOnDb");
        boolean exists = false;
        Connection con = this.getDbFactory().getConnection();
        String schemaName = null;
        try {
            schemaName = this.retrieveSchemaName(con);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String uidFct = "";
        uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery("select 1 from sysobjects where uid = " + uidFct + " and " + "name = '" + this.getName() + "' and " + "type = 'U' ");
            exists = drs.next();
            drs.close();
            dstmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("existence check for table {0} failed: {1}", arguments);
            loc.exiting();
            System.out.println("Exception caught : " + ex.getMessage());
        }
        Object[] arguments = new Object[]{this.getName(), exists ? "exits " : "doesn't exist"};
        loc.infoT("table {0} {1} on db", arguments);
        loc.exiting();
        return exists;
    }

    public boolean existsData() {
        loc.entering("existsData");
        boolean exists = false;
        Connection con = this.getDbFactory().getConnection();
        String schemaName = null;
        try {
            schemaName = this.retrieveSchemaName(con);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String userdot = "";
        if (schemaName != null) {
            userdot = schemaName + ".";
        }
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery("select top 1 'a' from " + userdot + "[" + this.getName() + "] ");
            exists = drs.next();
            drs.close();
            dstmt.close();
        }
        catch (Exception ex) {
            System.out.println("Exception caught : " + ex.getMessage());
        }
        Object[] arguments = new Object[]{this.getName(), exists ? "contains" : "doesn't contain"};
        loc.infoT("table {0} {1} data", arguments);
        loc.exiting();
        return exists;
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength");
        int nameLen = this.getName().length();
        if (nameLen > 0 && nameLen <= 128) {
            loc.exiting();
            return true;
        }
        Object[] arguments = new Object[]{this.getName(), new Integer(nameLen)};
        loc.errorT("checkNameLength {0}: length {1} invalid", arguments);
        loc.exiting();
        return false;
    }

    public boolean checkNameForReservedWord() {
        loc.entering("checkNameForReservedWord");
        boolean isReserved = DbMssEnvironment.isReservedWord(this.getName());
        if (isReserved) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("checkNameForReservedWord {0}: reserved", arguments);
        }
        loc.exiting();
        return !isReserved;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth");
        DbColumns columns = this.getColumns();
        DbColumnIterator iter = columns.iterator();
        boolean check = true;
        int total = 0;
        int colCnt = 0;
        int varCnt = 0;
        while (iter.hasNext()) {
            DbColumn column = iter.next();
            ++colCnt;
            switch (column.getJavaSqlType()) {
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    total += 16;
                    break;
                }
                case -5: {
                    total += 8;
                    break;
                }
                case -2: {
                    total = (int)((long)total + column.getLength());
                    break;
                }
                case -3: {
                    total = (int)((long)total + column.getLength());
                    ++varCnt;
                    break;
                }
                case 1: {
                    total = (int)((long)total + column.getLength() * 2L);
                    break;
                }
                case 12: {
                    total = (int)((long)total + column.getLength() * 2L);
                    ++varCnt;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    total += 8;
                    break;
                }
                case 2: 
                case 3: {
                    long prec = column.getLength();
                    if (prec < 10L) {
                        total += 5;
                        break;
                    }
                    if (prec < 20L) {
                        total += 9;
                        break;
                    }
                    if (prec < 29L) {
                        total += 13;
                        break;
                    }
                    total += 17;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    total += 8;
                    break;
                }
                case 4: {
                    total += 4;
                    break;
                }
                case 5: {
                    total += 4;
                    break;
                }
                case -6: {
                    total += 8;
                }
            }
        }
        total += 2;
        total += 2;
        total += varCnt * 2;
        if ((total += (colCnt + 7) / 8) > 8060) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(total)};
            loc.errorT("checkWidth {0}: total width({1}) greater than allowed maximum (8060)", arguments);
        }
        loc.exiting();
        return check;
    }

    private String retrieveSchemaName(Connection con) throws JddException {
        String schemaName = null;
        if (this.getSchema() != null) {
            schemaName = this.getSchema().getSchemaName();
        } else {
            try {
                Statement schStmt = NativeSQLAccess.createNativeStatement((Connection)con);
                ResultSet rs = schStmt.executeQuery("select user");
                rs.next();
                schemaName = rs.getString(1);
                rs.close();
                schStmt.close();
            }
            catch (Exception ex) {
                Object[] arguments = new Object[]{ex.getMessage()};
                loc.errorT("retrieveSchemaName failed: {0}", arguments);
                loc.exiting();
                throw JddException.createInstance(ex);
            }
        }
        return schemaName;
    }

    public String toString() {
        return super.toString() + "ON " + this.dataFilegroup + "\n" + "TEXTIMAGE_ON " + this.textimageFilegroup + "\n";
    }
}

