/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.mss;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.mss.DbMssEnvironment;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DbMssColumn
extends DbColumn {
    private static Location loc = Logger.getLocation("mss.DbMssColumn");

    public DbMssColumn(DbFactory factory) {
        super(factory);
    }

    public DbMssColumn(DbFactory factory, DbColumn other) {
        super(factory, other);
    }

    public DbMssColumn(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
    }

    public DbMssColumn(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        if (dbType.equalsIgnoreCase("IMAGE")) {
            javaSqlType = 2004;
            length = 0L;
        } else if (dbType.equalsIgnoreCase("TEXT") || dbType.equalsIgnoreCase("NTEXT")) {
            javaSqlType = 2005;
            length = 0L;
        } else if (dbType.equalsIgnoreCase("CHAR") || dbType.equalsIgnoreCase("NCHAR") || dbType.equalsIgnoreCase("VARCHAR") || dbType.equalsIgnoreCase("NVARCHAR")) {
            javaSqlType = 12;
        } else if (dbType.equalsIgnoreCase("FLOAT")) {
            javaSqlType = 8;
        } else if (dbType.equalsIgnoreCase("REAL")) {
            javaSqlType = 6;
        } else if (dbType.equalsIgnoreCase("SMALLINT") || dbType.equalsIgnoreCase("TINYINT")) {
            javaSqlType = 5;
        } else if (dbType.equalsIgnoreCase("INTEGER") || dbType.equalsIgnoreCase("INT")) {
            javaSqlType = 4;
        } else if (dbType.equalsIgnoreCase("BIGINT")) {
            javaSqlType = -5;
        } else if (dbType.equalsIgnoreCase("DECIMAL") || dbType.equalsIgnoreCase("NUMERIC")) {
            javaSqlType = 3;
        } else if (dbType.equalsIgnoreCase("DATETIME") || dbType.equalsIgnoreCase("SMALLDATETIME")) {
            javaSqlType = 93;
        }
        if (length > 0L && !factory.getJavaSqlTypes().getInfo(javaSqlType).hasLengthAttribute()) {
            length = 0L;
        }
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public String getTypeClauseForDdl() throws Exception {
        loc.entering("getTypeClauseForDdl");
        try {
            String clause = "";
            clause = super.getDdlTypeClause();
            loc.exiting();
            return clause;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getTypeClauseForDdl failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public String getDdlDefaultValueClause() throws Exception {
        loc.entering("getDdlDefaultValueClause");
        try {
            String clause = this.getDdlDefaultValueString();
            if (clause.compareTo("") != 0) {
                clause = "DEFAULT " + clause;
            }
            loc.exiting();
            return clause;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlDefaultValueClause failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    protected String getDdlDefaultValueString() throws Exception {
        loc.entering("getDdlDefaultValueString");
        try {
            String clause = "";
            int javaSqlType = super.getJavaSqlType();
            JavaSqlTypeInfo javaSqlTypeInfo = super.getJavaSqlTypeInfo();
            String defVal = super.getDefaultValue();
            if (defVal != null) {
                boolean noPreSuffix = false;
                if (defVal != null) {
                    if (javaSqlType == -2 || javaSqlType == -3) {
                        defVal = defVal.toUpperCase();
                    }
                    if (javaSqlType == 6) {
                        try {
                            Double v = Double.valueOf(defVal);
                            defVal = v.toString();
                        }
                        catch (NumberFormatException ex) {}
                    } else if (javaSqlType == 4 || javaSqlType == 5) {
                        try {
                            Integer v = Integer.valueOf(defVal);
                            defVal = v.toString();
                        }
                        catch (NumberFormatException ex) {}
                    } else if (javaSqlType == 91 || javaSqlType == 92 || javaSqlType == 93) {
                        if (defVal.equalsIgnoreCase("getdate()")) {
                            noPreSuffix = true;
                        } else {
                            String fmtStr = null;
                            if (javaSqlType == 91) {
                                fmtStr = "yyyy-MM-dd";
                            } else if (javaSqlType == 92) {
                                fmtStr = "HH:mm:ss.SSS";
                            } else if (javaSqlType == 93) {
                                fmtStr = "yyyy-MM-dd HH:mm:ss.SSS";
                            }
                            SimpleDateFormat dateFormatter = (SimpleDateFormat)javaSqlTypeInfo.getFormatterForDefaultString();
                            Date datetime = dateFormatter.parse(defVal);
                            SimpleDateFormat myFormatter = new SimpleDateFormat(fmtStr);
                            defVal = myFormatter.format(datetime);
                        }
                    }
                    clause = noPreSuffix ? defVal : javaSqlTypeInfo.getDefaultValuePrefix() + defVal + javaSqlTypeInfo.getDefaultValueSuffix();
                }
            }
            loc.exiting();
            return clause;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlDefaultValueString failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws Exception {
        loc.entering("writeCommonContentToXmlFile");
        try {
            file.println(offset0 + "<column name=" + "\"" + super.getName() + "\"" + ">");
            String offset = offset0 + XmlHelper.tabulate();
            file.println(offset + "<position>" + super.getPosition() + "</position>");
            file.println(offset + "<java-sql-type>" + super.getJavaSqlTypeName() + "</java-sql-type>");
            file.println(offset + "<db-type>" + super.getDbType() + "</db-type>");
            file.println(offset + "<length>" + super.getLength() + "</length>");
            file.println(offset + "<decimals>" + super.getDecimals() + "</decimals>");
            file.println(offset + "<is-not-null>" + super.isNotNull() + "</is-not-null>");
            String defVal = super.getDefaultValue();
            if (defVal != null) {
                file.println(offset + "<default-value>" + defVal + "</default-value>");
            }
            file.println(offset0 + "</column>");
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeCommonContentToXmlFile failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public String getDdlClause() throws Exception {
        loc.entering("getDdlClause");
        try {
            String clause = "";
            clause = super.getDdlClause();
            loc.exiting();
            return clause;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlClause failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbColumnDifference compareTo(DbColumn target) throws Exception {
        loc.entering("compareTo");
        boolean varbinaryBinarySituation = false;
        try {
            Object[] arguments;
            Object colDiff = null;
            DbMssColumn targetCol = null;
            DbColumnDifferencePlan plan = new DbColumnDifferencePlan();
            targetCol = (DbMssColumn)target;
            int originalType = this.getJavaSqlType();
            int targetType = targetCol.getJavaSqlType();
            if (originalType == -1) {
                originalType = 12;
            }
            if (targetType == -1) {
                targetType = 12;
            }
            if (originalType == -4) {
                originalType = -3;
            }
            if (targetType == -4) {
                targetType = -3;
            }
            if (originalType != 92 && originalType != 93 && originalType != 91 || targetType != 92 && targetType != 93 && targetType != 91) {
                if (originalType == -3 && targetType == -2) {
                    arguments = new Object[]{this.getName()};
                    loc.infoT("compareTo ({0}): original type VARBINARY -- target type BINARY", arguments);
                    varbinaryBinarySituation = true;
                } else if (originalType != targetType) {
                    plan.setTypeIsChanged(true);
                    if (!(originalType == 5 && targetType == 4 || originalType == 12 && targetType == 2005 || originalType == -3 && targetType == 2004 || originalType == 6 && targetType == 8)) {
                        Object[] arguments2 = new Object[]{this.getName(), this.getJavaSqlTypeName(), target.getJavaSqlTypeName()};
                        loc.errorT("compareTo ({0}): conversion necessary: original type {1} incompatible to target type {2}", arguments2);
                        loc.exiting();
                        return new DbColumnDifference(this, target, plan, Action.CONVERT);
                    }
                }
            }
            if (targetCol.getJavaSqlTypeInfo().hasLengthAttribute()) {
                Object[] arguments3;
                long orgLen = this.getLength();
                long targetLen = targetCol.getLength();
                if ((targetType == -2 || targetType == 1 || targetType == -3 || targetType == 12) && (orgLen == 0L && targetLen == 1L || orgLen == 1L && targetLen == 0L)) {
                    arguments3 = new Object[]{this.getName(), targetCol.getJavaSqlTypeName(), new Long(orgLen), new Long(targetLen)};
                    loc.infoT("compareTo ({0}): {1} lengths original {2} target {3} (0 == 1)", arguments3);
                } else {
                    if (orgLen > targetLen) {
                        plan.setLengthIsChanged(true);
                        Object[] arguments4 = new Object[]{this.getName(), new Long(orgLen), new Long(targetLen)};
                        loc.errorT("compareTo ({0}): conversion necessary: original length {1} greater than target length {2}", arguments4);
                        loc.exiting();
                        return new DbColumnDifference(this, target, plan, Action.CONVERT);
                    }
                    if (orgLen < targetLen) {
                        if (varbinaryBinarySituation) {
                            arguments3 = new Object[]{this.getName(), new Long(orgLen), new Long(targetLen)};
                            loc.errorT("compareTo ({0}): original VARBINARY({1}) target BINARY({2})", arguments3);
                        }
                        plan.setLengthIsChanged(true);
                    }
                }
                if (this.getDecimals() != targetCol.getDecimals()) {
                    plan.setDecimalsAreChanged(true);
                    long precOrigin = this.getLength() - (long)this.getDecimals();
                    long precTarget = targetCol.getLength() - (long)targetCol.getDecimals();
                    if (precOrigin > precTarget) {
                        Object[] arguments5 = new Object[]{this.getName(), new Long(precOrigin), new Long(precTarget)};
                        loc.errorT("compareTo ({0}): conversion necessary: original precision {1} greater than target precision {2}", arguments5);
                        loc.exiting();
                        return new DbColumnDifference(this, target, null, Action.CONVERT);
                    }
                    if (precTarget > precOrigin) {
                        // empty if block
                    }
                }
            }
            if (this.isNotNull() != targetCol.isNotNull()) {
                if (varbinaryBinarySituation) {
                    arguments = new Object[]{this.getName()};
                    if (this.isNotNull()) {
                        loc.errorT("compareTo ({0}): original VARBINARY NOT NULL target BINARY NULL", arguments);
                    } else {
                        loc.errorT("compareTo ({0}): original VARBINARY NULL target BINARY NOT NULL", arguments);
                    }
                }
                plan.setNullabilityIsChanged(true);
            }
            String orgDefVal = this.getDefaultValue();
            String targetDefVal = targetCol.getDefaultValue();
            if (orgDefVal != null || targetDefVal != null) {
                if (orgDefVal == null && targetDefVal != null || orgDefVal != null && targetDefVal == null) {
                    if (varbinaryBinarySituation) {
                        Object[] arguments6 = new Object[]{this.getName(), orgDefVal != null ? "default " + orgDefVal : "no default", targetDefVal != null ? "default " + targetDefVal : "no default"};
                        loc.errorT("compareTo ({0}): original VARBINARY {1} target BINARY {2}", arguments6);
                    }
                    plan.setDefaultValueIsChanged(true);
                } else if (!orgDefVal.equals(targetDefVal)) {
                    boolean differs = true;
                    switch (targetType) {
                        case -5: 
                        case 4: 
                        case 5: {
                            try {
                                long targetIntVal = Long.valueOf(targetDefVal);
                                long orgIntVal = Long.valueOf(orgDefVal);
                                differs = targetIntVal != orgIntVal;
                            }
                            catch (Exception ex) {
                                Object[] arguments7 = new Object[]{this.getName(), orgDefVal, targetDefVal, ex.getMessage()};
                                loc.infoT("compareTo ({0}): integer interpretation of defaults (old {1}, new {2}) failed: {3}", arguments7);
                            }
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 8: {
                            try {
                                double targetFloatVal = Double.valueOf(targetDefVal);
                                double orgFloatVal = Double.valueOf(orgDefVal);
                                differs = targetFloatVal != orgFloatVal;
                            }
                            catch (Exception ex) {
                                Object[] arguments8 = new Object[]{this.getName(), orgDefVal, targetDefVal, ex.getMessage()};
                                loc.infoT("compareTo ({0}): floating point interpretation of defaults (old {1}, new {2}) failed: {3}", arguments8);
                            }
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            try {
                                String fmtStr = null;
                                if (targetType == 91) {
                                    fmtStr = "yyyy-MM-dd";
                                } else if (targetType == 92) {
                                    fmtStr = "HH:mm:ss.SSS";
                                } else if (targetType == 93) {
                                    fmtStr = "yyyy-MM-dd HH:mm:ss.SSS";
                                }
                                SimpleDateFormat dateFormatter = (SimpleDateFormat)targetCol.getJavaSqlTypeInfo().getFormatterForDefaultString();
                                Date datetime = dateFormatter.parse(targetDefVal);
                                SimpleDateFormat myFormatter = new SimpleDateFormat(fmtStr);
                                targetDefVal = myFormatter.format(datetime);
                                boolean bl = differs = !orgDefVal.equals(targetDefVal);
                                if (!differs) break;
                                if (orgDefVal.startsWith(targetDefVal)) {
                                    String rest = orgDefVal.substring(targetDefVal.length());
                                    differs = !rest.equals(" 00:00:00.000");
                                    break;
                                }
                                if (orgDefVal.endsWith(targetDefVal)) {
                                    String rest = orgDefVal.substring(0, orgDefVal.length() - targetDefVal.length());
                                    differs = !rest.equals("1900-01-01 ");
                                    break;
                                }
                                differs = true;
                            }
                            catch (Exception ex) {
                                Object[] arguments9 = new Object[]{this.getName(), orgDefVal, targetDefVal, ex.getMessage()};
                                loc.infoT("compareTo ({0}): date interpretation of defaults (old {1}, new {2}) failed: {3}", arguments9);
                            }
                            break;
                        }
                        default: {
                            differs = true;
                            if (!varbinaryBinarySituation) break;
                            Object[] arguments10 = new Object[]{this.getName(), orgDefVal, targetDefVal};
                            loc.errorT("compareTo ({0}): original VARBINARY default {1} target BINARY default {2}", arguments10);
                        }
                    }
                    plan.setDefaultValueIsChanged(differs);
                }
            }
            if (plan.somethingIsChanged()) {
                Object[] arguments11 = new Object[]{this.getName()};
                if (varbinaryBinarySituation) {
                    loc.errorT("compareTo ({0}): column definition changed", arguments11);
                    loc.exiting();
                    return new DbColumnDifference(this, target, plan, Action.CONVERT);
                }
                if (originalType == 2004 || originalType == 2005 || originalType == -4 || originalType == -1) {
                    loc.infoT("compareTo ({0}): column definition changed, ALTER not possible for image/text fields", arguments11);
                    loc.exiting();
                    return new DbColumnDifference(this, target, plan, Action.CONVERT);
                }
                loc.infoT("compareTo ({0}): column definition changed but can be handled by ALTER", arguments11);
                loc.exiting();
                return new DbColumnDifference(this, target, plan, Action.ALTER);
            }
            loc.exiting();
            return null;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("compareTo ({0}) failed: {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public boolean acceptedAdd() {
        return !super.isNotNull() || super.getDefaultValue() != null;
    }

    public boolean acceptedDrop() {
        return true;
    }

    public boolean checkNameLength() {
        boolean check;
        loc.entering("checkNameLength");
        int nameLen = this.getName().length();
        boolean bl = check = nameLen > 0 && nameLen <= 128;
        if (!check) {
            Object[] arguments = new Object[]{this.getName(), new Integer(nameLen)};
            loc.errorT("checkNameLength {0}: length {1} invalid (allowed range [1..128])", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        boolean check;
        loc.entering("checkNameForReservedWord");
        boolean bl = check = !DbMssEnvironment.isReservedWord(this.getName());
        if (!check) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("checkNameForReservedWord: {0} is reserved", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkTypeAttributes() {
        loc.entering("checkTypeAttributes");
        boolean check = true;
        switch (this.getJavaSqlType()) {
            case 2: 
            case 3: {
                Object[] arguments;
                long len = this.getLength();
                if (len < 0L || len > 38L) {
                    check = false;
                    arguments = new Object[]{this.getName(), new Long(len)};
                    loc.errorT("checkTypeAttributes {0}: a length of {1} is invalid for decimal-fields (allowed range [1..38])", arguments);
                }
                if (len >= (long)this.getDecimals()) break;
                check = false;
                arguments = new Object[]{this.getName(), new Integer(this.getDecimals()), new Long(len)};
                loc.errorT("checkTypeAttributes {0}: scale {1} is greater than precision {2}", arguments);
                break;
            }
            case -3: 
            case -2: {
                long len = this.getLength();
                if (len >= 0L && len <= 8000L) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len)};
                loc.errorT("checkTypeAttributes {0}: length of {1} is out of range for binary-fields (allowed range [1..8000])", arguments);
                break;
            }
            case 1: 
            case 12: {
                long len = this.getLength();
                if (len >= 0L && len <= 4000L) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len)};
                loc.errorT("checkTypeAttributes {0}: length of {1} is out of range for character-fields (allowed range [1..4000])", arguments);
            }
        }
        loc.exiting();
        return check;
    }
}

