/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.inf;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Location;

public class DbInfColumn
extends DbColumn {
    public DbInfColumn(DbFactory factory) {
        super(factory);
    }

    public DbInfColumn(DbFactory factory, DbColumn other) {
        super(factory, other);
    }

    public DbInfColumn(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
    }

    public DbInfColumn(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        if (dbType.equalsIgnoreCase("NCHAR")) {
            if (length % 3L != 0L) {
                Logger.setLoggingConfiguration("default");
                Location loc = Logger.getLocation("inf.DbInfColumn");
                loc.entering("inf.DbInfColumn()");
                loc.warningT("<<< Dbtype conversion of CHAR(n): n is not a integer multiple of 3 >>>");
            }
            javaSqlType = 1;
            length = (int)(length / 3L);
        } else if (dbType.equalsIgnoreCase("NVARCHAR")) {
            if (length % 3L != 0L) {
                Logger.setLoggingConfiguration("default");
                Location loc = Logger.getLocation("inf.DbInfColumn");
                loc.entering("inf.DbInfColumn()");
                loc.warningT("<<< Dbtype conversion of NVARCHAR(n): n is not a integer multiple of 3 >>>");
            }
            javaSqlType = 12;
            length = (int)(length / 3L);
        } else if (dbType.equalsIgnoreCase("BLOB")) {
            javaSqlType = 2004;
            length = 0L;
        } else if (dbType.equalsIgnoreCase("CLOB")) {
            javaSqlType = 2005;
            length = 0L;
        } else if (dbType.equalsIgnoreCase("SMALLINT")) {
            javaSqlType = 5;
        } else if (dbType.equalsIgnoreCase("INTEGER")) {
            javaSqlType = 4;
        } else if (dbType.equalsIgnoreCase("INT8")) {
            javaSqlType = -5;
        } else if (dbType.equalsIgnoreCase("DECIMAL")) {
            javaSqlType = 3;
        } else if (dbType.equalsIgnoreCase("FLOAT")) {
            javaSqlType = 8;
        } else if (dbType.equalsIgnoreCase("DATE")) {
            javaSqlType = 91;
        } else if (dbType.equalsIgnoreCase("DATETIME") && length == 1642L) {
            javaSqlType = 93;
        } else if (dbType.equalsIgnoreCase("DATETIME") && length == 4879L) {
            javaSqlType = 92;
        }
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public String getTypeClauseForDdl() throws Exception {
        String clause = "";
        clause = super.getDdlTypeClause();
        return clause;
    }

    public String getDdlDefaultValueClause() throws Exception {
        String clause = "";
        clause = super.getDdlDefaultValueClause();
        return clause;
    }

    public String getDdlClause() throws Exception {
        String clause = " ";
        clause = "\"" + this.getName().toUpperCase() + "\" " + this.getDdlTypeClause() + " " + this.getDdlDefaultValueClause() + " ";
        if (this.isNotNull()) {
            clause = clause + "NOT NULL";
        }
        return clause;
    }

    public boolean check() {
        boolean checkResult = false;
        checkResult = super.check();
        return checkResult;
    }

    public DbColumnDifference compareTo(DbColumn target) {
        Object colDiff = null;
        DbInfColumn targetCol = null;
        DbColumnDifferencePlan plan = new DbColumnDifferencePlan();
        targetCol = (DbInfColumn)target;
        if (this.getJavaSqlType() != targetCol.getJavaSqlType()) {
            plan.setTypeIsChanged(true);
        }
        if (this.getJavaSqlTypeInfo().hasLengthAttribute() && this.getLength() != targetCol.getLength()) {
            plan.setLengthIsChanged(true);
            if (this.getLength() > targetCol.getLength()) {
                return new DbColumnDifference(this, target, plan, Action.CONVERT);
            }
        }
        if (this.getDecimals() != targetCol.getDecimals()) {
            long precTarget;
            plan.setDecimalsAreChanged(true);
            if (this.getDecimals() > targetCol.getDecimals()) {
                return new DbColumnDifference(this, target, plan, Action.CONVERT);
            }
            long precOrigin = this.getLength() - (long)this.getDecimals();
            if (precOrigin > (precTarget = targetCol.getLength() - (long)targetCol.getDecimals())) {
                return new DbColumnDifference(this, target, plan, Action.CONVERT);
            }
        }
        if (this.isNotNull() != targetCol.isNotNull()) {
            plan.setNullabilityIsChanged(true);
            if (targetCol.isNotNull() && targetCol.getDefaultValue() == null) {
                return new DbColumnDifference(this, target, plan, Action.CONVERT);
            }
        }
        if (this.getDefaultValue() == null) {
            plan.setDefaultValueIsChanged(targetCol.getDefaultValue() != null);
        } else {
            plan.setDefaultValueIsChanged(!this.getDefaultValue().equals(targetCol.getDefaultValue()));
        }
        if (plan.somethingIsChanged()) {
            return new DbColumnDifference(this, target, plan, Action.ALTER);
        }
        return null;
    }

    public boolean acceptedAdd() {
        return true;
    }

    public boolean acceptedDrop() {
        return false;
    }

    public String getDdlTypeClause() throws Exception {
        String clause = "";
        long byteLength = this.getLength();
        if (this.getJavaSqlTypeInfo().getDdlName() == "NVARCHAR" && this.getLength() > 85L) {
            clause = "LVARCHAR";
        } else if (this.getJavaSqlTypeName().compareToIgnoreCase("VARBINARY") == 0) {
            long charLength = this.getLength() + 2L;
            clause = "CHAR(" + charLength + ")";
        } else {
            clause = super.getDdlTypeClause();
        }
        return clause;
    }
}

