/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class DbSqlStatement
implements DbsConstants {
    LinkedList statementLines = new LinkedList();
    StringBuffer statement = new StringBuffer(300);
    boolean isDrop = false;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbObjectSqlStatements == null ? (class$com$sap$dictionary$database$dbs$DbObjectSqlStatements = DbSqlStatement.class$("com.sap.dictionary.database.dbs.DbObjectSqlStatements")) : class$com$sap$dictionary$database$dbs$DbObjectSqlStatements));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbObjectSqlStatements;

    public DbSqlStatement() {
    }

    public DbSqlStatement(boolean isDrop) {
        this.isDrop = isDrop;
    }

    public void addLine(String line) {
        this.statement.append(line);
        this.statementLines.add(line);
    }

    public boolean execute(Connection con) {
        try {
            Statement statementObject = NativeSQLAccess.createNativeStatement((Connection)con);
            try {
                statementObject.executeUpdate(this.statement.toString());
                statementObject.close();
                cat.info(loc, DbsConstants.STATEMENT_EXEC_SU, new Object[]{this.statement});
                return true;
            }
            catch (SQLException ex) {
                return this.analyseError(con, ex);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception caught while preparing Statement\n" + this.statement);
            cat.error(loc, DbsConstants.STATEMENT_PREP_EX, new Object[]{this.statement.toString()});
            return false;
        }
    }

    public boolean analyseError(Connection con, SQLException sqlEx) {
        Object dbName = null;
        try {
            if (Database.getDatabase(con).getAbbreviation().equalsIgnoreCase("Sap") && sqlEx.getErrorCode() == -4004 || this.isDrop) {
                cat.info(loc, DbsConstants.NO_DROP_ERROR, new Object[0]);
                return true;
            }
            cat.error(loc, DbsConstants.STATEMENT_EXEC_EX, new Object[]{sqlEx.getMessage(), this.statement});
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void merge(DbSqlStatement other) {
        this.statementLines.addAll(other.statementLines);
        this.statement.append(other.statement.toString());
    }

    public boolean equals(DbSqlStatement other) {
        if (this.statement.toString().trim().equals(other.statement.toString().trim())) {
            return true;
        }
        System.out.println(this.statement.toString().trim());
        System.out.println(other.statement.toString());
        return false;
    }

    public String toString() {
        Iterator iterator = this.statementLines.iterator();
        String s = " ";
        while (iterator.hasNext()) {
            s = s + iterator.next() + "\n";
        }
        return s;
    }

    public boolean isEmpty() {
        return this.statementLines.isEmpty();
    }

    public boolean isDrop() {
        return this.isDrop;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

