/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectModificationAnalyser;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.DbsSeverity;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.LoggingConfiguration;
import com.sap.dictionary.database.dbs.RuntimeObjectTable;
import com.sap.dictionary.database.dbs.XmlExtractor;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.services.OpenSQLServices;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xml.sax.InputSource;

public class DbModificationManager
implements DbsSeverity,
DbsConstants {
    private DbFactory factory = null;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbModificationManager == null ? (class$com$sap$dictionary$database$dbs$DbModificationManager = DbModificationManager.class$("com.sap.dictionary.database.dbs.DbModificationManager")) : class$com$sap$dictionary$database$dbs$DbModificationManager));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbModificationManager;

    public DbModificationManager(DbFactory factory) {
        this.factory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int distribute(String archiveFileName, String logFileName) {
        DbObjectModificationAnalyser modifier = null;
        Object executor = null;
        int rc = 0;
        XmlMap tableMap = new XmlMap();
        DbTable tabViaXml = null;
        long tmst = 0L;
        if (!Logger.hasLogs(cat) && !Logger.hasLogs(loc)) {
            LoggingConfiguration.setProperty("default", "log[file].pattern", logFileName);
            Logger.setLoggingConfiguration("default");
        } else {
            LoggingConfiguration.setProperty("default", "log[file].pattern", logFileName);
            Logger.setLoggingConfiguration("default");
        }
        rc = 0;
        loc.infoT("$Id: //tc/DictionaryDatabase/630_VAL_REL/src/_dictionary_database_dbs/java/com/sap/dictionary/database/dbs/DbModificationManager.java#1 $");
        cat.info(loc, DbsConstants.DEPLOYMENT_START);
        if (this.factory.getConnection() == null) {
            cat.error(loc, DbsConstants.CONNECTION_ERROR);
            return 3;
        }
        RuntimeObjectTable rt = new RuntimeObjectTable(this.factory, "BC_DDDBTABLERT");
        cat.info(loc, DbsConstants.RTTABLES_CREATE);
        if (!rt.createIfNecessary()) {
            cat.error(loc, DbsConstants.RTTABLES_CREATE_ERR);
            return 3;
        }
        RuntimeObjectTable rtE = new RuntimeObjectTable(this.factory, "BC_DDDBRTX");
        if (!rtE.createIfNecessary()) {
            cat.error(loc, DbsConstants.RTTABLES_CREATE_ERR);
            return 3;
        }
        boolean isExecuted = false;
        Object jStream = null;
        ZipFile jFile = null;
        Enumeration<? extends ZipEntry> jEntries = null;
        ZipEntry je = null;
        int i = 0;
        byte[] buff = new byte[1024];
        Object baos = null;
        Object bais = null;
        try {
            jFile = new ZipFile(archiveFileName);
            jEntries = jFile.entries();
        }
        catch (IOException ex) {
            cat.error(loc, DbsConstants.SDA_FILEREAD_ERR);
            return 3;
        }
        try {
            while (jEntries.hasMoreElements()) {
                je = jEntries.nextElement();
                if (!je.getName().endsWith(".gdbtable")) continue;
                String archiveName = je.getName();
                String tabname = archiveName.substring(0, archiveName.indexOf("."));
                if (i == 0) {
                    cat.info(loc, DbsConstants.ANALYSE_START, new Object[]{this.factory.getDatabaseName()});
                    tmst = new Date().getTime();
                }
                ++i;
                cat.info(loc, DbsConstants.NEXT_ARCHIVE_OBJECT, new Object[]{archiveName});
                try {
                    XmlExtractor extractor = new XmlExtractor();
                    tableMap = extractor.map(new InputSource(jFile.getInputStream(je)));
                    modifier = new DbObjectModificationAnalyser(this.factory, tableMap);
                    DbObjectSqlStatements statements = modifier.modify();
                    if (statements != null) {
                        cat.infoT(loc, statements.toString());
                        isExecuted = statements.execute(this.factory);
                    }
                    if (statements == null && modifier.getAction() != Action.CONVERT || isExecuted) {
                        block34: {
                            try {
                                rt.setTimestamp(tmst);
                                if (modifier.getAction() == Action.DROP) {
                                    if (rt.xmlDelete(tabname)) {
                                        cat.info(loc, DbsConstants.RTXML_DBDELETE_SUCC, new Object[]{tabname});
                                    } else {
                                        rc = 2;
                                        cat.warning(loc, DbsConstants.RTXML_DBDELETE_ERR, new Object[]{tabname});
                                    }
                                    if (rtE.xmlDelete(tabname)) {
                                        cat.info(loc, DbsConstants.RTXML_DBDELETE_SUCC, new Object[]{tabname});
                                        break block34;
                                    } else {
                                        rc = 2;
                                        cat.warning(loc, DbsConstants.RTXML_DBDELETE_ERR, new Object[]{tabname});
                                    }
                                    break block34;
                                }
                                tabViaXml = this.factory.makeTable();
                                tabViaXml.setCommonContentViaXml(tableMap);
                                tabViaXml.getColumns().setDatabasePosition();
                                tabname = tabViaXml.getName();
                                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                PrintWriter writer = new PrintWriter(outStream, true);
                                tabViaXml.writeCommonContentToXmlFile(writer, "");
                                rt.xmlWriteHeader(tabname);
                                byte[] byteArray = outStream.toByteArray();
                                ByteArrayInputStream inStream = new ByteArrayInputStream(byteArray);
                                if (rt.xmlWrite(tabname, inStream)) {
                                    cat.info(loc, DbsConstants.RTXML_DBWRITE_SUCC, new Object[]{tabname});
                                } else {
                                    rc = 3;
                                    cat.error(loc, DbsConstants.RTXML_DBWRITE_ERR, new Object[]{tabname});
                                }
                                inStream = new ByteArrayInputStream(byteArray);
                                if (rtE.xmlWriteWithLines(tabname, inStream)) {
                                    cat.info(loc, DbsConstants.RTXML_DBWRITE_SUCC, new Object[]{tabname});
                                } else {
                                    rc = 3;
                                    cat.error(loc, DbsConstants.RTXML_DBWRITE_ERR, new Object[]{tabname});
                                }
                            }
                            catch (Exception ex) {
                                rc = 3;
                                cat.error(loc, DbsConstants.RTXML_DBWRITE_ERR, new Object[]{tabname});
                                JddException.log(ex, cat, 500, loc);
                            }
                        }
                        try {
                            OpenSQLServices.invalidateTable((Connection)this.factory.getConnection(), (String)tabname);
                        }
                        catch (SQLException ex) {
                            rc = 2;
                            cat.warning(loc, DbsConstants.BUFFER_RESET_FAILURE, new Object[]{tabname});
                            JddException.log(ex, cat, 400, loc);
                        }
                        try {
                            this.factory.getConnection().commit();
                        }
                        catch (SQLException ex) {
                            rc = 3;
                            cat.error(loc, DbsConstants.COMMIT_NOT_SEND);
                            JddException.log(ex, cat, 500, loc);
                        }
                        continue;
                    }
                    if (modifier.getAction() != Action.CONVERT) {
                        cat.error(loc, DbsConstants.STMTS_EXEC_ERR);
                        rc = 3;
                        continue;
                    }
                    if (modifier.getAction() != Action.CONVERT) continue;
                    cat.error(loc, DbsConstants.CNV_NOT_POSSIBLE_ERR);
                    rc = 3;
                }
                catch (JddException ex) {
                    ex.printStackTrace();
                    cat.error(loc, DbsConstants.TABLE_ANALYSE_ERR);
                    JddException.log(ex, cat, 500, loc);
                    rc = 3;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (i == 0) {
            cat.info(loc, DbsConstants.ARCHIVE_IS_EMPTY);
            return 2;
        }
        if (rc == 3) {
            cat.info(loc, DbsConstants.MOD_FINISHWITH_ERR);
            return rc;
        }
        if (rc == 2) {
            cat.info(loc, DbsConstants.MOD_FINISHWITH_WARN);
            return rc;
        }
        cat.info(loc, DbsConstants.MOD_FINISHWITH_SUCC);
        return rc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

