/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbAnalyser;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbEnvironment;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexDifference;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.database.dbs.JavaSqlTypes;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlMap;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DbFactory {
    private Connection connection = null;
    private Database database = null;
    private DbEnvironment environment = null;
    private JavaSqlTypes javaSqlTypes = null;
    private Class dbAnalyserClass = null;
    private Class dbEnvironmentClass = null;
    private Class dbColumnsDifferenceClass = null;
    private Constructor dbEnvironmentConstructor = null;
    private Constructor dbTableConstructorViaXml = null;
    private Constructor dbTableConstructorCopy = null;
    private Constructor dbTableConstructor = null;
    private Constructor dbTableConstructorViaDb = null;
    private Constructor dbPrimaryKeyConstructor = null;
    private Constructor dbPrimaryKeyConstructorCopy = null;
    private Constructor dbPrimaryKeyConstructorSingle = null;
    private Constructor dbIndexConstructor = null;
    private Constructor dbIndexConstructor1 = null;
    private Constructor dbIndexConstructorCopy = null;
    private Constructor dbIndexConstructor2 = null;
    private Constructor dbColumnsConstructor = null;
    private Constructor dbColumnsConstructorCopy = null;
    private Constructor dbColumnsConstructorViaXml = null;
    private Constructor dbColumnConstructor = null;
    private Constructor dbColumnConstructorCopy = null;
    private Constructor dbColumnConstructorViaXml = null;
    private Constructor dbColumnConstructorViaDb = null;
    private Constructor javaSqlTypeInfoConstructor = null;
    private Constructor dbIndexDifferenceConstructor = null;
    private Constructor dbPrimaryKeyDifferenceConstructor = null;
    private Constructor dbTableDifferenceConstructor = null;
    public final String PACKAGE = "com.sap.dictionary.database";
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbFactory;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbColumn;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$XmlMap;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbColumns;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbTable;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbSchema;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbPrimaryKey;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbIndex;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$Action;
    static /* synthetic */ Class class$java$sql$Connection;

    public DbFactory(Connection connection) throws JddException {
        this.connection = connection;
        try {
            String abbr = Database.getDatabase(connection).getAbbreviation();
            this.initialize(abbr);
            this.environment = this.makeEnvironment(connection);
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public DbFactory(String url, String user, String passwd) throws JddException {
        try {
            this.connection = DriverManager.getConnection(url, user, passwd);
            String abbr = Database.getDatabase(this.connection).getAbbreviation();
            this.initialize(abbr);
            this.environment = this.makeEnvironment(this.connection);
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public DbFactory(Database database) {
        this.database = database;
        String abbr = database.getAbbreviation();
        this.initialize(abbr);
        try {
            this.environment = this.makeEnvironment();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initialize(String abbr) {
        try {
            String packageName = "com.sap.dictionary.database." + abbr.toLowerCase() + ".";
            this.dbAnalyserClass = Class.forName(packageName + "Db" + abbr + "Analyser");
            this.dbEnvironmentClass = Class.forName(packageName + "Db" + abbr + "Environment");
            this.dbColumnsDifferenceClass = Class.forName(packageName + "Db" + abbr + "ColumnsDifference");
            Class[] argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory};
            this.dbColumnConstructor = Class.forName(packageName + "Db" + abbr + "Column").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbColumn == null ? (class$com$sap$dictionary$database$dbs$DbColumn = DbFactory.class$("com.sap.dictionary.database.dbs.DbColumn")) : class$com$sap$dictionary$database$dbs$DbColumn};
            this.dbColumnConstructorCopy = Class.forName(packageName + "Db" + abbr + "Column").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$XmlMap == null ? (class$com$sap$dictionary$database$dbs$XmlMap = DbFactory.class$("com.sap.dictionary.database.dbs.XmlMap")) : class$com$sap$dictionary$database$dbs$XmlMap};
            this.dbColumnConstructorViaXml = Class.forName(packageName + "Db" + abbr + "Column").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String, Long.TYPE, Integer.TYPE, Boolean.TYPE, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String};
            this.dbColumnConstructorViaDb = Class.forName(packageName + "Db" + abbr + "Column").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory};
            this.dbColumnsConstructor = Class.forName(packageName + "Db" + abbr + "Columns").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbColumns == null ? (class$com$sap$dictionary$database$dbs$DbColumns = DbFactory.class$("com.sap.dictionary.database.dbs.DbColumns")) : class$com$sap$dictionary$database$dbs$DbColumns};
            this.dbColumnsConstructorCopy = Class.forName(packageName + "Db" + abbr + "Columns").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$XmlMap == null ? (class$com$sap$dictionary$database$dbs$XmlMap = DbFactory.class$("com.sap.dictionary.database.dbs.XmlMap")) : class$com$sap$dictionary$database$dbs$XmlMap};
            this.dbColumnsConstructorViaXml = Class.forName(packageName + "Db" + abbr + "Columns").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
            this.javaSqlTypeInfoConstructor = Class.forName(packageName + "Java" + abbr + "SqlTypeInfo").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory};
            this.dbTableConstructorViaXml = Class.forName(packageName + "Db" + abbr + "Table").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbTable == null ? (class$com$sap$dictionary$database$dbs$DbTable = DbFactory.class$("com.sap.dictionary.database.dbs.DbTable")) : class$com$sap$dictionary$database$dbs$DbTable};
            this.dbTableConstructorCopy = Class.forName(packageName + "Db" + abbr + "Table").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String};
            this.dbTableConstructor = Class.forName(packageName + "Db" + abbr + "Table").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbSchema == null ? (class$com$sap$dictionary$database$dbs$DbSchema = DbFactory.class$("com.sap.dictionary.database.dbs.DbSchema")) : class$com$sap$dictionary$database$dbs$DbSchema, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String};
            this.dbTableConstructorViaDb = Class.forName(packageName + "Db" + abbr + "Table").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory};
            this.dbPrimaryKeyConstructor = Class.forName(packageName + "Db" + abbr + "PrimaryKey").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbPrimaryKey == null ? (class$com$sap$dictionary$database$dbs$DbPrimaryKey = DbFactory.class$("com.sap.dictionary.database.dbs.DbPrimaryKey")) : class$com$sap$dictionary$database$dbs$DbPrimaryKey};
            this.dbPrimaryKeyConstructorCopy = Class.forName(packageName + "Db" + abbr + "PrimaryKey").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbSchema == null ? (class$com$sap$dictionary$database$dbs$DbSchema = DbFactory.class$("com.sap.dictionary.database.dbs.DbSchema")) : class$com$sap$dictionary$database$dbs$DbSchema, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String};
            this.dbPrimaryKeyConstructorSingle = Class.forName(packageName + "Db" + abbr + "PrimaryKey").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory};
            this.dbIndexConstructor = Class.forName(packageName + "Db" + abbr + "Index").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String};
            this.dbIndexConstructor1 = Class.forName(packageName + "Db" + abbr + "Index").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbIndex == null ? (class$com$sap$dictionary$database$dbs$DbIndex = DbFactory.class$("com.sap.dictionary.database.dbs.DbIndex")) : class$com$sap$dictionary$database$dbs$DbIndex};
            this.dbIndexConstructorCopy = Class.forName(packageName + "Db" + abbr + "Index").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbFactory == null ? (class$com$sap$dictionary$database$dbs$DbFactory = DbFactory.class$("com.sap.dictionary.database.dbs.DbFactory")) : class$com$sap$dictionary$database$dbs$DbFactory, class$com$sap$dictionary$database$dbs$DbSchema == null ? (class$com$sap$dictionary$database$dbs$DbSchema = DbFactory.class$("com.sap.dictionary.database.dbs.DbSchema")) : class$com$sap$dictionary$database$dbs$DbSchema, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DbFactory.class$("java.lang.String")) : class$java$lang$String};
            this.dbIndexConstructor2 = Class.forName(packageName + "Db" + abbr + "Index").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbIndex == null ? (class$com$sap$dictionary$database$dbs$DbIndex = DbFactory.class$("com.sap.dictionary.database.dbs.DbIndex")) : class$com$sap$dictionary$database$dbs$DbIndex, class$com$sap$dictionary$database$dbs$DbIndex == null ? (class$com$sap$dictionary$database$dbs$DbIndex = DbFactory.class$("com.sap.dictionary.database.dbs.DbIndex")) : class$com$sap$dictionary$database$dbs$DbIndex, class$com$sap$dictionary$database$dbs$Action == null ? (class$com$sap$dictionary$database$dbs$Action = DbFactory.class$("com.sap.dictionary.database.dbs.Action")) : class$com$sap$dictionary$database$dbs$Action};
            this.dbIndexDifferenceConstructor = Class.forName(packageName + "Db" + abbr + "IndexDifference").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbPrimaryKey == null ? (class$com$sap$dictionary$database$dbs$DbPrimaryKey = DbFactory.class$("com.sap.dictionary.database.dbs.DbPrimaryKey")) : class$com$sap$dictionary$database$dbs$DbPrimaryKey, class$com$sap$dictionary$database$dbs$DbPrimaryKey == null ? (class$com$sap$dictionary$database$dbs$DbPrimaryKey = DbFactory.class$("com.sap.dictionary.database.dbs.DbPrimaryKey")) : class$com$sap$dictionary$database$dbs$DbPrimaryKey, class$com$sap$dictionary$database$dbs$Action == null ? (class$com$sap$dictionary$database$dbs$Action = DbFactory.class$("com.sap.dictionary.database.dbs.Action")) : class$com$sap$dictionary$database$dbs$Action};
            this.dbPrimaryKeyDifferenceConstructor = Class.forName(packageName + "Db" + abbr + "PrimaryKeyDifference").getConstructor(argsClass);
            argsClass = new Class[]{class$com$sap$dictionary$database$dbs$DbTable == null ? (class$com$sap$dictionary$database$dbs$DbTable = DbFactory.class$("com.sap.dictionary.database.dbs.DbTable")) : class$com$sap$dictionary$database$dbs$DbTable, class$com$sap$dictionary$database$dbs$DbTable == null ? (class$com$sap$dictionary$database$dbs$DbTable = DbFactory.class$("com.sap.dictionary.database.dbs.DbTable")) : class$com$sap$dictionary$database$dbs$DbTable};
            this.dbTableDifferenceConstructor = Class.forName(packageName + "Db" + abbr + "TableDifference").getConstructor(argsClass);
            argsClass = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = DbFactory.class$("java.sql.Connection")) : class$java$sql$Connection};
            this.dbEnvironmentConstructor = Class.forName(packageName + "Db" + abbr + "Environment").getConstructor(argsClass);
        }
        catch (Exception ex) {
            System.out.println("Exception caught in class DbFactory: " + ex.getMessage());
            ex.printStackTrace();
        }
        this.javaSqlTypes = new JavaSqlTypes(this);
    }

    public DbAnalyser makeAnalyser() throws Exception {
        return (DbAnalyser)this.dbAnalyserClass.newInstance();
    }

    public DbEnvironment makeEnvironment() throws Exception {
        return (DbEnvironment)this.dbEnvironmentClass.newInstance();
    }

    public DbEnvironment makeEnvironment(Connection con) throws Exception {
        Object[] args = new Object[]{con};
        return (DbEnvironment)this.createObject(this.dbEnvironmentConstructor, args);
    }

    public Object createObject(Constructor constructor, Object[] arguments) throws Exception {
        Object object = null;
        object = constructor.newInstance(arguments);
        return object;
    }

    public DbTable makeTable() throws Exception {
        Object[] args = new Object[]{this};
        return (DbTable)this.createObject(this.dbTableConstructorViaXml, args);
    }

    public DbTable makeTable(String name) throws Exception {
        Object[] args = new Object[]{this, name};
        return (DbTable)this.createObject(this.dbTableConstructor, args);
    }

    public DbTable makeTable(DbTable other) throws Exception {
        Object[] args = new Object[]{this, other};
        return (DbTable)this.createObject(this.dbTableConstructorCopy, args);
    }

    public DbTable makeTable(DbSchema schema, String name) throws Exception {
        Object[] args = new Object[]{this, schema, name};
        return (DbTable)this.createObject(this.dbTableConstructorViaDb, args);
    }

    public DbIndex makeIndex() throws Exception {
        Object[] args = new Object[]{this};
        return (DbIndex)this.createObject(this.dbIndexConstructor, args);
    }

    public DbIndex makeIndex(DbIndex other) throws Exception {
        Object[] args = new Object[]{this, other};
        return (DbIndex)this.createObject(this.dbIndexConstructorCopy, args);
    }

    public DbIndex makeIndex(String tableName, String name) throws Exception {
        Object[] args = new Object[]{this, tableName, name};
        return (DbIndex)this.createObject(this.dbIndexConstructor1, args);
    }

    public DbIndex makeIndex(DbSchema schema, String tableName, String name) throws Exception {
        Object[] args = new Object[]{this, schema, tableName, name};
        return (DbIndex)this.createObject(this.dbIndexConstructor2, args);
    }

    public DbPrimaryKey makePrimaryKey() throws Exception {
        Object[] args = new Object[]{this};
        return (DbPrimaryKey)this.createObject(this.dbPrimaryKeyConstructor, args);
    }

    public DbPrimaryKey makePrimaryKey(DbPrimaryKey other) throws Exception {
        Object[] args = new Object[]{this, other};
        return (DbPrimaryKey)this.createObject(this.dbPrimaryKeyConstructorCopy, args);
    }

    public DbPrimaryKey makePrimaryKey(DbSchema schema, String tableName) throws Exception {
        Object[] args = new Object[]{this, schema, tableName};
        return (DbPrimaryKey)this.createObject(this.dbPrimaryKeyConstructorCopy, args);
    }

    public DbColumn makeDbColumn() throws Exception {
        Object[] args = new Object[]{this};
        return (DbColumn)this.createObject(this.dbColumnConstructor, args);
    }

    public DbColumn makeDbColumn(DbColumn other) throws Exception {
        Object[] args = new Object[]{this, other};
        return (DbColumn)this.createObject(this.dbColumnConstructorCopy, args);
    }

    public DbColumn makeDbColumn(XmlMap xmlMap) throws Exception {
        Object[] args = new Object[]{this, xmlMap};
        return (DbColumn)this.createObject(this.dbColumnConstructorViaXml, args);
    }

    public DbColumn makeDbColumn(String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) throws Exception {
        Object[] args = new Object[]{this, name, new Integer(position), new Integer(javaSqlType), dbType, new Long(length), new Integer(decimals), new Boolean(isNotNull), defaultValue};
        return (DbColumn)this.createObject(this.dbColumnConstructorViaDb, args);
    }

    public DbColumns makeDbColumns() throws Exception {
        Object[] args = new Object[]{this};
        return (DbColumns)this.createObject(this.dbColumnsConstructor, args);
    }

    public DbColumns makeDbColumns(DbColumns other) throws Exception {
        Object[] args = new Object[]{this, other};
        return (DbColumns)this.createObject(this.dbColumnsConstructorCopy, args);
    }

    public DbColumns makeDbColumns(XmlMap xmlMap) throws Exception {
        Object[] args = new Object[]{this, xmlMap};
        return (DbColumns)this.createObject(this.dbColumnsConstructorViaXml, args);
    }

    public JavaSqlTypeInfo makeJavaSqlTypeInfo(String name, int intCode) throws Exception {
        Object[] args = new Object[]{this, name, new Integer(intCode)};
        return (JavaSqlTypeInfo)this.createObject(this.javaSqlTypeInfoConstructor, args);
    }

    public DbColumnsDifference makeDbColumnsDifference() throws Exception {
        return (DbColumnsDifference)this.dbColumnsDifferenceClass.newInstance();
    }

    public DbIndexDifference makeDbIndexDifference(DbIndex origin, DbIndex target, Action action) throws Exception {
        Object[] args = new Object[]{origin, target, action};
        return (DbIndexDifference)this.createObject(this.dbIndexDifferenceConstructor, args);
    }

    public DbPrimaryKeyDifference makeDbPrimaryKeyDifference(DbPrimaryKey origin, DbPrimaryKey target, Action action) throws Exception {
        Object[] args = new Object[]{origin, target, action};
        return (DbPrimaryKeyDifference)this.createObject(this.dbPrimaryKeyDifferenceConstructor, args);
    }

    public DbTableDifference makeDbTableDifference(DbTable origin, DbTable target) throws Exception {
        Object[] args = new Object[]{origin, target};
        return (DbTableDifference)this.createObject(this.dbTableDifferenceConstructor, args);
    }

    public JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DbEnvironment getEnvironment() {
        return this.environment;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getDatabaseName() {
        if (this.connection != null) {
            try {
                return Database.getDatabase(this.connection).getName();
            }
            catch (Exception ex) {
                return "";
            }
        }
        return this.database.getName();
    }

    public String getSchemaName() throws SQLException {
        return this.environment.getSchemaName();
    }

    public void setJavaSqlTypes(JavaSqlTypes javaSqlTypes) {
        this.javaSqlTypes = javaSqlTypes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

