/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import java.io.PrintWriter;

public class DbDeploymentInfo {
    private String creationDate = " ";
    private String author = " ";
    private String language = " ";
    private String description = " ";
    private Action predefinedAction = null;
    private boolean positionIsRelevant = false;
    private int sizeCategory = 0;
    private boolean isBuffered = false;
    private int genKeyCount = 0;
    private boolean doNotCreate = false;
    private boolean deleteIfExisting = false;
    private XmlMap databaseInfo = null;

    public DbDeploymentInfo() {
    }

    public DbDeploymentInfo(XmlMap xmlMap, DbFactory factory) {
        this.creationDate = xmlMap.getString("creation-date");
        XmlMap properties = xmlMap.getXmlMap("properties");
        this.author = properties.getString("author");
        XmlMap description = properties.getXmlMap("description");
        this.language = description.getString("language");
        this.description = description.getString("description");
        this.predefinedAction = Action.getInstance(xmlMap.getString("predefined-action"));
        this.positionIsRelevant = xmlMap.getBoolean("position-is-relevant");
        XmlMap technicalInfo = xmlMap.getXmlMap("technical-info");
        if (!technicalInfo.isEmpty()) {
            this.sizeCategory = technicalInfo.getInt("size-category");
            this.isBuffered = technicalInfo.getBoolean("is-buffered");
            this.genKeyCount = technicalInfo.getInt("gen-key-count");
        }
        this.databaseInfo = xmlMap.getXmlMap("database-exclusive-info");
        if (!this.databaseInfo.isEmpty() && this.databaseInfo != null) {
            XmlMap nextInfo = new XmlMap();
            int i = 0;
            while (!(nextInfo = this.databaseInfo.getXmlMap("database-exclusive" + (i == 0 ? "" : "" + i))).isEmpty()) {
                if (nextInfo.getString("database").toUpperCase().equalsIgnoreCase(factory.getDatabaseName())) {
                    this.doNotCreate = true;
                    this.deleteIfExisting = nextInfo.getBoolean("delete-if-existing");
                }
                ++i;
            }
        }
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    public Action getPredefinedAction() {
        return this.predefinedAction;
    }

    public boolean positionIsRelevant() {
        return this.positionIsRelevant;
    }

    public boolean doNotCreate() {
        return this.doNotCreate;
    }

    public boolean deleteIfExisting() {
        return this.deleteIfExisting;
    }

    public int getSizeCategory() {
        return this.sizeCategory;
    }

    public boolean isBuffered() {
        return this.isBuffered;
    }

    public int getGenKeyCount() {
        return this.genKeyCount;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPredefinedAction(Action predefinedAction) {
        this.predefinedAction = predefinedAction;
    }

    public void setPositionIsRelevant(boolean positionIsRelevant) {
        this.positionIsRelevant = positionIsRelevant;
    }

    public void setSizeCategory(int sizeCategory) {
        this.sizeCategory = sizeCategory;
    }

    public void setSizeCategory(boolean isBuffered) {
        this.isBuffered = isBuffered;
    }

    public void setGenKeyCount(int genKeyCount) {
        this.genKeyCount = genKeyCount;
    }

    public void writeContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        file.println(offset0 + "<properties>");
        String offset1 = offset0 + XmlHelper.tabulate();
        file.println(offset1 + "<creation-date>" + this.creationDate + "</creation-date>");
        file.println(offset1 + "<author>" + this.author + "</author>");
        file.println(offset1 + "<description language=" + "\"" + this.language + "\"" + ">" + this.description + "</description>");
        file.println(offset0 + "</properties>");
        file.println(offset0 + "<position-is-relevant>" + this.positionIsRelevant + "</position-is-relevant>");
        file.println(offset0 + "<predefined-action>" + (this.predefinedAction == null ? "" : this.predefinedAction.toString()) + "</predefined-action>");
        file.println(offset0 + "<technical-info>");
        file.println(offset1 + "<size-category>" + this.sizeCategory + "</size-category>");
        file.println(offset1 + "<is-buffered>" + this.isBuffered + "</is-buffered>");
        file.println(offset1 + "<gen-key-count>" + this.genKeyCount + "</gen-key-count>");
        file.println(offset0 + "</technical-info>");
        if (!this.databaseInfo.isEmpty() && this.databaseInfo != null) {
            file.println(offset0 + "<database-exclusive-info>");
            XmlMap nextInfo = new XmlMap();
            String offset2 = offset1 + XmlHelper.tabulate();
            int i = 0;
            while (!(nextInfo = this.databaseInfo.getXmlMap("database-exclusive" + (i == 0 ? "" : "" + i))).isEmpty()) {
                file.println(offset1 + "<database-exclusive>");
                file.println(offset2 + "<database>" + nextInfo.getString("database").toUpperCase() + "</database>");
                file.println(offset2 + "<delete-if-existing>" + nextInfo.getBoolean("delete-if-existing") + "</delete-if-existing>");
                file.println(offset1 + "</database-exclusive>");
                ++i;
            }
            file.println(offset0 + "</database-exclusive-info>");
        }
    }

    public String toString() {
        return "Author                : " + this.author + " " + this.creationDate + "\n" + "Description           : " + this.description + "\n" + "Language              : " + this.language + "\n" + "Position is relevant  : " + this.positionIsRelevant + "\n" + "Predefined Action     : " + this.predefinedAction + "\n" + "Size Category         : " + this.sizeCategory + "\n";
    }
}

