/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class DbColumns
implements DbsConstants {
    private DbFactory factory = null;
    private final HashMap columnsViaPosition = new HashMap();
    private final HashMap columnsViaName = new HashMap();
    private DbTable dbTable = null;
    private DbColumn first;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbColumns == null ? (class$com$sap$dictionary$database$dbs$DbColumns = DbColumns.class$("com.sap.dictionary.database.dbs.DbColumns")) : class$com$sap$dictionary$database$dbs$DbColumns));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbColumns;

    public DbColumns() {
    }

    public DbColumns(DbFactory factory) {
        this.factory = factory;
    }

    public DbColumns(DbFactory factory, DbColumns other) {
        this.factory = factory;
    }

    public DbColumns(DbFactory factory, XmlMap xmlMap) throws Exception {
        this.factory = factory;
        XmlMap nextColumn = null;
        int i = 0;
        while (!(nextColumn = xmlMap.getXmlMap("column" + (i == 0 ? "" : "" + i))).isEmpty()) {
            this.add(factory.makeDbColumn(nextColumn));
            ++i;
        }
    }

    public void setContentViaDb(DbFactory factory) throws JddException {
        String tableName = " ";
        DatabaseMetaData dbmd = null;
        boolean found = false;
        loc.entering("dbs.modify()");
        try {
            String schemaName;
            tableName = this.dbTable.getName();
            dbmd = NativeSQLAccess.getNativeMetaData((Connection)factory.getConnection());
            try {
                schemaName = factory.getSchemaName();
            }
            catch (SQLException ex) {
                cat.info(loc, DbsConstants.NO_SCHEMA_NAME);
                schemaName = null;
            }
            ResultSet rs = dbmd.getColumns(null, schemaName, tableName, null);
            while (rs.next()) {
                found = true;
                String colName = rs.getString("COLUMN_NAME");
                short sqlType = rs.getShort("DATA_TYPE");
                String dbType = rs.getString("TYPE_NAME");
                int colSize = rs.getInt("COLUMN_SIZE");
                int decDigits = rs.getInt("DECIMAL_DIGITS");
                String defVal = rs.getString("COLUMN_DEF");
                int pos = rs.getInt("ORDINAL_POSITION");
                boolean isNotNull = rs.getString("IS_NULLABLE").trim().equalsIgnoreCase("NO");
                DbColumn col = factory.makeDbColumn(colName, pos, sqlType, dbType, colSize, decDigits, isNotNull, defVal);
                this.add(col);
            }
            rs.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{tableName};
            throw new JddException(ex, DbsConstants.COLUMN_READ_VIA_DB_ERR, arguments, cat, 500, loc);
        }
        if (!found) {
            Object[] arguments = new Object[]{tableName};
            cat.info(loc, DbsConstants.TABLE_ONDB_NOTFOUND, arguments);
        }
        loc.exiting();
    }

    public void add(DbColumn dbColumn) {
        dbColumn.setColumns(this);
        Integer position = new Integer(dbColumn.getPosition());
        Integer prevPosition = new Integer(position - 1);
        Integer nextPosition = new Integer(position + 1);
        this.columnsViaPosition.put(position, dbColumn);
        this.columnsViaName.put(dbColumn.getName(), dbColumn);
        if (position == 1) {
            this.first = dbColumn;
        }
        if (position > 0) {
            Object prevObject = this.columnsViaPosition.get(prevPosition);
            DbColumn previous = null;
            if (prevObject != null) {
                previous = (DbColumn)prevObject;
            }
            if (previous != null) {
                previous.setNext(dbColumn);
                dbColumn.setPrevious(previous);
            }
        }
        Object nextObject = this.columnsViaPosition.get(nextPosition);
        DbColumn next = null;
        if (nextObject != null) {
            next = (DbColumn)nextObject;
        }
        if (next != null) {
            dbColumn.setNext(next);
            next.setPrevious(dbColumn);
        }
    }

    public DbColumn getFirst() {
        return this.first;
    }

    public DbColumn getColumn(String name) {
        return (DbColumn)this.columnsViaName.get(name);
    }

    public DbColumn getColumn(int position) {
        DbColumn dbColumn = null;
        if (position <= 0) {
            dbColumn = null;
        } else {
            Object obj = this.columnsViaPosition.get(new Integer(position));
            dbColumn = (DbColumn)obj;
        }
        return dbColumn;
    }

    public int getColumnCnt() {
        return this.columnsViaPosition.size();
    }

    public DbColumnIterator iterator() {
        return new DbColumnIterator(this.first);
    }

    public String toString() {
        String s = "";
        int i = 1;
        while (i <= this.columnsViaPosition.size()) {
            s = s + this.getColumn(i);
            ++i;
        }
        return s;
    }

    void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws Exception {
        file.println(offset0 + "<columns>");
        int i = 1;
        while (i <= this.columnsViaPosition.size()) {
            this.getColumn(i).writeCommonContentToXmlFile(file, offset0 + XmlHelper.tabulate());
            ++i;
        }
        file.println(offset0 + "</columns>");
    }

    public DbSqlStatement getDdlClause() throws Exception {
        String line = "";
        DbColumnIterator iterator = this.iterator();
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        while (iterator.hasNext()) {
            line = iterator.next().getDdlClause();
            if (iterator.hasNext()) {
                line = line + ", ";
            }
            colDef.addLine(line);
        }
        colDef.addLine(")");
        return colDef;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DbColumnsDifference compareTo(DbColumns target, boolean positionIsRelevant) throws Exception {
        DbColumnsDifference colsDiff = null;
        colsDiff = this.factory.makeDbColumnsDifference();
        DbColumnDifference colDiff = null;
        DbColumn originCol = null;
        DbColumn targetCol = null;
        Object obj = null;
        int dropFieldsCounter = 0;
        DbColumnDifferencePlan plan = null;
        HashMap targetColsViaName = (HashMap)target.columnsViaName.clone();
        int i = 1;
        while (i <= this.columnsViaPosition.size()) {
            originCol = (DbColumn)this.columnsViaPosition.get(new Integer(i));
            obj = targetColsViaName.remove(originCol.getName());
            if (obj == null) {
                ++dropFieldsCounter;
                if (!originCol.acceptedDrop()) {
                    colDiff = new DbColumnDifference(originCol, null, null, Action.CONVERT);
                    colsDiff.add(colDiff);
                    colsDiff.setAction(Action.CONVERT);
                    return colsDiff;
                }
                colDiff = new DbColumnDifference(originCol, null, null, Action.ALTER);
                colsDiff.add(colDiff);
            } else {
                targetCol = obj;
                if (positionIsRelevant && originCol.getPosition() - dropFieldsCounter != targetCol.getPosition()) {
                    plan = new DbColumnDifferencePlan();
                    plan.setPositionIsChanged(true);
                    colDiff = new DbColumnDifference(originCol, targetCol, plan, Action.CONVERT);
                    colsDiff.add(colDiff);
                    colsDiff.setAction(Action.CONVERT);
                    return colsDiff;
                }
                colDiff = originCol.compareTo(targetCol);
                if (colDiff != null) {
                    colsDiff.add(colDiff);
                    if (colDiff.getAction() == Action.CONVERT) {
                        colsDiff.setAction(Action.CONVERT);
                        return colsDiff;
                    }
                }
            }
            ++i;
        }
        if (!targetColsViaName.isEmpty()) {
            TreeMap<Integer, DbColumn> addedColsViaPosition = new TreeMap<Integer, DbColumn>();
            Collection collection = targetColsViaName.values();
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                DbColumn nextColumn = (DbColumn)iter.next();
                addedColsViaPosition.put(new Integer(nextColumn.getPosition()), nextColumn);
            }
            Collection addedCols = addedColsViaPosition.values();
            iter = addedCols.iterator();
            while (iter.hasNext()) {
                DbColumn addedCol = (DbColumn)iter.next();
                if (!addedCol.acceptedAdd()) {
                    colDiff = new DbColumnDifference(null, addedCol, null, Action.CONVERT);
                    colsDiff.add(colDiff);
                    colsDiff.setAction(Action.CONVERT);
                    return colsDiff;
                }
                colDiff = new DbColumnDifference(null, addedCol, null, Action.ALTER);
                colsDiff.add(colDiff);
            }
        }
        if (colsDiff.isEmpty()) {
            return null;
        }
        return colsDiff;
    }

    public boolean isEmpty() {
        return this.columnsViaName.isEmpty();
    }

    public DbTable getTable() {
        return this.dbTable;
    }

    public void setTable(DbTable dbTable) {
        this.dbTable = dbTable;
    }

    public boolean check() {
        boolean ok = true;
        int i = 1;
        while (i <= this.columnsViaPosition.size()) {
            ok &= this.getColumn(i).check();
            ++i;
        }
        return ok && this.checkNumber();
    }

    public boolean checkNumber() {
        return true;
    }

    public void setDatabasePosition() throws JddException {
        DbTable tableForColumns = null;
        String tableName = null;
        boolean found = false;
        DbColumn col = null;
        try {
            tableName = this.dbTable.getName();
            tableForColumns = this.factory.makeTable(tableName);
            tableForColumns.setColumnsViaDb(this.factory);
            if (!tableForColumns.existsOnDb()) {
                return;
            }
            DbColumnIterator iter = tableForColumns.getColumns().iterator();
            DbColumn nextDbColumn = null;
            while (iter.hasNext()) {
                nextDbColumn = iter.next();
                col = this.getColumn(nextDbColumn.getName());
                if (col == null) {
                    cat.error(loc, DbsConstants.DB_POSITION_OF_FIELD_NOT_SET, new Object[]{nextDbColumn.getName()});
                    throw new JddException();
                }
                col.setPosition(nextDbColumn.getPosition());
            }
        }
        catch (Exception ex) {
            cat.error(loc, DbsConstants.DB_POSITION_OF_FIELDS_NOT_SET);
            throw JddException.createInstance(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

