/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.xml.sax.InputSource;

public class ArchiveEntry {
    InputStream inputStream = null;
    String name = null;
    String inputString = null;
    boolean streamIsLocal = false;
    boolean saveStreamToString = false;

    public ArchiveEntry(String name, InputStream inputStream, boolean streamIsLocal, boolean saveStreamToString) throws IOException {
        this.name = name;
        this.inputStream = inputStream;
        this.saveStreamToString = saveStreamToString;
        if (!streamIsLocal) {
            this.saveStreamToString();
        }
    }

    /*
     * WARNING - void declaration
     */
    void saveStreamToString() throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
        StringBuffer buffer = new StringBuffer();
        while ((s = br.readLine()) != null) {
            void var2_3;
            buffer.append((String)var2_3);
        }
        this.inputString = buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputString != null) {
            return new ByteArrayInputStream(this.inputString.getBytes());
        }
        if (this.saveStreamToString) {
            this.saveStreamToString();
            return new ByteArrayInputStream(this.inputString.getBytes());
        }
        return this.inputStream;
    }

    public InputSource getInputSource() throws IOException {
        if (this.inputString != null) {
            return new InputSource(new StringReader(this.inputString));
        }
        if (this.saveStreamToString) {
            this.saveStreamToString();
            return new InputSource(new StringReader(this.inputString));
        }
        return new InputSource(this.inputStream);
    }

    public Reader getReader() throws IOException {
        if (this.inputString != null) {
            return new StringReader(this.inputString);
        }
        if (this.saveStreamToString) {
            this.saveStreamToString();
            return new StringReader(this.inputString);
        }
        return null;
    }

    public String getString() throws IOException {
        if (this.inputString != null) {
            return this.inputString;
        }
        if (this.saveStreamToString) {
            this.saveStreamToString();
            return this.inputString;
        }
        return this.inputString;
    }

    public int getLength() throws IOException {
        if (this.inputString != null) {
            return this.inputString.length();
        }
        if (this.saveStreamToString) {
            this.saveStreamToString();
            return this.inputString.length();
        }
        return 0;
    }
}

