/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db6;

import com.sap.dictionary.database.db6.DbDb6Environment;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Location;

public class DbDb6ColumnsDifference
extends DbColumnsDifference {
    private static Location loc = Logger.getLocation("db6.DbDb6ColumnsDifference");

    public DbObjectSqlStatements getDdlStatementsForAlter(String tableName) throws Exception {
        DbColumn column;
        DbColumnDifference diff;
        DbObjectSqlStatements alterStatements = new DbObjectSqlStatements(tableName);
        DbSqlStatement statement = new DbSqlStatement();
        DbColumnsDifference.MultiIterator multiIterator = this.iterator();
        boolean alterFlag = false;
        loc.entering("getDdlStatementsForAlter");
        statement.addLine("ALTER TABLE \"" + tableName.toUpperCase() + '\"');
        if (multiIterator.hasNextWithAdd()) {
            alterFlag = true;
            do {
                statement.addLine(" ADD COLUMN " + multiIterator.nextWithAdd().getTarget().getDdlClause());
            } while (multiIterator.hasNextWithAdd());
        }
        while (multiIterator.hasNextWithTypeLenDecChange()) {
            diff = multiIterator.nextWithTypeLenDecChange();
            if (diff.getAction() != Action.ALTER) continue;
            column = diff.getTarget();
            if (column.getJavaSqlType() != -3 && column.getJavaSqlType() != 12) {
                Object[] arguments = new Object[]{column.getName()};
                loc.errorT("getDdlStatementsForAlter failed for column {0} : ALTER COLUMN SET DATA TYPE operations are only allowed for VARCHAR or VARBINARY columns");
                continue;
            }
            statement.addLine(" ALTER COLUMN \"" + column.getName().toUpperCase() + '\"' + " SET DATA TYPE VARCHAR(" + column.getLength() * (long)column.getJavaSqlTypeInfo().getByteFactor() + ") ");
            alterFlag = true;
        }
        if (alterFlag) {
            alterStatements.add(statement);
        }
        if (multiIterator.hasNextWithDefaultValueChange()) {
            diff = multiIterator.nextWithDefaultValueChange();
            DbDb6Environment environment = (DbDb6Environment)diff.getOrigin().getColumns().getTable().getDbFactory().getEnvironment();
            String dbVersion = environment.getDatabaseVersion();
            if (dbVersion == null || dbVersion.compareTo("SQL08020") < 0) {
                loc.errorT("getDdlStatementsForAlter: DB2 Version 8.2 is required to change column default values");
            } else {
                do {
                    column = diff.getTarget();
                    statement = new DbSqlStatement();
                    if (column.getDefaultValue() != null) {
                        statement.addLine("ALTER TABLE \"" + tableName.toUpperCase() + '\"' + " ALTER COLUMN " + '\"' + column.getName().toUpperCase() + '\"' + " SET DEFAULT " + column.getJavaSqlTypeInfo().getDefaultValuePrefix() + column.getDefaultValue() + column.getJavaSqlTypeInfo().getDefaultValueSuffix());
                    } else {
                        statement.addLine("ALTER TABLE \"" + tableName.toUpperCase() + '\"' + " ALTER COLUMN " + '\"' + column.getName().toUpperCase() + '\"' + " DROP DEFAULT ");
                    }
                    alterFlag = true;
                    alterStatements.add(statement);
                } while ((diff = multiIterator.hasNextWithDefaultValueChange() ? multiIterator.nextWithDefaultValueChange() : null) != null);
            }
        }
        if (multiIterator.hasNextWithDrop()) {
            loc.errorT("getDdlStatementsForAlter: DROP COLUMN operations are currently not supported with DB6");
        }
        if (multiIterator.hasNextWithModify()) {
            loc.errorT("getDdlStatementsForAlter: column type changes are currently not supported with DB6");
        }
        if (multiIterator.hasNextWithNullabilityChange()) {
            loc.errorT("getDdlStatementsForAlter: nullability changes are currently not supported with DB6");
        }
        loc.exiting();
        if (alterFlag) {
            return alterStatements;
        }
        return null;
    }
}

