/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db6;

import com.sap.dictionary.database.db6.DbDb6Environment;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Location;

public class DbDb6Column
extends DbColumn {
    private static Location loc = Logger.getLocation("db6.DbDb6Column");

    public DbDb6Column(DbFactory factory) {
        super(factory);
    }

    public DbDb6Column(DbFactory factory, DbColumn other) {
        super(factory, other);
    }

    public DbDb6Column(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
    }

    public DbDb6Column(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        if (dbType.equals("FLOAT")) {
            javaSqlType = 6;
        }
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public String getTypeClauseForDdl() throws Exception {
        String clause = "";
        clause = super.getDdlTypeClause();
        return clause;
    }

    public String getDdlDefaultValueClause() throws Exception {
        String clause = "";
        String defaultVal = null;
        defaultVal = this.getDefaultValue();
        if (defaultVal != null) {
            clause = this.getJavaSqlType() == 91 || this.getJavaSqlType() == 92 || this.getJavaSqlType() == 93 ? (this.getJavaSqlType() == 91 && defaultVal.equals("CURRENT DATE") ? "WITH DEFAULT CURRENT DATE" : (this.getJavaSqlType() == 92 && defaultVal.equals("CURRENT TIME") ? "WITH DEFAULT CURRENT TIME" : (this.getJavaSqlType() == 93 && defaultVal.equals("CURRENT TIMESTAMP") ? "WITH DEFAULT CURRENT TIMESTAMP" : super.getDdlDefaultValueClause()))) : super.getDdlDefaultValueClause() + " COMPRESS SYSTEM DEFAULT";
        }
        return clause;
    }

    public boolean checkNameLength() {
        int nameLen = this.getName().length();
        boolean check = nameLen > 0 && nameLen <= 128;
        loc.entering("checkNameLength");
        if (!check) {
            loc.errorT("checkNameLength: column name length must range from 0 to 128 .");
        }
        loc.exiting();
        return nameLen > 0 && nameLen <= 128;
    }

    public boolean checkNameForReservedWord() {
        return super.checkNameForReservedWord();
    }

    public boolean checkTypeAttributes() {
        boolean check = super.checkTypeAttributes();
        loc.entering("checkTypeAttributes");
        Object[] arguments = new Object[]{this.getName()};
        switch (this.getJavaSqlType()) {
            case 2: 
            case 3: {
                long len = this.getLength();
                if (len < 1L || len > 31L) {
                    loc.errorT("checkTypeAttributes: length of decimal column {0} must range from 1 to 31 .", arguments);
                    check = false;
                }
                if (len >= (long)this.getDecimals()) break;
                loc.errorT("checkTypeAttributes: number of decimals for column {0} is higher than length of decimal column.", arguments);
                check = false;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                long len = this.getLength();
                if (len >= 0L && len <= 16293L) break;
                loc.errorT("checkTypeAttributes: binary column {0} does not fit into 16K tablespace.", arguments);
                check = false;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                long len = this.getLength();
                if (len >= 0L && len <= 5431L) break;
                loc.errorT("checkTypeAttributes: char column {0} does not fit into 16K tablespace.", arguments);
                check = false;
                break;
            }
            case 2004: 
            case 2005: {
                long len = this.getLength();
                if (this.getJavaSqlType() == 2005) {
                    len *= 3L;
                }
                if (len <= 0x40000000L) break;
                loc.errorT("checkTypeAttributes: LOB column {0} exceeds maximum byte length of 1 GB.", arguments);
                check = false;
            }
        }
        loc.exiting();
        return check;
    }

    public DbColumnDifference compareTo(DbColumn target) {
        DbColumnDifference colDiff = null;
        DbDb6Column targetCol = (DbDb6Column)target;
        DbColumnDifferencePlan plan = new DbColumnDifferencePlan();
        JavaSqlTypeInfo tInfo = this.getJavaSqlTypeInfo();
        int originalType = this.getJavaSqlType();
        int targettype = targetCol.getJavaSqlType();
        boolean convertTable = false;
        loc.entering("compareTo");
        Object[] arguments = new Object[]{this.getName()};
        if (originalType == -2 || originalType == -4) {
            originalType = -3;
        }
        if (originalType == 1 || originalType == -1) {
            originalType = 12;
        }
        if (targettype == -2 || targettype == -4) {
            targettype = -3;
        }
        if (targettype == 1 || targettype == -1) {
            targettype = 12;
        }
        if (originalType != targettype) {
            plan.setTypeIsChanged(true);
            loc.infoT("compareTo: column {0}: target column differs in type.", arguments);
            convertTable = true;
        }
        if (tInfo.hasLengthAttribute()) {
            long colLength = this.getLength();
            long targetLength = targetCol.getLength();
            if (colLength == 0L) {
                colLength = tInfo.getDdlDefaultLength() / tInfo.getByteFactor();
            }
            if (targetLength == 0L) {
                targetLength = tInfo.getDdlDefaultLength() / tInfo.getByteFactor();
            }
            if (colLength != targetLength) {
                plan.setLengthIsChanged(true);
                loc.infoT("compareTo: column {0}: target column differs in length.", arguments);
                if (colLength > targetLength || originalType != -3 && originalType != 12 || targetCol.getJavaSqlType() == -2 || this.getJavaSqlType() == 1 || this.getJavaSqlType() == -2) {
                    convertTable = true;
                }
            }
        }
        if (tInfo.hasDecimals() && this.getDecimals() != targetCol.getDecimals()) {
            plan.setDecimalsAreChanged(true);
            loc.infoT("compareTo: column {0}: target column differs in number of decimals.", arguments);
            convertTable = true;
        }
        if (this.isNotNull() != targetCol.isNotNull()) {
            plan.setNullabilityIsChanged(true);
            loc.infoT("compareTo: column {0}: target column differs in nullability.", arguments);
            convertTable = true;
        }
        String origDefault = this.getDefaultValue();
        String targetDefault = targetCol.getDefaultValue();
        if (origDefault == null && targetDefault != null || origDefault != null && targetDefault == null || origDefault != null && targetDefault != null && !origDefault.equals(targetDefault)) {
            plan.setDefaultValueIsChanged(true);
            loc.infoT("compareTo: column {0}: target column differs in default value.", arguments);
            DbDb6Environment environment = (DbDb6Environment)this.getColumns().getTable().getDbFactory().getEnvironment();
            String dbVersion = environment.getDatabaseVersion();
            if (dbVersion == null || dbVersion.compareTo("SQL08020") < 0) {
                convertTable = true;
            }
        }
        if (plan.somethingIsChanged()) {
            if (convertTable) {
                loc.infoT("compareTo: column {0}: a table conversion is required", arguments);
                colDiff = new DbColumnDifference(this, target, plan, Action.CONVERT);
            } else {
                colDiff = new DbColumnDifference(this, target, plan, Action.ALTER);
            }
        }
        loc.exiting();
        return colDiff;
    }

    public boolean acceptedAdd() {
        return true;
    }

    public boolean acceptedDrop() {
        return false;
    }
}

