/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4Environment;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.text.Format;
import java.text.SimpleDateFormat;

public class JavaDb4SqlTypeInfo
extends JavaSqlTypeInfo {
    private static final SimpleDateFormat FDATE_TARGET = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FTIME_TARGET = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat FTIMESTAMP_TARGET = new SimpleDateFormat("yyyy-MM-dd-H.mm.ss.SSS000");
    private Format targetFormatter = null;
    private static Location loc = Logger.getLocation("db4.JavaDb4SqlTypeInfo");
    private static Category cat = Logger.getCategory();
    public static final int VARCHAR_LIMIT = 16346;
    public static final int VARBINARY_LIMIT = 32692;
    public static final int LONGVARCHAR_LIMIT = 0;
    public static final int LONGVARBINARY_LIMIT = 0;
    public static final int VARCHAR_WHERE_CONDITION_LIMIT = 16346;
    public static final int VARBINARY_WHERE_CONDITION_LIMIT = 32692;

    public JavaDb4SqlTypeInfo(DbFactory factory, String name, int intCode) {
        super(factory, name, intCode);
        switch (intCode) {
            case -1: 
            case 12: {
                this.setDdlName("VARGRAPHIC");
                this.setDdlSuffix(" CCSID 13488");
                this.setDefaultValuePrefix("");
                this.setDefaultValueSuffix("");
                this.setByteFactor(1);
                break;
            }
            case -4: 
            case -3: {
                this.setDdlName("VARCHAR");
                this.setDdlSuffix(" FOR BIT DATA");
                break;
            }
            case -2: {
                this.setDdlName("CHAR");
                this.setDdlSuffix(" FOR BIT DATA");
                break;
            }
            case 2005: {
                this.setDdlName("DBCLOB");
                this.setDdlSuffix(" CCSID 13488");
                this.setByteFactor(1);
                this.setHasLengthAttribute(true);
                this.setDdlDefaultLength((int)DbDb4Environment.getDftClobLengthBytes() / 2);
                this.setMaxLength((int)DbDb4Environment.getMaxClobLengthBytes() / 2);
                this.setDefaultValuePrefix("");
                this.setDefaultValueSuffix("");
                break;
            }
            case 2004: {
                this.setDdlName("BLOB");
                this.setHasLengthAttribute(true);
                this.setDdlDefaultLength((int)DbDb4Environment.getDftBlobLength());
                this.setMaxLength((int)DbDb4Environment.getMaxBlobLength());
                break;
            }
            case 5: {
                this.setDdlName("SMALLINT");
                break;
            }
            case 4: {
                this.setDdlName("INTEGER");
                break;
            }
            case -5: {
                this.setDdlName("BIGINT");
                break;
            }
            case 7: {
                this.setDdlName("REAL");
                break;
            }
            case 8: {
                this.setDdlName("DOUBLE");
                break;
            }
            case 3: {
                this.setHasLengthAttribute(true);
                this.setHasDecimals(true);
                this.setDefaultValuePrefix("");
                this.setDefaultValueSuffix("");
                this.setDdlName("DECIMAL");
                break;
            }
            case 92: {
                this.setDdlName("TIME");
                this.setDefaultValuePrefix("'");
                this.setDefaultValueSuffix("'");
                this.targetFormatter = FTIME_TARGET;
                break;
            }
            case 93: {
                this.setDdlName("TIMESTAMP");
                this.setDefaultValuePrefix("'");
                this.setDefaultValueSuffix("'");
                this.targetFormatter = FTIMESTAMP_TARGET;
                break;
            }
            case 91: {
                this.setDdlName("DATE");
                this.setDefaultValuePrefix("'");
                this.setDefaultValueSuffix("'");
                this.targetFormatter = FDATE_TARGET;
            }
        }
    }

    public Format getTargetFormatterForDefaultString() {
        return this.targetFormatter;
    }
}

