/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class DbDb4PrimaryKeyDifference
extends DbPrimaryKeyDifference {
    private static Location loc = Logger.getLocation("db4.DbDb4PrimaryKeyDifference");
    private static Category cat = Logger.getCategory();

    public DbDb4PrimaryKeyDifference(DbPrimaryKey origin, DbPrimaryKey target, Action action) {
        super(origin, target, action);
    }

    public DbObjectSqlStatements getDdlStatements(String tableName) throws JddException {
        loc.entering(cat, "getDdlStatements(String)");
        DbObjectSqlStatements stmts = null;
        if (this.getAction().equals(Action.DROP)) {
            stmts = this.getDdlsForAction(Action.DROP);
        } else if (this.getAction().equals(Action.CREATE)) {
            stmts = this.getDdlsForAction(Action.CREATE);
        } else if (this.getAction().equals(Action.DROP_CREATE)) {
            stmts = this.getDdlsForAction(Action.DROP);
            stmts.merge(this.getDdlsForAction(Action.CREATE));
        } else {
            loc.warningT(cat, "Unexpected type of action: {0}", new Object[]{this.getAction().getName()});
            throw new JddException(ExType.OTHER, "Unexpected action " + this.getAction().getName() + ".");
        }
        loc.debugT(cat, "Generated: {0}.", new Object[]{stmts.toString()});
        loc.exiting();
        return stmts;
    }

    public DbObjectSqlStatements getDdlStatements(String tableName, DbTable tableForStorageInfo) throws JddException {
        return this.getDdlStatements(tableName);
    }

    private DbObjectSqlStatements getDdlsForAction(Action action) throws JddException {
        DbObjectSqlStatements stmts;
        DbPrimaryKey key;
        loc.entering(cat, "getDdlsForAction(Action)");
        if (!action.equals(Action.CREATE) && !action.equals(Action.DROP)) {
            throw new JddException(ExType.OTHER, "Unsupported type of action " + action.getName());
        }
        DbPrimaryKey dbPrimaryKey = key = action.equals(Action.DROP) ? this.getOrigin() : this.getTarget();
        if (key == null) {
            loc.errorT(cat, "Primary key definition not found.");
            loc.exiting();
            throw new JddException(ExType.OTHER, "Primary key definition not found.");
        }
        DbObjectSqlStatements dbObjectSqlStatements = stmts = action.equals(Action.CREATE) ? key.getDdlStatementsForCreate() : key.getDdlStatementsForDrop();
        if (stmts == null) {
            loc.errorT(cat, "Empty statement list.");
            loc.exiting();
            throw new JddException(ExType.OTHER, "Empty statement list.");
        }
        loc.exiting();
        return stmts;
    }
}

