/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4Column;
import com.sap.dictionary.database.db4.DbDb4Columns;
import com.sap.dictionary.database.db4.DbDb4Environment;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class DbDb4PrimaryKey
extends DbPrimaryKey {
    private static Location loc = Logger.getLocation("db4.DbDb4PrimaryKey");
    private static Category cat = Logger.getCategory();

    public DbDb4PrimaryKey() {
    }

    public DbDb4PrimaryKey(DbFactory factory, DbPrimaryKey other) {
        super(factory, other);
    }

    public DbDb4PrimaryKey(DbFactory factory) {
        super(factory);
    }

    public DbDb4PrimaryKey(DbFactory factory, String tableName) {
        super(factory, tableName);
    }

    public DbDb4PrimaryKey(DbFactory factory, DbSchema schema, String tableName) {
        super(factory, schema, tableName);
    }

    public void setSpecificContentViaXml(XmlMap xml) {
        this.setDbSpecificIsSet(true);
        loc.debugT(cat, "setSpecificContentViaXml(XmlMap) entered.");
    }

    /*
     * Loose catch block
     */
    public void setCommonContentViaDb() throws JddException {
        block12: {
            String stmtStr;
            ResultSet rs;
            PreparedStatement pstmt;
            block11: {
                loc.entering(cat, "setCommonContentViaDb()");
                Object factory = null;
                Connection con = null;
                pstmt = null;
                rs = null;
                ArrayList<DbIndexColumnInfo> fieldList = new ArrayList<DbIndexColumnInfo>();
                String tableName = null;
                stmtStr = "SELECT T2.COLUMN_NAME, T2.ORDINAL_POSITION FROM SYSCST AS T1 JOIN SYSKEYCST AS T2 ON T1.CONSTRAINT_NAME = T2.CONSTRAINT_NAME WHERE T1.CONSTRAINT_TYPE = 'PRIMARY KEY' AND T1.TABLE_NAME = ? ORDER BY T2.ORDINAL_POSITION";
                if (this.getTableName() == null) {
                    loc.errorT(cat, "Empty table name.");
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "Empty index name.");
                }
                tableName = this.getTableName().trim().toUpperCase();
                if (this.getDbFactory() == null || (con = this.getDbFactory().getConnection()) == null) {
                    loc.errorT(cat, "No connection.");
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "No connection.");
                }
                pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtStr);
                pstmt.setString(1, tableName);
                rs = pstmt.executeQuery();
                boolean noRows = true;
                while (rs.next()) {
                    fieldList.add(new DbIndexColumnInfo(rs.getString(1).trim().toUpperCase(), false));
                    noRows = false;
                }
                if (noRows) {
                    loc.warningT(cat, "Primary key for table {0} does not exist on database.", new Object[]{tableName});
                    this.setContent(null);
                    break block11;
                }
                this.setContent(fieldList);
            }
            Object var10_10 = null;
            try {
                rs.close();
                pstmt.close();
                break block12;
            }
            catch (Exception e) {
                loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
            }
            {
                break block12;
                catch (SQLException sqlEx) {
                    loc.errorT(cat, "SQLException caught executing {0}\n: {1}", new Object[]{stmtStr, sqlEx.getMessage()});
                    loc.exiting();
                    throw JddException.createInstance(sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
                }
                loc.exiting();
                throw throwable;
            }
        }
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        this.setDbSpecificIsSet(true);
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering(cat, "getDdlStatementsForCreate()");
        String tableName = null;
        tableName = this.getTableName();
        if (tableName == null) {
            loc.errorT(cat, "Empty table name.");
            loc.exiting();
            return null;
        }
        tableName = tableName.trim().toUpperCase();
        DbObjectSqlStatements crtPrimKeyStmts = new DbObjectSqlStatements(tableName);
        DbSqlStatement crtPrimKeyStmt = new DbSqlStatement();
        if (this.getColumnNames().isEmpty()) {
            loc.errorT(cat, "Empty field list for primary key of table {0}.", new Object[]{tableName});
            loc.exiting();
            return null;
        }
        crtPrimKeyStmt.addLine("ALTER TABLE \"" + tableName + "\"" + " ");
        crtPrimKeyStmt.addLine("ADD PRIMARY KEY ");
        crtPrimKeyStmt.merge(this.getDdlColumnsClause());
        crtPrimKeyStmts.add(crtPrimKeyStmt);
        loc.debugT(cat, "Generated: {0}.", new Object[]{crtPrimKeyStmts.toString()});
        loc.exiting();
        return crtPrimKeyStmts;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering(cat, "getDdlStatementsForDrop()");
        String tableName = null;
        tableName = this.getTableName();
        if (tableName == null) {
            loc.errorT(cat, "Empty table name.");
            loc.exiting();
            return null;
        }
        tableName = tableName.trim().toUpperCase();
        DbObjectSqlStatements dropPrimKeyStmts = new DbObjectSqlStatements(tableName);
        DbSqlStatement dropPrimKeyStmt = new DbSqlStatement();
        dropPrimKeyStmt.addLine("ALTER TABLE \"" + tableName + "\" ");
        dropPrimKeyStmt.addLine("DROP PRIMARY KEY");
        dropPrimKeyStmts.add(dropPrimKeyStmt);
        loc.debugT(cat, "Generated: {0}", new Object[]{dropPrimKeyStmts.toString()});
        loc.exiting();
        return dropPrimKeyStmts;
    }

    public DbPrimaryKeyDifference compareTo(DbPrimaryKey target) throws JddException {
        loc.entering(cat, "compareTo(DbPrimaryKey) for table {0}", new Object[]{target.getTableName()});
        DbPrimaryKeyDifference keyDiff = super.compareTo(target);
        loc.exiting();
        return keyDiff;
    }

    public boolean checkWidth() {
        loc.entering(cat, "checkWidth()");
        boolean widthOk = true;
        int keyWidth = 0;
        int numberOfColumns = 0;
        boolean sqlType = false;
        DbDb4Column col = null;
        int multiplier = 1;
        DbDb4Columns tableColumns = (DbDb4Columns)this.getTable().getColumns();
        int i = 0;
        while (i < this.getKeyCnt()) {
            col = (DbDb4Column)tableColumns.getColumn(this.getKeyFieldName(i + 1).trim().toUpperCase());
            ++numberOfColumns;
            multiplier = 1;
            switch (col.getJavaSqlType()) {
                case -1: 
                case 12: {
                    multiplier = 2;
                }
                case -4: 
                case -3: {
                    keyWidth = (int)((long)keyWidth + ((long)multiplier * col.getLengthOrDdlDefaultLength() + 2L));
                    break;
                }
                case -2: {
                    keyWidth = (int)((long)keyWidth + (long)multiplier * col.getLengthOrDdlDefaultLength());
                    break;
                }
                case 5: {
                    keyWidth += 2;
                    break;
                }
                case 4: {
                    keyWidth += 4;
                    break;
                }
                case -5: {
                    keyWidth += 8;
                    break;
                }
                case 7: {
                    keyWidth += 4;
                    break;
                }
                case 8: {
                    keyWidth += 8;
                    break;
                }
                case 91: {
                    keyWidth += 10;
                    break;
                }
                case 92: {
                    keyWidth += 8;
                    break;
                }
                case 93: {
                    keyWidth += 26;
                    break;
                }
                case 3: {
                    keyWidth = (int)((long)keyWidth + (col.getLengthOrDdlDefaultLength() / 2L + 1L));
                    break;
                }
                default: {
                    loc.errorT(cat, "Invalid type {0}.", new Object[]{new Integer(col.getJavaSqlType())});
                    widthOk = false;
                }
            }
            ++i;
        }
        keyWidth += (numberOfColumns + 7) / 8 * 8;
        if ((keyWidth += 64) > DbDb4Environment.getMaxIndexWidthBytes()) {
            widthOk = false;
        }
        DbDb4Environment.traceCheckResult(true, widthOk, cat, loc, "Width of primary key for table {0}: {1} ({2}) - return {3}.", new Object[]{this.getTableName(), new Integer(keyWidth), new Integer(DbDb4Environment.getMaxIndexWidthBytes()), new Boolean(widthOk)});
        loc.exiting();
        return widthOk;
    }

    public boolean checkNumberOfColumns() {
        boolean isOk = this.getColumnNames().size() <= DbDb4Environment.getMaxColumnsPerIndex();
        DbDb4Environment.traceCheckResult(true, isOk, cat, loc, "checkNumberOfColumns() returns {0}.", new Object[]{new Boolean(isOk)});
        return isOk;
    }

    public boolean checkColumnsNotNull() {
        loc.entering(cat, "checkColumnsNotNull()");
        boolean allNotNull = true;
        ArrayList primKeyColumnNames = this.getColumnNames();
        DbColumns tableColumns = this.getTable().getColumns();
        DbColumn col = null;
        int i = 0;
        while (i < this.getKeyCnt()) {
            col = tableColumns.getColumn(this.getKeyFieldName(i + 1).trim().toUpperCase());
            allNotNull &= col.isNotNull();
            ++i;
        }
        DbDb4Environment.traceCheckResult(true, allNotNull, cat, loc, "checkColumnsNotNull() returns {0}.", new Object[]{new Boolean(allNotNull)});
        loc.exiting();
        return allNotNull;
    }
}

