/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4HexString;
import com.sap.dictionary.database.db4.JavaDb4SqlTypeInfo;
import com.sap.dictionary.database.dbs.DbEnvironment;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;

public class DbDb4Environment
extends DbEnvironment {
    private static Location loc = Logger.getLocation("db4.DbDb4Environment");
    private static Category cat = Logger.getCategory();
    private Connection con;
    private static ArrayList reservedWords;
    private static final int MAX_COLUMN_NAME_LENGTH = 30;
    private static final int MAX_TABLE_NAME_LENGTH = 127;
    private static final int MAX_VIEW_NAME_LENGTH = 127;
    private static final int MAX_INDEX_NAME_LENGTH = 127;
    private static final int MAX_CONSTRAINT_NAME_LENGTH = 127;
    private static final long MAX_BLOB_LENGTH = Integer.MAX_VALUE;
    private static final long MAX_CLOB_LENGTH_BYTES = 0x7FFFFFFEL;
    private static final long MAX_BINARY_LENGTH = 32000L;
    private static final long MAX_VARBINARY_LENGTH = 32000L;
    private static final long MAX_VARCHAR_LENGTH_BYTES = 32000L;
    private static final long DFT_BLOB_LENGTH = Integer.MAX_VALUE;
    private static final long DFT_CLOB_LENGTH_BYTES = Integer.MAX_VALUE;
    private static final int MAX_DECIMAL_LENGTH_CHARS = 31;
    private static final int MAX_TABLE_WIDTH_BYTES = Short.MAX_VALUE;
    private static final int MAX_VIEW_WIDTH_BYTES = Short.MAX_VALUE;
    private static final int MAX_INDEX_WIDTH_BYTES = 2000;
    private static final int MAX_COLUMNS_PER_TABLE = 8000;
    private static final int MAX_COLUMNS_PER_VIEW = 8000;
    private static final int MAX_COLUMNS_PER_INDEX = 120;
    private static final int MAX_COLUMNS_PER_PRIMKEY = 120;
    private static final int MAX_INDEXES_PER_TABLE = 3500;
    private static final int MAX_TABLES_PER_STMT = 256;
    private static final int MAX_TABLES_PER_VIEW = 32;

    public static int getMaxTableWidthBytes() {
        return Short.MAX_VALUE;
    }

    public static int getMaxViewWidthBytes() {
        return Short.MAX_VALUE;
    }

    public static int getMaxIndexWidthBytes() {
        return 2000;
    }

    public static int getMaxColumnsPerTable() {
        return 8000;
    }

    public static int getMaxColumnsPerView() {
        return 8000;
    }

    public static int getMaxColumnsPerIndex() {
        return 120;
    }

    public static int getMaxColumnsPerPrimKey() {
        return 120;
    }

    public static int getMaxIndexesPerTable() {
        return 3500;
    }

    public static int getMaxTablesPerStmt() {
        return 256;
    }

    public static int getMaxTablesPerView() {
        return 32;
    }

    public static int getMaxColumnNameLength() {
        return 30;
    }

    public static int getMaxTableNameLength() {
        return 127;
    }

    public static int getMaxViewNameLength() {
        return 127;
    }

    public static int getMaxIndexNameLength() {
        return 127;
    }

    public static int getMaxConstraintNameLength() {
        return 127;
    }

    public static long getMaxClobLengthBytes() {
        return 0x7FFFFFFEL;
    }

    public static long getMaxBlobLength() {
        return Integer.MAX_VALUE;
    }

    public static long getMaxVarcharLengthBytes() {
        return 32000L;
    }

    public static long getMaxVarbinaryLength() {
        return 32000L;
    }

    public static long getMaxBinaryLength() {
        return 32000L;
    }

    public static long getDftClobLengthBytes() {
        return Integer.MAX_VALUE;
    }

    public static long getDftBlobLength() {
        return Integer.MAX_VALUE;
    }

    public static long getMaxDecimalLengthChars() {
        return 31L;
    }

    public DbDb4Environment() {
    }

    public DbDb4Environment(Connection con) {
        super(con);
    }

    public static boolean isReservedWord(String word) {
        boolean isReserved = true;
        if (reservedWords == null) {
            reservedWords = new ArrayList();
            reservedWords.add("ADD");
            reservedWords.add("ALIAS");
            reservedWords.add("ALL");
            reservedWords.add("ALLOCATE");
            reservedWords.add("ALLOW");
            reservedWords.add("ALTER");
            reservedWords.add("AND");
            reservedWords.add("ANY");
            reservedWords.add("AS");
            reservedWords.add("AUTHORIZATION");
            reservedWords.add("BEGIN");
            reservedWords.add("BETWEEN");
            reservedWords.add("BINARY");
            reservedWords.add("BY");
            reservedWords.add("CACHE");
            reservedWords.add("CALL");
            reservedWords.add("CALLED");
            reservedWords.add("CASE");
            reservedWords.add("CAST");
            reservedWords.add("CCSID");
            reservedWords.add("CHAR");
            reservedWords.add("CHARACTER");
            reservedWords.add("CHECK");
            reservedWords.add("CLOSE");
            reservedWords.add("COLLECTION");
            reservedWords.add("COLUMN");
            reservedWords.add("COMMENT");
            reservedWords.add("COMMIT");
            reservedWords.add("CONCAT");
            reservedWords.add("CONDITION");
            reservedWords.add("CONNECT");
            reservedWords.add("CONNECTION");
            reservedWords.add("CONSTRAINT");
            reservedWords.add("CONTAINS");
            reservedWords.add("CONTINUE");
            reservedWords.add("COUNT");
            reservedWords.add("COUNT_BIG");
            reservedWords.add("CREATE");
            reservedWords.add("CROSS");
            reservedWords.add("CURRENT");
            reservedWords.add("CURRENT_DATE");
            reservedWords.add("CURRENT_PATH");
            reservedWords.add("CURRENT_SERVER");
            reservedWords.add("CURRENT_TIME");
            reservedWords.add("CURRENT_TIMESTAMP");
            reservedWords.add("CURRENT_TIMEZONE");
            reservedWords.add("CURRENT_USER");
            reservedWords.add("CURSOR");
            reservedWords.add("CYCLE");
            reservedWords.add("DATABASE");
            reservedWords.add("DAY");
            reservedWords.add("DAYS");
            reservedWords.add("DBINFO");
            reservedWords.add("DB2GENERAL");
            reservedWords.add("DB2GENRL");
            reservedWords.add("DB2SQL");
            reservedWords.add("DECLARE");
            reservedWords.add("DEFAULT");
            reservedWords.add("DEFAULTS");
            reservedWords.add("DELETE");
            reservedWords.add("DESCRIPTOR");
            reservedWords.add("DETERMINISTIC");
            reservedWords.add("DISALLOW");
            reservedWords.add("DISCONNECT");
            reservedWords.add("DISTINCT");
            reservedWords.add("DO");
            reservedWords.add("DOUBLE");
            reservedWords.add("DROP");
            reservedWords.add("DYNAMIC");
            reservedWords.add("EACH");
            reservedWords.add("ELSE");
            reservedWords.add("ELSEIF");
            reservedWords.add("END");
            reservedWords.add("END-EXEC");
            reservedWords.add("ESCAPE");
            reservedWords.add("EXCEPTION");
            reservedWords.add("EXCLUDING");
            reservedWords.add("EXECUTE");
            reservedWords.add("EXISTS");
            reservedWords.add("EXIT");
            reservedWords.add("EXTERNAL");
            reservedWords.add("FENCED");
            reservedWords.add("FETCH");
            reservedWords.add("FILE");
            reservedWords.add("FINAL");
            reservedWords.add("FOR");
            reservedWords.add("FOREIGN");
            reservedWords.add("FREE");
            reservedWords.add("FROM");
            reservedWords.add("FUNCTION");
            reservedWords.add("GENERAL");
            reservedWords.add("GENERATED");
            reservedWords.add("GET");
            reservedWords.add("GLOBAL");
            reservedWords.add("GO");
            reservedWords.add("GOTO");
            reservedWords.add("GRANT");
            reservedWords.add("GRAPHIC");
            reservedWords.add("GROUP");
            reservedWords.add("HANDLER");
            reservedWords.add("HAVING");
            reservedWords.add("HOLD");
            reservedWords.add("HOUR");
            reservedWords.add("HOURS");
            reservedWords.add("IDENTITY");
            reservedWords.add("IF");
            reservedWords.add("IMMEDIATE");
            reservedWords.add("IN");
            reservedWords.add("INCLUDING");
            reservedWords.add("INCREMENT");
            reservedWords.add("INDEX");
            reservedWords.add("INDICATOR");
            reservedWords.add("INNER");
            reservedWords.add("INOUT");
            reservedWords.add("INSENSITIVE");
            reservedWords.add("INSERT");
            reservedWords.add("INTEGRITY");
            reservedWords.add("INTO");
            reservedWords.add("IS");
            reservedWords.add("ISOLATION");
            reservedWords.add("ITERATE");
            reservedWords.add("JAVA");
            reservedWords.add("JOIN");
            reservedWords.add("KEY");
            reservedWords.add("LABEL");
            reservedWords.add("LANGUAGE");
            reservedWords.add("LEAVE");
            reservedWords.add("LEFT");
            reservedWords.add("LIKE");
            reservedWords.add("LINKTYPE");
            reservedWords.add("LOCK");
            reservedWords.add("LONG");
            reservedWords.add("LOOP");
            reservedWords.add("MAXVALUE");
            reservedWords.add("MICROSECOND");
            reservedWords.add("MICROSECONDS");
            reservedWords.add("MINUTE");
            reservedWords.add("MINUTES");
            reservedWords.add("MINVALUE");
            reservedWords.add("MODE");
            reservedWords.add("MODIFIES");
            reservedWords.add("MONTH");
            reservedWords.add("MONTHS");
            reservedWords.add("NEW");
            reservedWords.add("NEW_TABLE");
            reservedWords.add("NO");
            reservedWords.add("NOCACHE");
            reservedWords.add("NOCYCLE");
            reservedWords.add("NODENAME");
            reservedWords.add("NODENUMBER");
            reservedWords.add("NOMAXVALUE");
            reservedWords.add("NOMINVALUE");
            reservedWords.add("NOORDER");
            reservedWords.add("NOT");
            reservedWords.add("NULL");
            reservedWords.add("OF");
            reservedWords.add("OLD");
            reservedWords.add("OLD_TABLE");
            reservedWords.add("ON");
            reservedWords.add("OPEN");
            reservedWords.add("OPTIMIZE");
            reservedWords.add("OPTION");
            reservedWords.add("OR");
            reservedWords.add("ORDER");
            reservedWords.add("OUT");
            reservedWords.add("OUTER");
            reservedWords.add("OVERRIDING");
            reservedWords.add("PACKAGE");
            reservedWords.add("PARAMETER");
            reservedWords.add("PARTITION");
            reservedWords.add("PATH");
            reservedWords.add("POSITION");
            reservedWords.add("PREPARE");
            reservedWords.add("PRIMARY");
            reservedWords.add("PRIVILEGES");
            reservedWords.add("PROCEDURE");
            reservedWords.add("PROGRAM");
            reservedWords.add("READ");
            reservedWords.add("READS");
            reservedWords.add("RECOVERY");
            reservedWords.add("REFERENCES");
            reservedWords.add("REFERENCING");
            reservedWords.add("RELEASE");
            reservedWords.add("RENAME");
            reservedWords.add("REPEAT");
            reservedWords.add("RESET");
            reservedWords.add("RESIGNAL");
            reservedWords.add("RESTART");
            reservedWords.add("RESULT");
            reservedWords.add("RETURN");
            reservedWords.add("RETURNS");
            reservedWords.add("REVOKE");
            reservedWords.add("RIGHT");
            reservedWords.add("ROLLBACK");
            reservedWords.add("ROUTINE");
            reservedWords.add("ROW");
            reservedWords.add("ROWS");
            reservedWords.add("PRN");
            reservedWords.add("RUN");
            reservedWords.add("SAVEPOINT");
            reservedWords.add("SCHEMA");
            reservedWords.add("SCRATCHPAD");
            reservedWords.add("SECOND");
            reservedWords.add("SECONDS");
            reservedWords.add("SELECT");
            reservedWords.add("SET");
            reservedWords.add("SIGNAL");
            reservedWords.add("SIMPLE");
            reservedWords.add("SOME");
            reservedWords.add("SOURCE");
            reservedWords.add("SPECIFIC");
            reservedWords.add("SQL");
            reservedWords.add("SQLID");
            reservedWords.add("START");
            reservedWords.add("STATIC");
            reservedWords.add("SUBSTRING");
            reservedWords.add("SYNONYM");
            reservedWords.add("TABLE");
            reservedWords.add("THEN");
            reservedWords.add("TO");
            reservedWords.add("TRANSACTION");
            reservedWords.add("TRIGGER");
            reservedWords.add("TRIM");
            reservedWords.add("TYPE");
            reservedWords.add("UNDO");
            reservedWords.add("UNION");
            reservedWords.add("UNIQUE");
            reservedWords.add("UNTIL");
            reservedWords.add("UPDATE");
            reservedWords.add("USAGE");
            reservedWords.add("USER");
            reservedWords.add("USING");
            reservedWords.add("VALUES");
            reservedWords.add("VARIABLE");
            reservedWords.add("VARIANT");
            reservedWords.add("VIEW");
            reservedWords.add("WHEN");
            reservedWords.add("WHERE");
            reservedWords.add("WHILE");
            reservedWords.add("WITH");
            reservedWords.add("WRITE");
            reservedWords.add("YEAR");
            reservedWords.add("YEARS");
            Collections.sort(reservedWords);
        }
        isReserved = Collections.binarySearch(reservedWords, word.trim().toUpperCase()) >= 0;
        loc.infoT(cat, "isReservedWord({0}) returns", new Object[]{word, new Boolean(isReserved)});
        return isReserved;
    }

    public static int mapToSqlType(String dbType, int length, int ccsid) {
        int sqlType = 1111;
        if (dbType == null) {
            loc.warningT(cat, "Empty database type. Mapped to {0}", new Object[]{new Integer(sqlType)});
            loc.exiting();
            return sqlType;
        }
        if (dbType.equals("VARG")) {
            sqlType = 12;
        } else if (dbType.equals("VARCHAR") && ccsid == 65535) {
            sqlType = -3;
        } else if (dbType.equals("CHAR") && ccsid == 65535) {
            sqlType = -2;
        } else if (dbType.equals("SMALLINT")) {
            sqlType = 5;
        } else if (dbType.equals("INTEGER")) {
            sqlType = 4;
        } else if (dbType.equals("BIGINT")) {
            sqlType = -5;
        } else if (dbType.equals("FLOAT")) {
            sqlType = length == 4 ? 7 : 8;
        } else if (dbType.equals("DECIMAL")) {
            sqlType = 3;
        } else if (dbType.equals("DATE")) {
            sqlType = 91;
        } else if (dbType.equals("TIME")) {
            sqlType = 92;
        } else if (dbType.equals("TIMESTMP")) {
            sqlType = 93;
        } else if (dbType.equals("DBCLOB")) {
            sqlType = 2005;
        } else if (dbType.equals("BLOB")) {
            sqlType = 2004;
        } else {
            loc.warningT(cat, "Unknown database type {0}", new Object[]{dbType});
        }
        loc.debugT(cat, "mapToSqlType({0}) returns {1}.", new Object[]{dbType, new Integer(sqlType)});
        return sqlType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mapToJddicDefaultValue(String dbDefaultValue, int sqlType) throws Exception {
        loc.entering(cat, "mapToJddicDefaultValue(String, int)");
        SimpleDateFormat dbFormatter = null;
        String jddicDefaultValue = null;
        if (dbDefaultValue != null) {
            block13: {
                if (sqlType == 12 || sqlType == -1 || sqlType == 2005) {
                    if (dbDefaultValue.startsWith("UX'") && dbDefaultValue.endsWith("'")) {
                        String strippedHexDefault = dbDefaultValue.substring(3, dbDefaultValue.length() - 1);
                        jddicDefaultValue = new DbDb4HexString(null, strippedHexDefault).getJavaString();
                        break block13;
                    } else {
                        loc.exiting();
                        throw new JddException(ExType.OTHER, "Default value ");
                    }
                }
                jddicDefaultValue = dbDefaultValue;
                if (sqlType != 92 && sqlType != 93 && sqlType != 91) {
                    loc.exiting();
                    return jddicDefaultValue;
                }
                if (jddicDefaultValue.startsWith("'")) {
                    jddicDefaultValue = jddicDefaultValue.substring(1, jddicDefaultValue.length() - 1);
                }
                if (sqlType == 92) {
                    dbFormatter = new SimpleDateFormat("HH.mm.ss");
                } else if (sqlType == 91) {
                    dbFormatter = new SimpleDateFormat("yyyy-MM-dd");
                } else if (sqlType == 93) {
                    dbFormatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
                    jddicDefaultValue = jddicDefaultValue.substring(1, jddicDefaultValue.length() - 3);
                }
                JavaDb4SqlTypeInfo typeInfo = new JavaDb4SqlTypeInfo(null, null, sqlType);
                SimpleDateFormat jddicFormatter = (SimpleDateFormat)typeInfo.getFormatterForDefaultString();
                try {
                    jddicDefaultValue = jddicFormatter.format(dbFormatter.parse(jddicDefaultValue));
                }
                catch (Exception e) {
                    loc.errorT(cat, "Exception caught reformatting default value:\n   {0}\n    Failed to convert {1} from {2} to {3}.", new Object[]{e.toString(), dbDefaultValue, dbFormatter.toPattern(), jddicFormatter.toPattern()});
                    loc.exiting();
                    throw JddException.createInstance(e);
                }
            }
            loc.infoT(cat, "Converted default value {0} to {1}.", new Object[]{dbDefaultValue, jddicDefaultValue});
        }
        loc.exiting();
        return jddicDefaultValue;
    }

    public static void traceCheckResult(boolean trcFalseAsError, boolean result, Category realCat, Location realLoc, String message, Object[] params) {
        if (trcFalseAsError ^ result) {
            realLoc.errorT(realCat, message, params);
        } else {
            realLoc.infoT(realCat, message, params);
        }
    }
}

