/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2PartAttr;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Location;
import java.util.LinkedList;
import java.util.ListIterator;

public class DbDb2TsAttr {
    private DbDb2Table table;
    private Double pageSizeFactor;
    private Boolean partitioned;
    private Boolean lob;
    private ListIterator partsIterator;
    private LinkedList keyColNames;
    private ListIterator keyColNameIterator;
    private Boolean memberCluster;
    private Integer dsSize;
    private Boolean log;
    private Boolean close;
    private String bufferPool;
    private String lockRule;
    private Integer lockMax;
    private Integer pageSize;
    private Integer segSize;
    private Integer maxRows;
    private LinkedList partsAttr;
    private DbDb2PartAttr partAttr;
    private Boolean erase;
    private Location loc = Logger.getLocation("db2.DbDb2TsAttr");

    public void setTable(DbDb2Table table) {
        this.table = table;
    }

    public DbDb2PartAttr setNextPart() throws JddException {
        this.loc.entering("setNextPart");
        if (this.partitioned == null) {
            this.loc.errorT("know nothing about partitioning - wrong call sequence");
            this.loc.exiting();
            throw new JddException("know nothing about partitioning - wrong call sequence");
        }
        this.partAttr = new DbDb2PartAttr();
        if (this.partitioned.booleanValue()) {
            if (this.partsAttr == null) {
                this.partsAttr = new LinkedList();
            }
            this.partsAttr.add(this.partAttr);
        }
        this.loc.exiting();
        return this.partAttr;
    }

    public void setPartitioned(Boolean partitioned) {
        this.partitioned = partitioned;
    }

    public void changePartitioned(Boolean partitioned) {
        if (this.partitioned == null) {
            this.setPartitioned(partitioned);
        } else {
            if (this.partitioned.booleanValue() == partitioned.booleanValue()) {
                return;
            }
            if (!partitioned.booleanValue()) {
                this.partsAttr = null;
            } else {
                this.partsAttr = new LinkedList();
                this.partsAttr.add(this.partAttr);
            }
        }
    }

    public void setKeyColName(String keyColName) {
        if (this.keyColNames == null) {
            this.keyColNames = new LinkedList();
        }
        this.keyColNames.add(keyColName);
    }

    public void setMemberCluster(String memberCluster) {
        if (memberCluster != null) {
            this.memberCluster = memberCluster.equalsIgnoreCase("NO") ? new Boolean(false) : new Boolean(true);
        }
    }

    public void setDsSize(Integer dsSize) {
        if (this.segSize == null) {
            this.dsSize = dsSize;
        }
    }

    public void setLob(Boolean lob) {
        if (!this.memberCluster.booleanValue()) {
            this.lob = lob;
        }
    }

    public void setLog(String log) {
        if (log != null) {
            this.log = log.equalsIgnoreCase("NO") ? new Boolean(false) : new Boolean(true);
        }
    }

    public void setClose(String close) {
        if (close != null) {
            this.close = close.equalsIgnoreCase("NO") ? new Boolean(false) : new Boolean(true);
        }
    }

    public void setBufferPool(String bufferPool) {
        if (bufferPool != null) {
            this.bufferPool = bufferPool.toUpperCase();
        }
    }

    public void setLockRule(String lockRule) {
        if (lockRule != null) {
            this.lockRule = lockRule.toUpperCase();
        }
    }

    public void setLockMax(Integer lockMax) {
        this.lockMax = lockMax;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        if (pageSize == null || pageSize != 4 || pageSize != 8 || pageSize != 16 || pageSize != 32) {
            // empty if block
        }
    }

    public void setSegSize(Integer segSize) {
        if (!(this.lob != null && this.lob.booleanValue() || this.partitioned != null && this.partitioned.booleanValue() || this.dsSize != null)) {
            this.segSize = segSize;
        }
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public String getMemberCluster() {
        if (this.memberCluster == null) {
            return null;
        }
        if (this.memberCluster.booleanValue()) {
            return "MEMBER CLUSTER";
        }
        return null;
    }

    public void setPageSizeFactor(double factor) {
        this.pageSizeFactor = new Double(factor);
    }

    public void setErase(String eraseString) {
        Boolean eraseBoolean = null;
        eraseBoolean = eraseString == null ? new Boolean(false) : (eraseString.equalsIgnoreCase("YES") ? new Boolean(true) : new Boolean(false));
        this.erase = eraseBoolean;
    }

    public DbDb2Table getTable() {
        return this.table;
    }

    public int getNumParts() {
        if (this.partsAttr == null) {
            return 1;
        }
        return this.partsAttr.size();
    }

    public int getDsSize() {
        if (this.dsSize == null) {
            return 4;
        }
        return this.dsSize;
    }

    public String getLog() {
        if (this.log == null) {
            return "YES";
        }
        if (this.log.booleanValue()) {
            return "YES";
        }
        return "NO";
    }

    public String getClose() {
        if (this.close == null) {
            return "YES";
        }
        if (this.close.booleanValue()) {
            return "YES";
        }
        return "NO";
    }

    public String getBufferPool() {
        if (this.bufferPool == null) {
            String bp = null;
            switch (this.getPageSize()) {
                case 4: {
                    bp = "BP2";
                    break;
                }
                case 8: {
                    bp = "BP8K0";
                    break;
                }
                case 16: {
                    bp = "BP16K0";
                    break;
                }
                case 32: {
                    bp = "BP32K";
                }
            }
            return bp;
        }
        return this.bufferPool;
    }

    public String getLockRule() {
        if (this.lockRule == null) {
            return "ROW";
        }
        return this.lockRule;
    }

    public int getLockMax() {
        if (this.lockMax == null) {
            return 1000000;
        }
        return this.lockMax;
    }

    public int getPageSize() {
        if (this.pageSize == null) {
            double factor = 0.0;
            int rowLength = DbDb2Environment.getRowLength(this.table.getColumns());
            int size = 0;
            factor = this.pageSizeFactor == null ? 0.7 : this.pageSizeFactor;
            size = rowLength + 3 < (int)(4038.0 * factor) ? 4 : (rowLength + 1 < (int)(8000.0 * factor) ? 8 : (rowLength + 1 < (int)(16000.0 * factor) ? 16 : 32));
            return size;
        }
        return this.pageSize;
    }

    public int getSegSize() {
        if (this.segSize == null) {
            int mySegSize = 4 + 8 * DbDb2Parameters.getSizeCategory(this.table);
            if (mySegSize > 64) {
                mySegSize = 64;
            }
            return mySegSize;
        }
        return this.segSize;
    }

    public int getMaxRows() {
        if (this.maxRows == null) {
            return 255;
        }
        return this.maxRows;
    }

    public DbDb2PartAttr getFirstPart() {
        if (!this.partitioned.booleanValue()) {
            return this.partAttr;
        }
        this.partsIterator = this.partsAttr.listIterator();
        return this.getNextPart();
    }

    public DbDb2PartAttr getNextPart() {
        if (this.partsIterator.hasNext()) {
            return (DbDb2PartAttr)this.partsIterator.next();
        }
        return null;
    }

    public boolean getPartitioned() {
        if (this.partitioned == null) {
            return false;
        }
        return this.partitioned;
    }

    public String getKeyColNames() {
        String concatKeyColNames = null;
        ListIterator iterator = this.keyColNames.listIterator();
        while (iterator.hasNext()) {
            concatKeyColNames = concatKeyColNames == null ? (String)iterator.next() : concatKeyColNames + ", " + (String)iterator.next();
        }
        return concatKeyColNames;
    }

    public String getFirstKeyColName() {
        this.keyColNameIterator = this.keyColNames.listIterator();
        return this.getNextKeyColName();
    }

    public String getNextKeyColName() {
        if (this.keyColNameIterator.hasNext()) {
            return (String)this.keyColNameIterator.next();
        }
        return null;
    }

    public String getErase() {
        if (this.erase == null) {
            return "NO";
        }
        if (this.erase.booleanValue()) {
            return "YES";
        }
        return "NO";
    }
}

