/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Column;
import com.sap.dictionary.database.db2.DbDb2Columns;
import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Index;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2PartAttr;
import com.sap.dictionary.database.db2.DbDb2PrimaryKey;
import com.sap.dictionary.database.db2.DbDb2SqlStatement;
import com.sap.dictionary.database.db2.DbDb2Stogroup;
import com.sap.dictionary.database.db2.DbDb2TableDifference;
import com.sap.dictionary.database.db2.DbDb2TsAttr;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexIterator;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class DbDb2Table
extends DbTable {
    private DbDb2TsAttr tsAttr = null;
    private String tspName = null;
    private String dbName = null;
    private String dbTableName = null;
    private boolean lobViewMissing = false;
    private String schema = null;
    private static Location loc = Logger.getLocation("db2.DbDb2Table");

    public DbDb2Table(DbFactory factory) {
        super(factory);
        this.setDbEnv(factory);
        this.setDefaultPartition();
    }

    public DbDb2Table(DbFactory factory, DbSchema schema, String name) {
        super(factory, schema, name);
        this.setDbEnv(factory);
        this.setDefaultPartition();
    }

    public DbDb2Table(DbFactory factory, String name) {
        super(factory, name);
        this.setDbEnv(factory);
        this.setDefaultPartition();
    }

    public DbDb2Table(DbFactory factory, DbTable other) {
        super(factory, other.getSchema(), other.getName());
        this.setColumns(other.getColumns());
        this.setDbEnv(factory);
        this.setDefaultPartition();
    }

    private void setDefaultPartition() {
        if (this.tsAttr == null) {
            this.tsAttr = new DbDb2TsAttr();
            this.tsAttr.setTable(this);
            this.tsAttr.setPartitioned(new Boolean(false));
            try {
                this.tsAttr.setNextPart();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setDbEnv(DbFactory factory) {
        String schema = null;
        DbSchema dbschema = this.getSchema();
        if (dbschema != null) {
            schema = dbschema.getSchemaName();
        }
        this.schema = schema == null ? DbDb2Environment.getSchema(factory.getConnection()) : schema;
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public String getDbSchema() {
        return this.schema;
    }

    public DbDb2TsAttr getTsAttr() {
        return this.tsAttr;
    }

    public ArrayList dbGetIndexNames(Connection conn) throws JddException {
        loc.entering("dbGetIndexNames");
        if (conn == null) {
            loc.exiting();
            return null;
        }
        String stmt = null;
        try {
            ArrayList<String> names = new ArrayList<String>();
            stmt = "SELECT NAME, UNIQUERULE FROM SYSIBM.SYSINDEXES WHERE TBNAME = ? AND TBCREATOR = ? AND CREATOR = ?  FOR FETCH ONLY WITH UR";
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)stmt);
            String tabname = this.getDbTableName();
            ps.setString(1, tabname);
            ps.setString(2, this.schema);
            ps.setString(3, this.schema);
            ResultSet rset = ps.executeQuery();
            while (rset.next()) {
                if (0 == rset.getString(2).compareToIgnoreCase("P")) continue;
                names.add(rset.getString(1));
            }
            rset.close();
            ps.close();
            loc.exiting();
            return names;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmt)};
            loc.errorT("dbGetIndexNames: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("dbGetIndexNames: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setSpecificContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaDb()");
        String stmtTxt = null;
        try {
            DbIndexes indexes;
            String tableName = this.getDbTableName();
            Connection con = this.getDbFactory().getConnection();
            String schema = DbDb2Environment.getSchema(con);
            boolean dbfound = true;
            stmtTxt = " SELECT A.TSNAME, A.DBNAME, B.PQTY,  case when B.secqtyi = 0 then B.sqty else B.secqtyi end,  B.FREEPAGE,  B.PCTFREE,  case when B.GBPCACHE = 'A' then 'ALL'       when B.GBPCACHE = 'N' then 'NONE'       when B.GBPCACHE = 'S' then 'SYSTEM'       else 'CHANGED' end,  case when B.space = -1 then 'NO' else 'YES' end,  case when B.COMPRESS = 'Y' then 'YES' else 'NO' end,  C.BPOOL, C.PGSIZE,  case when C.LOCKRULE = 'A' then 'ANY'       when C.LOCKRULE = 'L' then 'LOB'       when C.LOCKRULE = 'P' then 'PAGE'       when C.LOCKRULE = 'R' then 'ROW'       when C.LOCKRULE = 'S' then 'TABLESPACE'       when C.LOCKRULE = 'T' then 'TABLE'       else 'UNDEFINED' end,  case when C.CLOSERULE = 'N' then 'NO'       when C.CLOSERULE = 'Y' then 'YES'       else 'UNDEFINED' end,       C.SEGSIZE,          C.LOCKMAX,          C.MAXROWS,          C.PARTITIONS,  case when C.TYPE ='I' or C.TYPE = 'K' then 'YES' else 'NO' end, case when C.ERASERULE = 'Y' then 'YES' else 'NO' end  FROM SYSIBM.SYSTABLES A,  SYSIBM.SYSTABLEPART B,  SYSIBM.SYSTABLESPACE C  WHERE A.NAME = ?  AND A.CREATOR = ?  AND A.TSNAME =  B.TSNAME  AND A.DBNAME =  B.DBNAME  AND A.TSNAME =  C.NAME  AND A.DBNAME =  C.DBNAME  AND (B.PARTITION = 0 OR B.PARTITION = 1)  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, tableName);
            stmt.setString(2, schema);
            ResultSet rs = stmt.executeQuery();
            this.tsAttr = new DbDb2TsAttr();
            this.tsAttr.setPartitioned(new Boolean(false));
            DbDb2PartAttr partAttr = this.tsAttr.setNextPart();
            if (rs.next()) {
                this.tspName = rs.getString(1).trim();
                this.dbName = rs.getString(2).trim();
                this.tsAttr.setBufferPool(rs.getString(10).trim());
                this.tsAttr.setPageSize(new Integer(rs.getInt(11)));
                this.tsAttr.setLockRule(rs.getString(12).trim());
                this.tsAttr.setClose(rs.getString(13).trim());
                this.tsAttr.setSegSize(new Integer(rs.getInt(14)));
                this.tsAttr.setLockMax(new Integer(rs.getInt(15)));
                this.tsAttr.setMaxRows(new Integer(rs.getInt(16)));
                this.tsAttr.setMemberCluster(rs.getString(18).trim());
                this.tsAttr.setErase(rs.getString(19).trim());
                partAttr.setPriQty(new Integer(4 * rs.getInt(3)));
                partAttr.setSecQty(new Integer(4 * rs.getInt(4)));
                partAttr.setFreePage(new Integer(rs.getInt(5)));
                partAttr.setPctFree(new Integer(rs.getInt(6)));
                partAttr.setGbpCache(rs.getString(7).trim());
                partAttr.setDefine(rs.getString(8).trim());
                partAttr.setCompress(rs.getString(9).trim());
                if (rs.getShort(17) > 0) {
                    this.tsAttr.changePartitioned(new Boolean(true));
                }
            } else {
                dbfound = false;
                Object[] arguments = new Object[]{this.getName()};
                loc.errorT("Table {0} not found in catalog", arguments);
            }
            stmt.close();
            rs.close();
            if (!dbfound) {
                loc.exiting();
                return;
            }
            if (this.tsAttr.getPartitioned()) {
                stmtTxt = " SELECT PQTY,  case when secqtyi = 0 then sqty else secqtyi end,  FREEPAGE,  PCTFREE,  case when GBPCACHE = 'A' then 'ALL'       when GBPCACHE = 'N' then 'NONE'       when GBPCACHE = 'S' then 'SYSTEM'       else 'CHANGED' end,  case when space = -1 then 'NO' else 'YES' end,  case when COMPRESS = 'Y' then 'YES' else 'NO' end,  FROM SYSIBM.SYSTABLEPART,  WHERE TSNAME = ?  AND DBNAME =  ?  AND PARTITION > 1  ORDER BY PARTITION  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                stmt.setString(1, this.tspName);
                stmt.setString(2, this.dbName);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    partAttr = this.tsAttr.setNextPart();
                    partAttr.setPriQty(new Integer(4 * rs.getInt(1)));
                    partAttr.setSecQty(new Integer(4 * rs.getInt(2)));
                    partAttr.setFreePage(new Integer(rs.getInt(3)));
                    partAttr.setPctFree(new Integer(rs.getInt(4)));
                    partAttr.setGbpCache(rs.getString(5).trim());
                    partAttr.setDefine(rs.getString(6).trim());
                    partAttr.setCompress(rs.getString(7).trim());
                }
                stmt.close();
                rs.close();
            }
            this.setDbSpecificIsSet(true);
            DbDb2PrimaryKey primaryKey = (DbDb2PrimaryKey)this.getPrimaryKey();
            if (primaryKey != null) {
                primaryKey.getIndex().setSpecificContentViaDb();
            }
            if ((indexes = this.getIndexes()) != null) {
                DbIndexIterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    DbIndex index = iterator.next();
                    ((DbDb2Index)index).setSpecificContentViaDb();
                }
            }
            loc.exiting();
            return;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("setSpecificContentViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        loc.entering("writeSpecificContentToXmlFile");
        try {
            DbDb2PartAttr partAttr = this.tsAttr.getFirstPart();
            file.println(offset0 + "<?xml version=\"1.0\"?>");
            file.println(offset0 + "<table name=" + "\"" + this.getName() + "\">");
            String offset1 = offset0 + XmlHelper.tabulate();
            String offset2 = offset1 + XmlHelper.tabulate();
            String offset3 = offset2 + XmlHelper.tabulate();
            String offset4 = offset3 + XmlHelper.tabulate();
            String offset5 = offset4 + XmlHelper.tabulate();
            String offset6 = offset5 + XmlHelper.tabulate();
            file.println(offset2 + "<bufferpool>" + this.tsAttr.getBufferPool() + "</bufferpool>");
            file.println(offset2 + "<lockrule>" + this.tsAttr.getLockRule() + "</lockrule>");
            file.println(offset2 + "<lockmax>" + this.tsAttr.getLockMax() + "</lockmax>");
            file.println(offset2 + "<close>" + this.tsAttr.getClose() + "</close>");
            file.println(offset2 + "<segsize>" + this.tsAttr.getSegSize() + "</segsize>");
            file.println(offset2 + "<maxrows>" + this.tsAttr.getMaxRows() + "</maxrows>");
            if (this.tsAttr.getMemberCluster() != null) {
                file.println(offset2 + "<memclust>" + this.tsAttr.getMemberCluster() + "</memclust>");
            }
            if (!this.tsAttr.getPartitioned()) {
                file.println(offset2 + "<priqty>" + partAttr.getPriQty() + "</priqty>");
                file.println(offset2 + "<secqty>" + partAttr.getSecQty() + "</secqty>");
                file.println(offset2 + "<pctfree>" + partAttr.getPctFree() + "</pctfree>");
                file.println(offset2 + "<freepage>" + partAttr.getFreePage() + "</freepage>");
                file.println(offset2 + "<define>" + partAttr.getDefine() + "</define>");
                file.println(offset2 + "<compress>" + partAttr.getCompress() + "</compress>");
                file.println(offset2 + "<gbpcache>" + partAttr.getGbpCache() + "</gbpcache>");
            } else {
                file.println(offset2 + "<partitioning>");
                file.println(offset3 + "<keycols>");
                file.println(offset4 + "<name>" + this.tsAttr.getFirstKeyColName() + "</name>");
                String keyColName = null;
                while ((keyColName = this.tsAttr.getNextKeyColName()) != null) {
                    file.println(offset4 + "<name>" + keyColName + "</name>");
                }
                file.println(offset3 + "</keycols>");
                file.println(offset3 + "<parts>");
                do {
                    file.println(offset4 + "<part>");
                    file.println(offset5 + "<keyvalues>");
                    file.println(offset6 + "<keyvalue>" + partAttr.getFirstKeyColValue() + "</keyvalue>");
                    String keyValue = null;
                    while ((keyValue = partAttr.getNextKeyColValue()) != null) {
                        file.println(offset6 + "<keyvalue>" + keyValue + "</keyvalue>");
                    }
                    file.println(offset5 + "</keyvalues>");
                    file.println(offset5 + "<priqty>" + partAttr.getPriQty() + "</priqty>");
                    file.println(offset5 + "<secqty>" + partAttr.getSecQty() + "</secqty>");
                    file.println(offset5 + "<pctfree>" + partAttr.getPctFree() + "</pctfree>");
                    file.println(offset5 + "<freepage>" + partAttr.getFreePage() + "</freepage>");
                    file.println(offset5 + "<define>" + partAttr.getDefine() + "</define>");
                    file.println(offset5 + "<compress>" + partAttr.getCompress() + "</compress>");
                    file.println(offset5 + "<gbpcache>" + partAttr.getGbpCache() + "</gbpcache>");
                    file.println(offset4 + "</part>");
                } while ((partAttr = this.tsAttr.getNextPart()) != null);
                file.println(offset2 + "</partitioning>");
            }
            DbDb2PrimaryKey primaryKey = null;
            primaryKey = (DbDb2PrimaryKey)this.getPrimaryKey();
            if (primaryKey != null) {
                primaryKey.writeSpecificContentToXmlFile(file, offset1);
            }
            if (this.getIndexes() != null) {
                file.println(offset1 + "<indexes>");
                DbIndexIterator dbIndexIter = this.getIndexes().iterator();
                DbDb2Index dbindex = null;
                while (dbIndexIter.hasNext()) {
                    dbindex = (DbDb2Index)dbIndexIter.next();
                    dbindex.writeSpecificContentToXmlFile(file, offset2);
                }
                file.println(offset1 + "</indexes>");
            }
            file.println(offset0 + "</table>");
            return;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeSpecificContentToXmlFile: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    private boolean dbExists(String dbname) throws JddException {
        loc.entering("dbExists");
        String stmtTxt = null;
        try {
            DbFactory factory = this.getDbFactory();
            Connection con = factory.getConnection();
            boolean dbExists = false;
            stmtTxt = "SELECT NAME FROM SYSIBM.SYSDATABASE  WHERE NAME = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            pstmt1.setString(1, dbname);
            ResultSet rs1 = pstmt1.executeQuery();
            while (rs1.next()) {
                dbExists = true;
            }
            rs1.close();
            pstmt1.close();
            loc.exiting();
            return dbExists;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("dbExists: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("dbExists: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        loc.entering("getDdlStatementsForCreate");
        try {
            DbPrimaryKey primaryKey;
            DbIndexes indexes;
            DbDb2PartAttr partAttr = this.tsAttr.getFirstPart();
            String tabName = this.getName();
            boolean hasLobs = false;
            DbFactory factory = this.getDbFactory();
            Connection con = factory.getConnection();
            DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName());
            this.tsAttr.setPageSizeFactor(0.7);
            this.chooseClusteringIndex();
            DbColumns cols = this.getColumns();
            hasLobs = DbDb2Environment.hasLobs(cols);
            this.dbTableName = !DbDb2Parameters.isV8() && hasLobs ? DbDb2Environment.getLobTabName(con, tabName) : tabName;
            String SapjStogroup = DbDb2Stogroup.getStogroup(con);
            if (SapjStogroup == null) {
                Object[] arguments = new Object[]{this.getName(), DbDb2Environment.getSchema(con)};
                loc.errorT("getDdlStatementsForCreate {0}: No stogroup for java persistency for schema " + DbDb2Environment.getSchema(con) + " found in catalog", arguments);
                throw new JddException(ExType.NOT_ON_DB, "No stogroup for schema " + DbDb2Environment.getSchema(con));
            }
            boolean[] dbExists = new boolean[1];
            this.tspName = DbDb2Environment.getTspName(tabName);
            this.dbName = DbDb2Environment.getDbName(con, tabName, this.tspName, this.schema, dbExists);
            if (hasLobs) {
                DbDb2SqlStatement setLine = new DbDb2SqlStatement();
                setLine.addLine(" SET CURRENT RULES = 'DB2' ");
                tableDef.add(setLine);
            }
            DbDb2SqlStatement createLineNoCon = new DbDb2SqlStatement();
            DbDb2SqlStatement dbcreateLine = new DbDb2SqlStatement();
            if (!dbExists[0] || con == null) {
                dbcreateLine.addLine("CREATE DATABASE \"" + this.dbName + "\"");
                dbcreateLine.addLine(" CCSID  UNICODE ");
                if (con == null) {
                    dbcreateLine.addLine(" | ");
                    createLineNoCon.merge(dbcreateLine);
                } else {
                    tableDef.add(dbcreateLine);
                }
            }
            DbDb2SqlStatement tscreateLine = new DbDb2SqlStatement();
            tscreateLine.addLine("CREATE TABLESPACE \"" + this.tspName + "\"");
            tscreateLine.addLine(" IN \"" + this.dbName + "\"");
            tscreateLine.addLine(" USING STOGROUP " + SapjStogroup);
            if (DbDb2Parameters.isV7()) {
                tscreateLine.addLine(" PRIQTY " + partAttr.getPriQty());
                tscreateLine.addLine(" SECQTY " + partAttr.getSecQty());
            }
            tscreateLine.addLine(" FREEPAGE " + partAttr.getFreePage());
            tscreateLine.addLine(" PCTFREE " + partAttr.getPctFree());
            tscreateLine.addLine(" GBPCACHE " + partAttr.getGbpCache());
            tscreateLine.addLine(" DEFINE " + partAttr.getDefine());
            if (this.tsAttr.getMemberCluster() != null) {
                tscreateLine.addLine(" " + this.tsAttr.getMemberCluster() + " ");
            }
            tscreateLine.addLine(" BUFFERPOOL " + this.tsAttr.getBufferPool());
            tscreateLine.addLine(" LOCKSIZE " + this.tsAttr.getLockRule());
            tscreateLine.addLine(" LOCKMAX " + this.tsAttr.getLockMax());
            tscreateLine.addLine(" CLOSE " + this.tsAttr.getClose());
            tscreateLine.addLine(" COMPRESS " + partAttr.getCompress());
            tscreateLine.addLine(" MAXROWS " + this.tsAttr.getMaxRows());
            if (this.tsAttr.getPartitioned()) {
                int i = 0;
                while (partAttr != null) {
                    partAttr = this.tsAttr.getNextPart();
                    ++i;
                }
                tscreateLine.addLine(" NUMPARTS " + i);
            } else {
                tscreateLine.addLine(" SEGSIZE " + this.tsAttr.getSegSize());
            }
            tscreateLine.addLine(" CCSID  UNICODE ");
            if (con == null) {
                tscreateLine.addLine(" | ");
                createLineNoCon.merge(tscreateLine);
            } else {
                tableDef.add(tscreateLine);
            }
            DbDb2SqlStatement createLine = new DbDb2SqlStatement();
            createLine.addLine("CREATE TABLE " + DbDb2Environment.quote(this.getDbTableName()));
            createLine.merge(DbDb2Environment.getDdlClause(this, cols));
            createLine.addLine(" IN " + this.dbName.trim() + "." + this.tspName.trim());
            if (this.tsAttr.getPartitioned()) {
                createLine.addLine(" PARTITION BY ( " + this.tsAttr.getKeyColNames() + " ) ");
                createLine.addLine(" ( ");
                int i = 1;
                partAttr = this.tsAttr.getFirstPart();
                while (partAttr != null) {
                    if (i > 1) {
                        createLine.addLine(" , ");
                    }
                    createLine.addLine(" PART " + i + " VALUES ( " + partAttr.getKeyColValues() + " ) ");
                    ++i;
                    partAttr = this.tsAttr.getNextPart();
                }
                createLine.addLine(" ) ");
            }
            createLine.addLine(" CCSID  UNICODE ");
            if (con == null) {
                createLine.addLine(" | ");
                createLineNoCon.merge(createLine);
            } else {
                tableDef.add(createLine);
            }
            if (!DbDb2Parameters.isV8() && hasLobs) {
                DbSqlStatement viewcreateLine = this.getDdlStatementForCreateLobView(cols);
                if (con == null) {
                    viewcreateLine.addLine(" | ");
                    createLineNoCon.merge(viewcreateLine);
                } else {
                    tableDef.add(viewcreateLine);
                }
            }
            if (hasLobs) {
                DbColumnIterator iterator = cols.iterator();
                ArrayList ltsps = DbDb2Environment.getLobAuxTablespacesInDatabase(con, this.dbName);
                while (iterator.hasNext()) {
                    DbColumn col = iterator.next();
                    if (!DbDb2Environment.isLob(col)) continue;
                    String ltsp = DbDb2Environment.getLobAuxName(tabName, ltsps);
                    String ltb = DbDb2Environment.getAuxTabName(con, col.getName().toUpperCase());
                    DbDb2SqlStatement createLobTspLine = new DbDb2SqlStatement();
                    createLobTspLine.addLine(" CREATE LOB TABLESPACE " + ltsp + " IN " + this.dbName);
                    createLobTspLine.addLine(" USING STOGROUP " + SapjStogroup);
                    if (DbDb2Parameters.isV7()) {
                        createLobTspLine.addLine(" PRIQTY 200 SECQTY 10240 ");
                    }
                    createLobTspLine.addLine(" LOG YES LOCKMAX 0 GBPCACHE SYSTEM LOCKSIZE LOB  DEFINE YES ");
                    createLobTspLine.addLine(" BUFFERPOOL BP40 ");
                    if (con == null) {
                        createLobTspLine.addLine(" | ");
                        createLineNoCon.merge(createLobTspLine);
                    } else {
                        tableDef.add(createLobTspLine);
                    }
                    DbDb2SqlStatement createAuxTbLine = new DbDb2SqlStatement();
                    createAuxTbLine.addLine(" CREATE AUX TABLE " + DbDb2Environment.quote(ltb) + " IN " + this.dbName.trim() + "." + ltsp.trim());
                    createAuxTbLine.addLine(" STORES " + DbDb2Environment.quote(this.dbTableName) + " COLUMN " + DbDb2Environment.quote(col.getName()));
                    if (con == null) {
                        createAuxTbLine.addLine(" | ");
                        createLineNoCon.merge(createAuxTbLine);
                    } else {
                        tableDef.add(createAuxTbLine);
                    }
                    DbDb2SqlStatement createAuxIndLine = new DbDb2SqlStatement();
                    createAuxIndLine.addLine(" CREATE INDEX " + DbDb2Environment.quote(ltb) + " ON  " + DbDb2Environment.quote(ltb));
                    createAuxIndLine.addLine(" USING STOGROUP " + SapjStogroup);
                    if (DbDb2Parameters.isV7()) {
                        createAuxIndLine.addLine(" PRIQTY 16 SECQTY 10240 ");
                    }
                    createAuxIndLine.addLine(" FREEPAGE 10 PCTFREE 10 GBPCACHE CHANGED PIECESIZE 2097152 K  DEFINE YES ");
                    createAuxIndLine.addLine(" BUFFERPOOL BP40 ");
                    if (con == null) {
                        createAuxIndLine.addLine(" | ");
                        createLineNoCon.merge(createAuxIndLine);
                        continue;
                    }
                    tableDef.add(createAuxIndLine);
                }
            }
            if (con == null) {
                tableDef.add(createLineNoCon);
            }
            if ((indexes = this.getIndexes()) != null) {
                tableDef.merge(indexes.getDdlStatementsForCreate());
            }
            if ((primaryKey = this.getPrimaryKey()) != null) {
                tableDef.merge(primaryKey.getDdlStatementsForCreate());
            }
            loc.exiting();
            return tableDef;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForCreate: generation of create statement failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForDropLobView() {
        loc.entering("getDdlStatementsForDropLobView");
        String viewName = this.getName();
        DbObjectSqlStatements dropViewStmts = new DbObjectSqlStatements(viewName);
        DbDb2SqlStatement dropLine = new DbDb2SqlStatement(true);
        dropLine.addLine("DROP  VIEW " + DbDb2Environment.quote(viewName));
        dropViewStmts.add(dropLine);
        loc.exiting();
        return dropViewStmts;
    }

    public DbSqlStatement getDdlStatementForCreateLobView(DbColumns cols) throws JddException {
        loc.entering("getDdlStatementForCreateLobView");
        String viewName = this.getName();
        String tabName = this.getDbTableName();
        DbDb2SqlStatement createView = new DbDb2SqlStatement();
        createView.addLine("CREATE VIEW " + DbDb2Environment.quote(viewName) + " ( ");
        createView.merge(DbDb2Environment.getFieldNames(cols));
        createView.addLine(" ) AS SELECT ");
        createView.merge(DbDb2Environment.getFieldNames(cols));
        createView.addLine(" FROM " + DbDb2Environment.quote(tabName));
        loc.exiting();
        return createView;
    }

    private int sizeCategoryfromSecQty(int qty) {
        if (qty <= 40) {
            return 0;
        }
        if (qty > 40 && qty <= 160) {
            return 1;
        }
        if (qty > 160 && qty <= 640) {
            return 2;
        }
        if (qty > 640 && qty <= 2560) {
            return 3;
        }
        if (qty > 2560 && qty <= 10240) {
            return 4;
        }
        if (qty > 10240 && qty <= 20480) {
            return 5;
        }
        if (qty > 20480 && qty <= 40960) {
            return 6;
        }
        if (qty > 40960 && qty <= 81920) {
            return 7;
        }
        if (qty > 81920 && qty <= 163840) {
            return 8;
        }
        return 9;
    }

    public void chooseClusteringIndex() {
        DbIndex index;
        DbIndexIterator iterator;
        loc.entering("chooseClusteringIndex");
        DbDb2PrimaryKey PrimaryKey = (DbDb2PrimaryKey)this.getPrimaryKey();
        if (PrimaryKey != null && PrimaryKey.getIndex().isClustering()) {
            return;
        }
        DbIndexes indexes = this.getIndexes();
        if (indexes != null) {
            iterator = indexes.iterator();
            while (iterator.hasNext()) {
                index = iterator.next();
                if (!((DbDb2Index)index).isClustering()) continue;
                return;
            }
        }
        if (PrimaryKey != null) {
            PrimaryKey.getIndex().getIdxAttr().setClustering("YES");
        }
        if (indexes != null) {
            iterator = indexes.iterator();
            while (iterator.hasNext()) {
                index = iterator.next();
                ((DbDb2Index)index).getIdxAttr().setClustering("NO");
            }
        }
        loc.exiting();
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() throws JddException {
        String name = this.getDbTableName();
        DbFactory factory = this.getDbFactory();
        Connection con = factory.getConnection();
        return DbDb2Environment.getDdlStatementsForDrop(con, name, this.schema);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering("setSpecificContentViaXml");
        try {
            XmlMap indexesAttrXmlMap;
            int i;
            XmlMap tableAttrXmlMap = xmlMap.getXmlMap("table");
            String xmlName = tableAttrXmlMap.getString("name");
            if (!this.getName().equalsIgnoreCase(xmlName.trim())) {
                Object[] arguments = new Object[]{this.getName(), xmlName};
                loc.errorT("setSpecificContentViaXml: Table Name is {0} but XML Table Name is {1}.", arguments);
                loc.exiting();
                return;
            }
            this.tsAttr = new DbDb2TsAttr();
            this.tsAttr.setTable(this);
            DbDb2PartAttr partAttr = null;
            XmlMap partitioningXmlMap = tableAttrXmlMap.getXmlMap("partitioning");
            if (!partitioningXmlMap.isEmpty()) {
                XmlMap colsXmlMap;
                this.tsAttr.setPartitioned(new Boolean(true));
                Integer dsSize = tableAttrXmlMap.getIntegerObject("dssize");
                if (dsSize != null) {
                    this.tsAttr.setDsSize(dsSize);
                }
                if (!(colsXmlMap = partitioningXmlMap.getXmlMap("keycols")).isEmpty()) {
                    String col = null;
                    String colName = null;
                    i = 0;
                    while ((colName = colsXmlMap.getString(col = "name" + (i == 0 ? "" : "" + i))) != null) {
                        this.tsAttr.setKeyColName(colName);
                        ++i;
                    }
                }
                XmlMap partsXmlMap = partitioningXmlMap.getXmlMap("parts");
                if (!partsXmlMap.isEmpty()) {
                    XmlMap partXmlMap = null;
                    String partName = null;
                    int i2 = 0;
                    while (!(partXmlMap = partsXmlMap.getXmlMap(partName = "part" + (i2 == 0 ? "" : "" + i2))).isEmpty()) {
                        partAttr = this.tsAttr.setNextPart();
                        XmlMap keyValuesXmlMap = partXmlMap.getXmlMap("keyvalues");
                        String keyValueName = null;
                        String keyValue = null;
                        int j = 0;
                        while ((keyValue = keyValuesXmlMap.getString(keyValueName = "keyvalue" + (j == 0 ? "" : "" + j))) != null) {
                            partAttr.setKeyColValue(keyValue);
                            ++j;
                        }
                        partAttr.setDefine(tableAttrXmlMap.getString("define"));
                        partAttr.setCompress(partXmlMap.getString("compress"));
                        partAttr.setTrackMod(partXmlMap.getString("trackmod"));
                        this.setUsingBlockViaXml(partXmlMap, partAttr);
                        this.setFreeBlockViaXml(partXmlMap, partAttr);
                        this.setGbpCacheBlockViaXml(partXmlMap, partAttr);
                        ++i2;
                    }
                }
            } else {
                this.tsAttr.setPartitioned(new Boolean(false));
                partAttr = this.tsAttr.setNextPart();
                this.setUsingBlockViaXml(tableAttrXmlMap, partAttr);
                this.setFreeBlockViaXml(tableAttrXmlMap, partAttr);
                this.setGbpCacheBlockViaXml(tableAttrXmlMap, partAttr);
                partAttr.setDefine(tableAttrXmlMap.getString("define"));
                partAttr.setTrackMod(tableAttrXmlMap.getString("trackmod"));
                partAttr.setGbpCache(tableAttrXmlMap.getString("gbpcache"));
                partAttr.setCompress(tableAttrXmlMap.getString("compress"));
                this.tsAttr.setMemberCluster(tableAttrXmlMap.getString("memclust"));
                this.tsAttr.setDsSize(tableAttrXmlMap.getIntegerObject("dssize"));
                this.tsAttr.setSegSize(tableAttrXmlMap.getIntegerObject("segsize"));
            }
            this.tsAttr.setBufferPool(tableAttrXmlMap.getString("bufferpool"));
            this.tsAttr.setLockRule(tableAttrXmlMap.getString("lockrule"));
            this.tsAttr.setLockMax(tableAttrXmlMap.getIntegerObject("lockmax"));
            this.tsAttr.setPageSize(tableAttrXmlMap.getIntegerObject("pagesize"));
            this.tsAttr.setClose(tableAttrXmlMap.getString("close"));
            this.tsAttr.setMaxRows(tableAttrXmlMap.getIntegerObject("maxrows"));
            XmlMap primaryKeyAttrXmlMap = tableAttrXmlMap.getXmlMap("primary-key");
            if (!primaryKeyAttrXmlMap.isEmpty()) {
                ((DbDb2PrimaryKey)this.getPrimaryKey()).setSpecificContentViaXml(primaryKeyAttrXmlMap);
            }
            if (!(indexesAttrXmlMap = tableAttrXmlMap.getXmlMap("indexes")).isEmpty()) {
                XmlMap nextIndexAttrXmlMap = null;
                DbDb2Index dbIndex = null;
                i = 0;
                while (!(nextIndexAttrXmlMap = indexesAttrXmlMap.getXmlMap("index" + (i == 0 ? "" : "" + i))).isEmpty()) {
                    dbIndex = (DbDb2Index)this.getIndexes().getIndex(nextIndexAttrXmlMap.getString("name"));
                    dbIndex.setSpecificContentViaXml(nextIndexAttrXmlMap);
                    ++i;
                }
            }
            this.setDbSpecificIsSet(true);
            loc.exiting();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaXml: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    private void setUsingBlockViaXml(XmlMap xmlMap, DbDb2PartAttr partAttr) {
        partAttr.setPriQty(xmlMap.getIntegerObject("priqty"));
        partAttr.setSecQty(xmlMap.getIntegerObject("secqty"));
        this.tsAttr.setErase(xmlMap.getString("erase"));
    }

    private void setFreeBlockViaXml(XmlMap xmlMap, DbDb2PartAttr partAttr) {
        partAttr.setPctFree(xmlMap.getIntegerObject("pctfree"));
        partAttr.setFreePage(xmlMap.getIntegerObject("freepage"));
    }

    private void setGbpCacheBlockViaXml(XmlMap xmlMap, DbDb2PartAttr partAttr) {
        partAttr.setGbpCache(xmlMap.getString("gbpcache"));
    }

    public boolean existsOnDb() {
        loc.entering("existsOnDb");
        Object stmtTxt = null;
        try {
            String name = this.getDbTableName();
            DbFactory factory = this.getDbFactory();
            Connection con = factory.getConnection();
            if (con == null) {
                loc.exiting();
                return false;
            }
            boolean exists = DbDb2Environment.tableExistsOnDb(con, name);
            loc.exiting();
            return exists;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("existsOnDb: {0}", arguments);
            loc.exiting();
            return false;
        }
    }

    public boolean existsData() {
        loc.entering("existsData");
        String stmtTxt = null;
        try {
            String name = this.getDbTableName();
            DbFactory factory = this.getDbFactory();
            Connection con = factory.getConnection();
            if (con == null) {
                loc.exiting();
                return false;
            }
            boolean exists = true;
            stmtTxt = "SELECT 1 FROM " + DbDb2Environment.quote(name) + " " + " FETCH FIRST ROW ONLY" + " OPTIMIZE FOR 1 ROW" + " FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery();
            exists = rs.next();
            rs.close();
            stmt.close();
            loc.exiting();
            return exists;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("existsData: {0}", arguments);
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("existsData: {0}", arguments);
            loc.exiting();
            return false;
        }
    }

    public void setIndexesViaDb() throws JddException {
        loc.entering("setIndexesViaDb");
        try {
            ArrayList names = new ArrayList();
            DbFactory factory = this.getDbFactory();
            Connection con = factory.getConnection();
            names = this.dbGetIndexNames(con);
            if (names != null && !names.isEmpty()) {
                DbIndexes indexes = new DbIndexes(factory);
                indexes.setTable(this);
                int i = 0;
                while (i < names.size()) {
                    DbDb2Index index = new DbDb2Index(factory, this.getName(), (String)names.get(i));
                    index.setIndexes(indexes);
                    index.setCommonContentViaDb();
                    index.setSpecificContentViaDb();
                    indexes.add(index);
                    ++i;
                }
                this.setIndexes(indexes);
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setIndexesViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setPrimaryKeyViaDb() throws JddException {
        loc.entering("setPrimaryKeyViaDb");
        try {
            Connection con = this.getDbFactory().getConnection();
            DbDb2Index index = this.dbGetPrimaryKeyIndex(con);
            if (index != null) {
                DbDb2PrimaryKey primaryKey = new DbDb2PrimaryKey(this.getDbFactory(), this.getSchema(), this.getName(), index);
                primaryKey.setCommonContentViaDb();
                this.setPrimaryKey(primaryKey);
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setPrimaryKeyViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbDb2Index dbGetPrimaryKeyIndex(Connection con) {
        loc.entering("dbGetPrimaryKeyName");
        if (con == null) {
            loc.exiting();
            return null;
        }
        String stmtTxt = null;
        try {
            String name = null;
            DbDb2Index index = null;
            stmtTxt = "SELECT NAME   FROM  SYSIBM.SYSINDEXES  WHERE UNIQUERULE = 'P'  AND TBNAME  = ?  AND CREATOR = ?  AND TBCREATOR = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, this.getDbTableName());
            stmt.setString(2, this.schema);
            stmt.setString(3, this.schema);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                name = rset.getString(1);
                index = new DbDb2Index(this.getDbFactory(), this.getName(), name);
                DbIndexes indexes = new DbIndexes(this.getDbFactory());
                index.setIndexes(indexes);
                indexes.add(index);
                indexes.setTable(this);
                index.setCommonContentViaDb();
                index.setForPrimaryKey();
            }
            rset.close();
            stmt.close();
            return index;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{this.getName(), DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("dbGetPrimaryKeyName ({0}): {1}", arguments);
            loc.exiting();
            return null;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("dbGetPrimaryKeyName ({0}) failed: {1}", arguments);
            loc.exiting();
            return null;
        }
    }

    public void setSizecatIndexes(int sizecat) {
        DbIndexes indexes;
        loc.entering("setSizecatIndexes");
        DbDb2PrimaryKey primaryKey = (DbDb2PrimaryKey)this.getPrimaryKey();
        if (primaryKey != null) {
            primaryKey.getIndex().setTabSizecat(sizecat);
        }
        if ((indexes = this.getIndexes()) != null) {
            DbIndexIterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                DbIndex index = iterator.next();
                ((DbDb2Index)index).setTabSizecat(sizecat);
            }
        }
        loc.exiting();
    }

    public void setCommonContentViaDb(DbFactory factory) throws JddException {
        loc.entering("setCommonContentViaDb");
        try {
            this.setColumnsViaDb(factory);
            this.setPrimaryKeyViaDb();
            this.setIndexesViaDb();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("setCommonContentViaDb ({0}) failed: {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setColumnsViaDb(DbFactory factory) throws JddException {
        loc.entering("setColumnsViaDb");
        try {
            DbDb2Columns cols = new DbDb2Columns(factory);
            cols.setTable(this);
            cols.setContentViaDb(factory);
            this.setColumns(cols);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("setCommonContentViaDb ({0}) failed: {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength()");
        String tabName = this.getName();
        boolean check = true;
        if (tabName.length() > DbDb2Parameters.maxTabNameLen) {
            check = false;
            Object[] arguments = new Object[]{tabName, new Integer(tabName.length()), new Integer(DbDb2Parameters.maxTabNameLen)};
            loc.errorT("checkNameLength {0}: length of table name {1} not in allowed range [1,{2}]", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth()");
        boolean check = true;
        DbColumns cols = this.getColumns();
        int rowLength = DbDb2Environment.getRowLength(cols);
        if (rowLength > DbDb2Parameters.maxRowLen) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(rowLength), new Integer(DbDb2Parameters.maxRowLen)};
            loc.errorT("checkWidth {0}: total width of table ({1} bytes) greater than allowed maximum ({2} bytes)", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        loc.entering("checkNameForReservedWord");
        boolean isReserved = DbDb2Environment.isReservedWord(this.getName());
        if (isReserved) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("checkNameForReservedWord {0}: reserved", arguments);
        }
        loc.exiting();
        return !isReserved;
    }

    public DbObjectSqlStatements getDdlStatementsforAlterTsp() throws JddException {
        loc.entering("getDdlStatementsForAlterTsp");
        try {
            DbDb2PartAttr partAttr = this.tsAttr.getFirstPart();
            DbFactory factory = this.getDbFactory();
            Connection con = factory.getConnection();
            DbObjectSqlStatements tspAlter = new DbObjectSqlStatements(this.getName());
            if (this.tspName == null || this.dbName == null) {
                this.setTspAndDbName(con);
            }
            DbDb2SqlStatement tspAlterLine = new DbDb2SqlStatement();
            tspAlterLine.addLine(" ALTER TABLESPACE " + this.dbName + "." + this.tspName);
            if (DbDb2Parameters.isV7()) {
                tspAlterLine.addLine(" PRIQTY " + partAttr.getPriQty());
                tspAlterLine.addLine(" SECQTY " + partAttr.getSecQty());
            }
            tspAlterLine.addLine(" FREEPAGE " + partAttr.getFreePage());
            tspAlterLine.addLine(" PCTFREE " + partAttr.getPctFree());
            tspAlterLine.addLine(" LOCKSIZE " + this.tsAttr.getLockRule());
            tspAlterLine.addLine(" LOCKMAX " + this.tsAttr.getLockMax());
            tspAlterLine.addLine(" CLOSE " + this.tsAttr.getClose());
            tspAlterLine.addLine(" COMPRESS " + partAttr.getCompress());
            tspAlter.add(tspAlterLine);
            return tspAlter;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("getDdlStatementsForAlterTsp ({0}) failed: {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setTspAndDbName(Connection con) throws JddException {
        loc.entering("setTspAndDbName");
        String stmtTxt = null;
        try {
            stmtTxt = "SELECT DBNAME, TSNAME   FROM  SYSIBM.SYSTABLES  WHERE NAME = ? AND CREATOR = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, this.getDbTableName());
            stmt.setString(2, this.schema);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                this.dbName = rset.getString(1);
                this.tspName = rset.getString(2);
            }
            rset.close();
            stmt.close();
            return;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{this.getName(), DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("setTspAndDbName ({0}): {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("setTspAndDbName ({0}) failed: {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setDbTableName(String dbTabName) throws JddException {
        this.dbTableName = dbTabName;
    }

    public String getDbTableName() {
        loc.entering("getDbTableName");
        String stmtTxt = null;
        try {
            String tableName;
            if (null != this.dbTableName) {
                return this.dbTableName;
            }
            String dbTabName = tableName = this.getName();
            String hTabName = null;
            hTabName = tableName.length() >= DbDb2Parameters.maxTabNameLen ? "#" + tableName.substring(0, DbDb2Parameters.maxTabNameLen - 1) : "#" + tableName;
            Connection con = this.getDbFactory().getConnection();
            if (con == null) {
                return tableName;
            }
            String schema = DbDb2Environment.getSchema(con);
            stmtTxt = " SELECT A.TYPE, A.NAME, B.BNAME FROM SYSIBM.SYSTABLES A  LEFT OUTER JOIN SYSIBM.SYSVIEWDEP B   ON A.NAME = B.DNAME  AND A.CREATOR = B.DCREATOR  AND A.CREATOR = B.BCREATOR  WHERE ( A.NAME = ?  OR A.NAME = ? )  AND A.CREATOR = ?  OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, tableName);
            stmt.setString(2, hTabName);
            stmt.setString(3, schema);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (0 == rs.getString(1).trim().compareTo("T") && 0 == rs.getString(2).trim().compareTo(tableName)) {
                    this.lobViewMissing = false;
                    break;
                }
                if (0 == rs.getString(1).trim().compareTo("V") && 0 == rs.getString(2).trim().compareTo(tableName)) {
                    String s = rs.getString(3).trim();
                    if (s.length() <= 0 || s.charAt(0) != '#') continue;
                    dbTabName = s;
                    this.lobViewMissing = false;
                    break;
                }
                if (0 != rs.getString(1).trim().compareTo("T") || 0 != rs.getString(2).trim().compareTo(hTabName)) continue;
                this.lobViewMissing = true;
                dbTabName = hTabName;
            }
            stmt.close();
            rs.close();
            this.dbTableName = dbTabName;
            loc.exiting();
            return this.dbTableName;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{this.getName(), DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("getDbTableName ({0}): {1}", arguments);
            loc.exiting();
            return this.getName();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("getDbTableName ({0}) failed: {1}", arguments);
            loc.exiting();
            return this.getName();
        }
    }

    public DbTableDifference compareTo(DbTable target) throws Exception {
        loc.entering("compareTo");
        DbTableDifference tableDiff = super.compareTo(target);
        DbDb2TableDifference dbtableDiff = null;
        DbDb2Table dbtarget = (DbDb2Table)target;
        dbtarget.setLobTable(this.getDbTableName());
        dbtarget.tsAttr.setPageSizeFactor(1.0);
        if (!this.DbSpecificIsSet()) {
            this.setSpecificContentViaDb();
        }
        if (tableDiff == null) {
            dbtableDiff = new DbDb2TableDifference(this, target);
        } else if (tableDiff instanceof DbDb2TableDifference) {
            dbtableDiff = (DbDb2TableDifference)tableDiff;
        }
        if (dbtableDiff != null) {
            dbtableDiff.diffPageSize(this, (DbDb2Table)target);
            dbtableDiff.diffLobView(this);
        }
        loc.exiting();
        if (tableDiff == null && dbtableDiff.getTblspAction() == Action.NOTHING && !dbtableDiff.getLobViewMissing()) {
            return null;
        }
        if (dbtableDiff != null) {
            return dbtableDiff;
        }
        return tableDiff;
    }

    public void setLobTable(String lobTableName) {
        DbColumnIterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            DbDb2Column column = (DbDb2Column)iterator.next();
            if (!DbDb2Environment.isLob(column)) continue;
            column.setLobTableName(lobTableName);
        }
    }

    public boolean isLobViewMissing() {
        return this.lobViewMissing;
    }
}

