/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class DbDb2Stogroup {
    private static Location loc = Logger.getLocation("db2.DbDb2Stogroup");
    private static boolean checkVcat = false;
    private static Hashtable connections = new Hashtable();

    DbDb2Stogroup(DbFactory factory) {
    }

    public static String getStogroup(Connection con) {
        loc.entering("getStogroup");
        String stmtTxt = null;
        try {
            if (con == null) {
                return "________";
            }
            if (connections.containsKey(con)) {
                return (String)connections.get(con);
            }
            String stogroup = null;
            String schema = DbDb2Environment.getSchema(con);
            stmtTxt = "SELECT NAME  FROM  SYSIBM.SYSSTOGROUP  WHERE CREATOR = ?  AND NAME = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            pstmt1.setString(1, schema);
            pstmt1.setString(2, schema.toUpperCase());
            ResultSet rs = pstmt1.executeQuery();
            if (rs.next()) {
                stogroup = rs.getString(1).trim();
            }
            rs.close();
            if (stogroup == null) {
                stmtTxt = "SELECT NAME  FROM  SYSIBM.SYSSTOGROUP  WHERE CREATOR = ?  ORDER BY NAME  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                pstmt1.setString(1, schema.toUpperCase());
                rs = pstmt1.executeQuery();
                if (rs.next()) {
                    stogroup = rs.getString(1).trim();
                }
                rs.close();
            }
            if (stogroup == null && schema.length() >= 6) {
                stmtTxt = "SELECT NAME  FROM  SYSIBM.SYSSTOGROUP  WHERE NAME LIKE ?  ORDER BY NAME  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                pstmt1.setString(1, schema.toUpperCase().substring(0, 6) + "%");
                rs = pstmt1.executeQuery();
                if (rs.next()) {
                    stogroup = rs.getString(1).trim();
                }
                rs.close();
            }
            if (stogroup == null) {
                stmtTxt = "SELECT NAME  FROM  SYSIBM.SYSSTOGROUP  WHERE NAME  = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                pstmt1.setString(1, "SAPJ");
                rs = pstmt1.executeQuery();
                if (rs.next()) {
                    stogroup = rs.getString(1).trim();
                }
                rs.close();
            }
            if (checkVcat && stogroup != null) {
                stmtTxt = "SELECT B.NAME, A.VCATNAME  FROM  SYSIBM.SYSSTOGROUP A, SYSIBM.SYSSTOGROUP B  WHERE A.CREATOR = ?  AND A.NAME  = ?  AND A.VCATNAME  =  B.VCATNAME AND B.NAME  <>  A.NAME OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                pstmt1.setString(1, schema);
                pstmt1.setString(2, stogroup);
                rs = pstmt1.executeQuery();
                while (rs.next()) {
                    Object[] arguments = new Object[]{stogroup, rs.getString(2), rs.getString(1)};
                    loc.warningT("getStogroup: stogroup {0} has same high level qualifier {1} as {2}", arguments);
                }
                rs.close();
            }
            pstmt1.close();
            connections.put(con, stogroup);
            loc.exiting();
            return stogroup;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("getDatabaseNameViaDb: {0}", arguments);
            loc.exiting();
            return "________";
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDatabaseNameViaDb: {0}", arguments);
            loc.exiting();
            return "________";
        }
    }
}

