/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Stogroup;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DbDb2SqlStatement
extends DbSqlStatement {
    private static Location loc = Logger.getLocation("db2.DbDb2SqlStatement");
    private static final int DEFAULT = 0;
    private static final int CREATE_DATABASE = 1;
    private static final int CREATE_INDEX = 2;
    private static final int DROP_TABLE = 3;
    private static ArrayList db2DdlWords = null;
    boolean catchIfNotFound = false;

    public DbDb2SqlStatement() {
    }

    public DbDb2SqlStatement(boolean catchIfNotFound) {
        super(catchIfNotFound);
        this.catchIfNotFound = catchIfNotFound;
    }

    public boolean execute(Connection con) {
        loc.entering("execute");
        try {
            String sql = this.toString().trim();
            ArrayList slst = null;
            int type = DbDb2SqlStatement.typeDb2DdlStmt(sql);
            slst = this.substituteDdlStmt(con, type, sql);
            if (null == slst || null == con) {
                loc.exiting();
                return super.execute(con);
            }
            Iterator iter = ((AbstractList)slst).iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                Statement statementObject = NativeSQLAccess.createNativeStatement((Connection)con);
                try {
                    statementObject.executeUpdate(s);
                }
                catch (SQLException ex) {
                    boolean rc = this.analyseError(con, ex, s, type == 3);
                    if (rc) continue;
                    loc.exiting();
                    return rc;
                }
            }
            return true;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("DbDb2SqlStatement: {0}", arguments);
            loc.exiting();
            return super.execute(con);
        }
    }

    private ArrayList substituteDdlStmt(Connection con, int type, String sql) throws SQLException {
        switch (type) {
            case 1: {
                return this.SubstituteDdlStmtForCreateDatabase(con, sql);
            }
            case 2: {
                return this.SubstituteDdlStmtForCreateIndex(con, sql);
            }
            case 3: {
                return this.SubstituteDdlStmtForDropTable(con, sql);
            }
        }
        return null;
    }

    private String getTabName(String sql) {
        StringTokenizer st = new StringTokenizer(sql);
        boolean tok1Found = false;
        boolean tok2Found = false;
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (tok2Found) {
                if (s.startsWith("\"") && s.endsWith("\"")) {
                    s = s.substring(1, s.length() - 1);
                }
                if (s.startsWith("#")) {
                    s = s.substring(1, s.length());
                }
                return s;
            }
            if (tok1Found && 0 == s.compareTo("TABLE")) {
                tok2Found = true;
            }
            tok1Found = 0 == s.compareTo("CREATE") || 0 == s.compareTo("DROP");
        }
        return null;
    }

    private ArrayList SubstituteDdlStmtForCreateDatabase(Connection con, String sql) throws SQLException {
        String tabName = this.getTabName(sql);
        if (tabName == null) {
            return null;
        }
        boolean[] dbExists = new boolean[1];
        String dbName = null;
        try {
            String tspName = DbDb2Environment.getTspName(tabName);
            dbName = DbDb2Environment.getDbName(con, tabName, tspName, this.getSchema(con), dbExists);
        }
        catch (JddException ex) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(sql, "|");
        String dbNameTok = dbName.substring(5, 8);
        String stgName = this.getStogroup(con);
        ArrayList<String> slst = new ArrayList<String>();
        int stmt = 0;
        boolean rc = false;
        block46: while (st.hasMoreTokens()) {
            String dbStmt = st.nextToken();
            switch (++stmt) {
                case 1: {
                    if (dbExists[0]) continue block46;
                    StringTokenizer ststmt = new StringTokenizer(dbStmt);
                    int stmtCnt = ststmt.countTokens();
                    if (stmtCnt < 3) {
                        return null;
                    }
                    String stmtNew = "";
                    int cnt = 0;
                    String s = "";
                    while (ststmt.hasMoreTokens()) {
                        s = ststmt.nextToken();
                        switch (++cnt) {
                            case 1: {
                                if (0 == s.compareToIgnoreCase("CREATE")) break;
                                return null;
                            }
                            case 2: {
                                if (0 == s.compareToIgnoreCase("DATABASE")) break;
                                return null;
                            }
                            case 3: {
                                s = this.sReplace(s, "___", dbNameTok);
                                break;
                            }
                        }
                        stmtNew = stmtNew + " " + s;
                    }
                    slst.add(stmtNew);
                    break;
                }
                case 2: {
                    String s;
                    StringTokenizer ststmt = new StringTokenizer(dbStmt);
                    int stmtCnt = ststmt.countTokens();
                    if (stmtCnt < 4) {
                        return null;
                    }
                    String stmtNew = "";
                    int cnt = 0;
                    while (ststmt.hasMoreTokens()) {
                        s = ststmt.nextToken();
                        switch (++cnt) {
                            case 1: {
                                if (0 == s.compareToIgnoreCase("CREATE")) break;
                                return null;
                            }
                            case 2: {
                                if (0 == s.compareToIgnoreCase("TABLESPACE")) break;
                                return null;
                            }
                            case 4: {
                                if (0 == s.compareToIgnoreCase("IN")) break;
                                return null;
                            }
                            case 5: {
                                s = this.sReplace(s, "___", dbNameTok);
                                break;
                            }
                            case 6: {
                                if (0 == s.compareToIgnoreCase("USING")) break;
                                return null;
                            }
                            case 7: {
                                if (0 == s.compareToIgnoreCase("STOGROUP")) break;
                                return null;
                            }
                            case 8: {
                                s = this.sReplace(s, "________", stgName);
                                break;
                            }
                        }
                        stmtNew = stmtNew + " " + s;
                    }
                    slst.add(stmtNew);
                    break;
                }
                case 3: {
                    String s;
                    StringTokenizer ststmt = new StringTokenizer(dbStmt);
                    int stmtCnt = ststmt.countTokens();
                    if (stmtCnt < 4) {
                        return null;
                    }
                    String stmtNew = "";
                    int cnt = 0;
                    while (ststmt.hasMoreTokens()) {
                        s = ststmt.nextToken();
                        if (++cnt == stmtCnt - 3 && 0 != s.compareToIgnoreCase("IN")) {
                            return null;
                        }
                        if (cnt == stmtCnt - 2) {
                            s = this.sReplace(s, "___", dbNameTok);
                        }
                        stmtNew = stmtNew + " " + s;
                    }
                    slst.add(stmtNew);
                    break;
                }
                default: {
                    String s;
                    int cnt;
                    String stmtNew;
                    int stmtCnt;
                    StringTokenizer ststmt;
                    if (stmt >= 5 && (stmt - 5) % 3 == 0) {
                        ststmt = new StringTokenizer(dbStmt);
                        stmtCnt = ststmt.countTokens();
                        if (stmtCnt < 4) {
                            return null;
                        }
                        stmtNew = "";
                        cnt = 0;
                        while (ststmt.hasMoreTokens()) {
                            s = ststmt.nextToken();
                            switch (++cnt) {
                                case 1: {
                                    if (0 == s.compareToIgnoreCase("CREATE")) break;
                                    return null;
                                }
                                case 2: {
                                    if (0 == s.compareToIgnoreCase("LOB")) break;
                                    return null;
                                }
                                case 3: {
                                    if (0 == s.compareToIgnoreCase("TABLESPACE")) break;
                                    return null;
                                }
                                case 5: {
                                    if (0 == s.compareToIgnoreCase("IN")) break;
                                    return null;
                                }
                                case 6: {
                                    s = this.sReplace(s, "___", dbNameTok);
                                    break;
                                }
                                case 7: {
                                    if (0 == s.compareToIgnoreCase("USING")) break;
                                    return null;
                                }
                                case 8: {
                                    if (0 == s.compareToIgnoreCase("STOGROUP")) break;
                                    return null;
                                }
                                case 9: {
                                    s = this.sReplace(s, "________", stgName);
                                    break;
                                }
                            }
                            stmtNew = stmtNew + " " + s;
                        }
                    } else if (stmt >= 5 && (stmt - 5) % 3 == 1) {
                        ststmt = new StringTokenizer(dbStmt);
                        stmtCnt = ststmt.countTokens();
                        if (stmtCnt < 4) {
                            return null;
                        }
                        stmtNew = "";
                        cnt = 0;
                        while (ststmt.hasMoreTokens()) {
                            s = ststmt.nextToken();
                            switch (++cnt) {
                                case 1: {
                                    if (0 == s.compareToIgnoreCase("CREATE")) break;
                                    return null;
                                }
                                case 2: {
                                    if (0 == s.compareToIgnoreCase("AUX")) break;
                                    return null;
                                }
                                case 3: {
                                    if (0 == s.compareToIgnoreCase("TABLE")) break;
                                    return null;
                                }
                                case 5: {
                                    if (0 == s.compareToIgnoreCase("IN")) break;
                                    return null;
                                }
                                case 6: {
                                    s = this.sReplace(s, "___", dbNameTok);
                                    break;
                                }
                            }
                            stmtNew = stmtNew + " " + s;
                        }
                    } else if (stmt >= 5 && (stmt - 5) % 3 == 2) {
                        ststmt = new StringTokenizer(dbStmt);
                        stmtCnt = ststmt.countTokens();
                        if (stmtCnt < 4) {
                            return null;
                        }
                        stmtNew = "";
                        cnt = 0;
                        while (ststmt.hasMoreTokens()) {
                            s = ststmt.nextToken();
                            switch (++cnt) {
                                case 1: {
                                    if (0 == s.compareToIgnoreCase("CREATE")) break;
                                    return null;
                                }
                                case 2: {
                                    if (0 == s.compareToIgnoreCase("INDEX")) break;
                                    return null;
                                }
                                case 4: {
                                    if (0 == s.compareToIgnoreCase("ON")) break;
                                    return null;
                                }
                                case 6: {
                                    if (0 == s.compareToIgnoreCase("USING")) break;
                                    return null;
                                }
                                case 7: {
                                    if (0 == s.compareToIgnoreCase("STOGROUP")) break;
                                    return null;
                                }
                                case 8: {
                                    s = this.sReplace(s, "________", stgName);
                                    break;
                                }
                            }
                            stmtNew = stmtNew + " " + s;
                        }
                    } else {
                        stmtNew = dbStmt;
                    }
                    slst.add(stmtNew);
                }
            }
        }
        return slst;
    }

    private ArrayList SubstituteDdlStmtForCreateIndex(Connection con, String sql) throws SQLException {
        StringTokenizer ststmt = new StringTokenizer(sql);
        int stmtCnt = ststmt.countTokens();
        if (stmtCnt < 3) {
            return null;
        }
        String stmtNew = "";
        int cnt = 0;
        String s = "";
        boolean indexTokenFound = false;
        boolean usingTokenFound = false;
        boolean stogroupTokenFound = false;
        boolean replace = false;
        while (ststmt.hasMoreTokens()) {
            s = ststmt.nextToken();
            switch (++cnt) {
                case 1: {
                    if (0 == s.compareToIgnoreCase("CREATE")) break;
                    return null;
                }
                default: {
                    if (0 == s.compareToIgnoreCase("INDEX")) {
                        indexTokenFound = true;
                        break;
                    }
                    if (0 == s.compareToIgnoreCase("USING")) {
                        usingTokenFound = true;
                        break;
                    }
                    if (0 == s.compareToIgnoreCase("STOGROUP")) {
                        stogroupTokenFound = true;
                        break;
                    }
                    if (!indexTokenFound || !usingTokenFound || !stogroupTokenFound || replace) break;
                    s = this.sReplace(s, "________", this.getStogroup(con));
                    replace = true;
                }
            }
            stmtNew = stmtNew + " " + s;
        }
        if (replace) {
            ArrayList<String> slst = new ArrayList<String>();
            slst.add(stmtNew);
            return slst;
        }
        return null;
    }

    private ArrayList SubstituteDdlStmtForDropTable(Connection con, String sql) throws SQLException {
        StringTokenizer ststmt = new StringTokenizer(sql);
        int stmtCnt = ststmt.countTokens();
        if (stmtCnt != 4) {
            return null;
        }
        String stmtNew = "";
        int cnt = 0;
        String s = "";
        String tabname = null;
        block10: while (ststmt.hasMoreTokens()) {
            s = ststmt.nextToken();
            switch (++cnt) {
                case 1: {
                    if (0 == s.compareToIgnoreCase("DROP")) break;
                    return null;
                }
                case 2: {
                    if (0 == s.compareToIgnoreCase("TABLE")) break;
                    return null;
                }
                case 3: {
                    tabname = s.trim();
                    if (!tabname.startsWith("\"") || !tabname.endsWith("\"")) continue block10;
                    tabname = tabname.substring(1, tabname.length() - 1);
                    break;
                }
                case 4: {
                    if (0 == s.compareToIgnoreCase("+LOCATION")) break;
                    return null;
                }
            }
        }
        try {
            DbObjectSqlStatements newDropStmts = DbDb2Environment.getDdlStatementsForDrop(con, tabname, this.getSchema(con));
            ArrayList<String> slst = new ArrayList<String>();
            try {
                int i = 0;
                while (true) {
                    DbSqlStatement stmt = newDropStmts.getStatement(i);
                    s = stmt.toString().trim();
                    slst.add(s);
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                if (slst.isEmpty()) {
                    return null;
                }
                return slst;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String sReplace(String s, String t, String u) {
        int i = s.indexOf(t);
        if (i < 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s);
        buf.replace(i, i + t.length(), u);
        return new String(buf);
    }

    private boolean dbExists(Connection con, String dbname) throws SQLException {
        String stmtTxt = null;
        if (dbname.startsWith("\"") && dbname.endsWith("\"")) {
            dbname = dbname.substring(1, dbname.length() - 1);
        }
        boolean dbExists = false;
        stmtTxt = "SELECT NAME FROM SYSIBM.SYSDATABASE  WHERE NAME = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
        PreparedStatement pstmt1 = con.prepareStatement(stmtTxt);
        pstmt1.setString(1, dbname);
        ResultSet rs1 = pstmt1.executeQuery();
        if (rs1.next()) {
            dbExists = true;
        }
        rs1.close();
        pstmt1.close();
        return dbExists;
    }

    private String getStogroup(Connection con) throws SQLException {
        return DbDb2Stogroup.getStogroup(con);
    }

    private String getSchema(Connection con) throws SQLException {
        return DbDb2Environment.getSchema(con);
    }

    public static int typeDb2DdlStmt(String sql) {
        int type = 0;
        StringTokenizer st = new StringTokenizer(sql);
        if (st.hasMoreTokens()) {
            String s = st.nextToken();
            int ddlType = DbDb2SqlStatement.indexReservedWord(s);
            switch (ddlType) {
                case 0: {
                    boolean found = false;
                    if (!st.hasMoreTokens()) break;
                    s = st.nextToken();
                    if (0 == s.compareToIgnoreCase("DATABASE")) {
                        type = 1;
                    } else if (0 == s.compareToIgnoreCase("INDEX") || 0 == s.compareToIgnoreCase("UNIQUE") || 0 == s.compareToIgnoreCase("TYPE")) {
                        type = 2;
                    }
                    if (type == 0) break;
                    boolean isDb2DdlStmt = false;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (0 > s.indexOf("___")) continue;
                        isDb2DdlStmt = true;
                        break;
                    }
                    if (isDb2DdlStmt) break;
                    type = 0;
                    break;
                }
                case 1: {
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (0 != s.compareToIgnoreCase("TABLE") || (type = 3) == 0) break;
                    boolean isDb2DdlStmt = false;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (0 > s.indexOf("+LOCATION")) continue;
                        isDb2DdlStmt = true;
                        break;
                    }
                    if (isDb2DdlStmt) break;
                    type = 0;
                }
            }
        }
        return type;
    }

    private static int indexReservedWord(String id) {
        if (db2DdlWords == null) {
            db2DdlWords = new ArrayList();
            db2DdlWords.add("CREATE");
            db2DdlWords.add("DROP");
            Collections.sort(db2DdlWords);
        }
        return Collections.binarySearch(db2DdlWords, id);
    }

    public boolean analyseError(Connection con, SQLException ex, String stmtTxt, boolean isDrop) {
        loc.entering("analyseError");
        String tabName = this.getTabName(stmtTxt);
        if (tabName == null) {
            tabName = " ";
        }
        try {
            if (isDrop && ex.getErrorCode() == -204) {
                Object[] arguments = new Object[]{tabName, DbDb2Environment.getSQLError(ex, stmtTxt)};
                loc.infoT("DbDb2SqlStatment ({0}): {1}", arguments);
                loc.exiting();
                return true;
            }
            Object[] arguments = new Object[]{tabName, DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("DbDb2SqlStatment ({0}): {1}", arguments);
            loc.exiting();
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

