/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Index;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;

public class DbDb2PrimaryKey
extends DbPrimaryKey {
    private static Location loc = Logger.getLocation("db2.DbDb2PrimaryKey");
    String schema = null;
    DbDb2Index index = null;

    public DbDb2PrimaryKey() {
    }

    public DbDb2PrimaryKey(DbFactory factory, DbPrimaryKey other) {
        super(factory, other);
        this.setSchema(factory);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2PrimaryKey(DbFactory factory) {
        super(factory);
        this.setSchema(factory);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2PrimaryKey(DbFactory factory, DbSchema schema, String tableName) {
        super(factory, schema, tableName);
        this.setSchema(factory);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2PrimaryKey(DbFactory factory, String tableName) {
        super(factory, tableName);
        this.setSchema(factory);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2PrimaryKey(DbFactory factory, String tableName, DbDb2Index index) {
        super(factory, tableName);
        this.setSchema(factory);
        DbDb2Parameters.setValues(factory.getConnection());
        this.index = index;
    }

    public DbDb2PrimaryKey(DbFactory factory, DbSchema schema, String tableName, DbDb2Index index) {
        super(factory, schema, tableName);
        this.setSchema(factory);
        DbDb2Parameters.setValues(factory.getConnection());
        this.index = index;
    }

    private void setSchema(DbFactory factory) {
        String schema = null;
        DbSchema dbschema = this.getDbSchema();
        if (dbschema != null) {
            schema = dbschema.getSchemaName();
        }
        if (schema == null) {
            Connection con = factory.getConnection();
            this.schema = DbDb2Environment.getSchema(con);
        } else {
            this.schema = schema;
        }
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering("getDdlStatementsForCreate");
        String tableName = ((DbDb2Table)this.getTable()).getDbTableName();
        DbObjectSqlStatements priKeyDef = new DbObjectSqlStatements(tableName);
        DbSqlStatement createStatement = new DbSqlStatement();
        DbFactory factory = this.getDbFactory();
        this.setSchema(factory);
        if (null == this.index) {
            String indName = this.getAuxIndName(this.getTableName());
            this.index = new DbDb2Index(this.getDbFactory(), this.getTableName(), indName);
            this.index.setContent(true, this.getColumnNames());
            this.index.setForPrimaryKey();
            DbIndexes indexes = new DbIndexes(factory);
            this.index.setIndexes(indexes);
            indexes.add(this.index);
            indexes.setTable(this.getTable());
        }
        priKeyDef.merge(this.index.getDdlStatementsForCreate());
        createStatement.addLine("ALTER TABLE " + DbDb2Environment.quote(tableName) + " ADD PRIMARY KEY ");
        createStatement.merge(this.getDdlColumnsClause());
        priKeyDef.add(createStatement);
        loc.exiting();
        return priKeyDef;
    }

    public DbObjectSqlStatements getDdlStatementsForCreateKey() {
        loc.entering("getDdlStatementsForCreateKey");
        String tableName = ((DbDb2Table)this.getTable()).getDbTableName();
        DbObjectSqlStatements priKeyDef = new DbObjectSqlStatements(tableName);
        DbSqlStatement createStatement = new DbSqlStatement();
        DbFactory factory = this.getDbFactory();
        this.setSchema(factory);
        createStatement.addLine("ALTER TABLE " + tableName + " ADD PRIMARY KEY ");
        createStatement.merge(this.getDdlColumnsClause());
        priKeyDef.add(createStatement);
        loc.exiting();
        return priKeyDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering("getDdlStatementsForDrop");
        String tableName = ((DbDb2Table)this.getTable()).getDbTableName();
        DbObjectSqlStatements priKeyDef = new DbObjectSqlStatements(tableName);
        DbSqlStatement dropStatement = new DbSqlStatement(true);
        DbFactory factory = this.getDbFactory();
        this.setSchema(factory);
        Connection con = factory.getConnection();
        dropStatement.addLine("ALTER TABLE " + tableName + " DROP PRIMARY KEY ");
        priKeyDef.add(dropStatement);
        if (null == this.index) {
            this.index = ((DbDb2Table)this.getTable()).dbGetPrimaryKeyIndex(con);
            if (this.index != null) {
                this.index.setForPrimaryKey();
            }
        }
        if (this.index != null) {
            priKeyDef.merge(this.index.getDdlStatementsForDrop());
        }
        loc.exiting();
        return priKeyDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDropKey() {
        loc.entering("getDdlStatementsForDropKey");
        String tableName = ((DbDb2Table)this.getTable()).getDbTableName();
        DbObjectSqlStatements priKeyDef = new DbObjectSqlStatements(tableName);
        DbSqlStatement dropStatement = new DbSqlStatement(true);
        DbFactory factory = this.getDbFactory();
        this.setSchema(factory);
        dropStatement.addLine("ALTER TABLE " + DbDb2Environment.quote(tableName) + " DROP PRIMARY KEY ");
        priKeyDef.add(dropStatement);
        loc.exiting();
        return priKeyDef;
    }

    public void setCommonContentViaDb() {
        loc.entering("setCommonContentViaDb()");
        if (this.index != null) {
            this.setContent(this.index.getColumnNames());
        }
        loc.exiting();
    }

    public void setSpecificContentViaRef(DbDb2PrimaryKey other) {
        loc.entering("setSpecificContentViaRef()");
        if (this.index != null && other.getIndex() != null) {
            this.index.setSpecificContentViaRef(other.getIndex());
        }
        this.setDbSpecificIsSet(true);
        loc.exiting();
    }

    public DbDb2Index getIndex() {
        return this.index;
    }

    private String getAuxIndName(String tabname) {
        long stime = new Date().getTime();
        String auxIndName = null;
        int len = Math.min(tabname.length(), DbDb2Parameters.maxIndexNameLen - 4);
        auxIndName = '#' + tabname.substring(0, len);
        auxIndName = auxIndName + DbDb2Environment.getRandomString(3);
        return auxIndName;
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        loc.entering("writeSpecificContentToXmlFile");
        try {
            if (this.index != null) {
                this.index.writeSpecificContentToXmlFile(file, offset0);
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeSpecificContentToXmlFile: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaDb");
        try {
            if (null == this.index) {
                this.index = ((DbDb2Table)this.getTable()).dbGetPrimaryKeyIndex(this.getDbFactory().getConnection());
            }
            this.index.setSpecificContentViaDb();
            loc.exiting();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setCommonContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering("setCommonContentViaXml");
        try {
            super.setCommonContentViaXml(xmlMap);
            if (null == this.index) {
                String indName = this.getAuxIndName(this.getTableName());
                this.index = new DbDb2Index(this.getDbFactory(), this.getTableName(), indName);
                this.index.setContent(true, this.getColumnNames());
                DbIndexes indexes = new DbIndexes(this.getDbFactory());
                this.index.setIndexes(indexes);
                indexes.add(this.index);
                indexes.setTable(this.getTable());
                this.index.setForPrimaryKey();
            }
            loc.exiting();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaXml: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setTable(DbTable dbTable) {
        super.setTable(dbTable);
        if (null != this.index) {
            this.index.getIndexes().setTable(dbTable);
        }
    }

    public void setSpecificContentViaXml(XmlMap xml) throws JddException {
        loc.entering("setSpecificContentViaXml");
        try {
            if (null == this.index) {
                String indName = this.getAuxIndName(this.getTableName());
                this.index = new DbDb2Index(this.getDbFactory(), this.getTableName(), indName);
                this.index.setContent(true, this.getColumnNames());
                DbIndexes indexes = new DbIndexes(this.getDbFactory());
                this.index.setIndexes(indexes);
                indexes.add(this.index);
                indexes.setTable(this.getTable());
                this.index.setForPrimaryKey();
            }
            this.index.setSpecificContentViaXml(xml);
            loc.exiting();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaXml: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public boolean checkColumnsNotNull() {
        loc.entering("checkColumnsNotNull");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getTable().getColumns();
        boolean check = true;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column != null && column.isNotNull()) continue;
            check = false;
            Object[] arguments = new Object[]{this.getTableName(), colName};
            loc.errorT("checkColumnsNotNull (primary key of {0}): column {1} must not be nullable", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth()");
        boolean check = true;
        String tabname = this.getTable().getName();
        int maxKeyWidth = DbDb2Parameters.maxKeyLen;
        if (DbDb2Environment.checkIndexException(tabname, "PKEY")) {
            maxKeyWidth = 2000;
        }
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        DbColumns columns = this.getTable().getColumns();
        int rowLength = 0;
        while (iter.hasNext()) {
            String colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                check = false;
                Object[] arguments = new Object[]{this.getTable().getName(), colName};
                loc.errorT("checkWidth {0}: no such column in table ( {1} ).", arguments);
                continue;
            }
            if (DbDb2Environment.isLob(column)) {
                check = false;
                Object[] arguments = new Object[]{this.getTable().getName(), colName};
                loc.errorT("checkWidth {0}: column of type LOB ({1}) not allowed in primary key.", arguments);
                continue;
            }
            int l = DbDb2Environment.getByteLengthIndex(column);
            if (null != DbDb2Environment.checkUtf8FieldException(tabname, column.getName())) {
                l /= 2;
            }
            rowLength += l;
            if (column.isNotNull()) continue;
            ++rowLength;
        }
        if (rowLength > maxKeyWidth) {
            check = false;
            Object[] arguments = new Object[]{this.getTable().getName(), new Integer(rowLength), new Integer(maxKeyWidth)};
            loc.errorT("checkWidth (primary key of table {0}): total width ({1} bytes) greater than allowed maximum ({2} bytes)", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNumberOfColumns() {
        loc.entering("checkNumberOfColumns()");
        boolean check = true;
        DbColumns columns = this.getTable().getColumns();
        DbColumnIterator iterator = columns.iterator();
        int colCount = 0;
        while (iterator.hasNext()) {
            ++colCount;
            iterator.next();
        }
        if (colCount > DbDb2Parameters.maxKeyColumns) {
            check = false;
            Object[] arguments = new Object[]{this.getTable().getName(), new Integer(colCount), new Integer(DbDb2Parameters.maxKeyColumns)};
            loc.errorT("checkNumberOfColumns (primary key of table {0}): number of columns ({1}) greater than allowed maximum ({2})", arguments);
        }
        loc.exiting();
        return check;
    }
}

