/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2TsAttr;
import java.util.LinkedList;
import java.util.ListIterator;

public class DbDb2PartAttr {
    private DbDb2TsAttr tsAttr;
    private Integer priQty;
    private Integer secQty;
    private Integer pctFree;
    private Integer freePage;
    private Boolean define;
    private String gbpCache;
    private LinkedList keyColValues;
    private ListIterator keyColValueIterator;
    private Boolean trackMod;
    private Boolean compress;

    public void setTsAttr(DbDb2TsAttr tsAttr) {
        this.tsAttr = tsAttr;
    }

    public void setPriQty(Integer priQty) {
        this.priQty = priQty;
    }

    public void setSecQty(Integer secQty) {
        this.secQty = secQty;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public void setFreePage(Integer freePage) {
        this.freePage = freePage;
    }

    public void setDefine(String define) {
        if (define != null) {
            this.define = define.equalsIgnoreCase("YES") ? new Boolean(true) : new Boolean(false);
        }
    }

    public void setGbpCache(String gbpCache) {
        this.gbpCache = gbpCache.toUpperCase();
    }

    public void setKeyColValue(String keyColValue) {
        if (this.keyColValues == null) {
            this.keyColValues = new LinkedList();
        }
        this.keyColValues.add(keyColValue);
    }

    public void setTrackMod(String trackModString) {
        Boolean trackModBoolean = null;
        trackModBoolean = trackModString == null ? new Boolean(false) : (trackModString.equalsIgnoreCase("YES") ? new Boolean(true) : new Boolean(false));
        this.trackMod = trackModBoolean;
    }

    public void setCompress(String compressString) {
        Boolean compressBoolean = null;
        compressBoolean = compressString == null ? new Boolean(false) : (compressString.equalsIgnoreCase("YES") ? new Boolean(true) : new Boolean(false));
        this.compress = compressBoolean;
    }

    public int getPriQty() {
        if (this.priQty == null) {
            if (this.tsAttr != null) {
                return this.tsAttr.getPageSize() * (2 * this.tsAttr.getSegSize() + 2);
            }
            return 40;
        }
        return this.priQty;
    }

    public int getSecQty() {
        if (this.secQty == null) {
            if (this.tsAttr != null) {
                return DbDb2Parameters.getSecQty(DbDb2Parameters.getSizeCategory(this.tsAttr.getTable()));
            }
            return 40;
        }
        return this.secQty;
    }

    public int getPctFree() {
        if (this.pctFree == null) {
            return 16;
        }
        return this.pctFree;
    }

    public int getFreePage() {
        if (this.pctFree == null) {
            return 20;
        }
        return this.freePage;
    }

    public String getDefine() {
        if (this.define == null) {
            return "YES";
        }
        if (this.define.booleanValue()) {
            return "YES";
        }
        return "NO";
    }

    public String getGbpCache() {
        if (this.gbpCache == null) {
            return "CHANGED";
        }
        return this.gbpCache;
    }

    public String getTackmod() {
        if (this.trackMod == null) {
            return "NO";
        }
        if (this.trackMod.booleanValue()) {
            return "YES";
        }
        return "NO";
    }

    public String getCompress() {
        if (this.compress == null) {
            return "YES";
        }
        if (this.compress.booleanValue()) {
            return "YES";
        }
        return "NO";
    }

    public String getKeyColValues() {
        String concatKeyColValues = null;
        ListIterator iterator = this.keyColValues.listIterator();
        while (iterator.hasNext()) {
            concatKeyColValues = concatKeyColValues == null ? (String)iterator.next() : concatKeyColValues + ", " + (String)iterator.next();
        }
        return concatKeyColValues;
    }

    public String getFirstKeyColValue() {
        this.keyColValueIterator = this.keyColValues.listIterator();
        return this.getNextKeyColValue();
    }

    public String getNextKeyColValue() {
        if (this.keyColValueIterator.hasNext()) {
            return (String)this.keyColValueIterator.next();
        }
        return null;
    }
}

