/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.DatabaseMetaData;

public class DbDb2Parameters {
    public static final String DEFAULT_TRACKMOD = "NO";
    public static final String DEFAULT_COMPRESS = "YES";
    public static final String DEFAULT_ERASE = "NO";
    public static final String DEFAULT_MEMBER_CLUSTER = "";
    public static final String DEFAULT_LOG = "YES";
    public static final String DEFAULT_DEFINE = "YES";
    public static final String DEFAULT_CLOSE = "YES";
    public static final String DEFAULT_DEFER = "NO";
    public static final String DEFAULT_CLUSTERING = "NO";
    public static final String DEFAULT_COPY = "YES";
    public static final String DEFAULT_BUFFERPOOL = "BP2";
    public static final String DEFAULT_LOCKRULE = "ROW";
    public static final String DEFAULT_GBPCACHE = "CHANGED";
    public static final String DEFAULT_PIECESIZE = "2097152 K";
    public static final int DEFAULT_PRIQTY = 40;
    public static final int DEFAULT_SECQTY = 40;
    public static final int DEFAULT_PCTFREE = 16;
    public static final int DEFAULT_FREEPAGE = 20;
    public static final int DEFAULT_NUMPARTS = 1;
    public static final int DEFAULT_DSSIZE = 4;
    public static final int DEFAULT_LOCKMAX = 1000000;
    public static final int DEFAULT_PAGESIZE = 4;
    public static final int DEFAULT_SEGSIZE = 64;
    public static final int DEFAULT_MAXROWS = 255;
    public static final double DEFAULT_PAGESIZE_FACTOR = 0.7;
    public static final int DEFAULT_SIZE_CATEGORY = 2;
    public static final String DEFAULT_BP_4K = "BP2";
    public static final String DEFAULT_BP_8K = "BP8K0";
    public static final String DEFAULT_BP_16K = "BP16K0";
    public static final String DEFAULT_BP_32K = "BP32K";
    public static final int PAGESIZE_4K = 4;
    public static final int PAGESIZE_8K = 8;
    public static final int PAGESIZE_16K = 16;
    public static final int PAGESIZE_32K = 32;
    public static final int MAX_SEGSIZE = 64;
    public static int maxLongChar = 16352;
    public static int maxLongRaw = 32696;
    public static int maxBlobLength = 0x40000000;
    public static int maxClobLength = 0x20000000;
    public static int maxDecimalDigits = 31;
    public static int maxColNameLen = 18;
    public static int maxTableColumns = 749;
    public static int maxIndexColumns = 64;
    public static int maxTabNameLen = 18;
    public static int maxTspNameLen = 8;
    public static int maxDbNameLen = 8;
    public static int maxRowLen = 32696;
    public static int maxIndexWidth = 255;
    public static int maxIndexNameLen = 18;
    public static int maxKeyLen = 255;
    public static int maxKeyColumns = 64;
    public static int maxCharLengthV7 = 127;
    public static int longCharLengthV7 = 256;
    public static int BigIntLength = 19;
    public static final String CharsAllowed = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final int UNSET = -1;
    private static final int DB2V7 = 0;
    private static final int DB2V8 = 1;
    private static int dbVersion = -1;
    private static DbDb2Parameters db2Parameter = new DbDb2Parameters();
    private static Location loc = Logger.getLocation("db2.DbDb2Parameters");

    private DbDb2Parameters() {
    }

    public static void setValues(Connection con) {
        loc.entering("setValues");
        try {
            if (dbVersion == -1) {
                if (con != null) {
                    DatabaseMetaData md = NativeSQLAccess.getNativeMetaData((Connection)con);
                    String db_vers = md.getDatabaseProductVersion();
                    if (0 == db_vers.compareTo("DSN07011")) {
                        dbVersion = 0;
                        loc.infoT("setValues: running against DB2/390 V7");
                    } else if (0 == db_vers.compareTo("DSN08015")) {
                        dbVersion = 1;
                        loc.infoT("setValues: running against DB2/390 V8");
                    } else {
                        Object[] arguments = new Object[]{db_vers};
                        loc.errorT("setValues: database version not supported: version string: {0}", arguments);
                        loc.infoT("setValues: using parameters of DB2/390 V8");
                        dbVersion = 1;
                    }
                } else {
                    loc.infoT("setValues: no connection provided: assuming to run against DB2/390 V8");
                    dbVersion = 1;
                }
                switch (dbVersion) {
                    case 0: {
                        maxLongChar = 13000;
                        maxLongRaw = 32696;
                        maxDecimalDigits = 31;
                        maxColNameLen = 18;
                        maxTableColumns = 749;
                        maxIndexColumns = 64;
                        maxTabNameLen = 18;
                        maxTspNameLen = 8;
                        maxDbNameLen = 8;
                        maxRowLen = 32696;
                        maxIndexWidth = 255;
                        maxIndexNameLen = 18;
                        maxKeyLen = 255;
                        maxKeyColumns = 64;
                        break;
                    }
                    case 1: {
                        maxLongChar = 16352;
                        maxLongRaw = 32696;
                        maxDecimalDigits = 31;
                        maxColNameLen = 128;
                        maxTableColumns = 749;
                        maxIndexColumns = 64;
                        maxTabNameLen = 128;
                        maxTspNameLen = 8;
                        maxDbNameLen = 8;
                        maxRowLen = 32696;
                        maxIndexWidth = 2000;
                        maxIndexNameLen = 128;
                        maxKeyLen = 2000;
                        maxKeyColumns = 64;
                        break;
                    }
                }
                DbDb2Environment.setTstSys(con);
                loc.exiting();
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setValues: {0}", arguments);
            loc.exiting();
        }
    }

    public static boolean isV8() {
        return dbVersion == 1;
    }

    public static boolean isV7() {
        return dbVersion == 0;
    }

    public static int getSecQty(int sizeCategory) {
        switch (sizeCategory) {
            case 0: {
                return 40;
            }
            case 1: {
                return 160;
            }
            case 2: {
                return 640;
            }
            case 3: {
                return 2540;
            }
            case 4: {
                return 10240;
            }
            case 5: {
                return 20480;
            }
            case 6: {
                return 40960;
            }
            case 7: {
                return 81920;
            }
            case 8: {
                return 163840;
            }
        }
        return 327680;
    }

    public static int getSizeCategory(DbTable table) {
        int sizeCategory = 2;
        if (table == null) {
            return sizeCategory;
        }
        DbDeploymentInfo deploymentInfo = table.getDeploymentInfo();
        if (deploymentInfo != null && (sizeCategory = deploymentInfo.getSizeCategory()) == 0) {
            sizeCategory = 2;
        }
        return sizeCategory;
    }
}

