/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Column;
import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

public class DbDb2Columns
extends DbColumns {
    private static Location loc = Logger.getLocation("db2.DbDb2Columns");

    public DbDb2Columns() {
    }

    public DbDb2Columns(DbFactory factory) {
        super(factory);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Columns(DbFactory factory, DbColumns other) {
        super(factory, other);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Columns(DbFactory factory, XmlMap xmlMap) throws Exception {
        super(factory, xmlMap);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public void setContentViaDb(DbFactory factory) throws JddException {
        loc.entering("setContentViaDb");
        try {
            String tableName = " ";
            DatabaseMetaData dbmd = null;
            tableName = ((DbDb2Table)this.getTable()).getDbTableName();
            Connection con = factory.getConnection();
            dbmd = NativeSQLAccess.getNativeMetaData((Connection)con);
            String schema = DbDb2Environment.getSchema(con);
            ResultSet rs = dbmd.getColumns(null, schema, tableName, null);
            boolean found = false;
            int rowidCount = 0;
            while (rs.next()) {
                found = true;
                String colName = rs.getString("COLUMN_NAME");
                short sqlType = rs.getShort("DATA_TYPE");
                String dbType = rs.getString("TYPE_NAME");
                int colSize = rs.getInt("COLUMN_SIZE");
                int decDigits = rs.getInt("DECIMAL_DIGITS");
                String defVal = rs.getString("COLUMN_DEF");
                int pos = rs.getInt("ORDINAL_POSITION") - rowidCount;
                boolean isNotNull = rs.getString("IS_NULLABLE").trim().equalsIgnoreCase("NO");
                DbColumn col = factory.makeDbColumn(colName, pos, sqlType, dbType, colSize, decDigits, isNotNull, defVal);
                Integer l = DbDb2Environment.checkFieldException(this.getTable().getName(), colName);
                if (l != null) {
                    ((DbDb2Column)col).setExcLength(l);
                }
                if (!dbType.equalsIgnoreCase("ROWID")) {
                    this.add(col);
                    continue;
                }
                ++rowidCount;
            }
            rs.close();
            if (!found) {
                Object[] arguments = new Object[]{tableName};
                loc.infoT("Table {0} not found on DB.", arguments);
                loc.exiting();
                throw new JddException(ExType.NOT_ON_DB, DbMsgHandler.get(DbsConstants.TABLE_ONDB_NOTFOUND, arguments));
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.toString()};
            loc.infoT("DatabaseMetaData encountered exception {0}.", arguments);
        }
        loc.exiting();
    }

    public boolean checkNumber() {
        loc.entering("checkNumber");
        boolean check = true;
        DbColumnIterator iterator = this.iterator();
        int colCount = 0;
        while (iterator.hasNext()) {
            ++colCount;
            iterator.next();
        }
        if (colCount > DbDb2Parameters.maxTableColumns) {
            check = false;
            Object[] arguments = new Object[]{this.getTable().getName(), new Integer(colCount), new Integer(DbDb2Parameters.maxTableColumns)};
            loc.errorT("checkNumber {0}: number of columns ({1}) greater than allowed maximum ({2})", arguments);
        }
        loc.exiting();
        return check;
    }
}

