/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.catalog;

import com.sap.dictionary.database.catalog.DbCatalogReader;
import com.sap.sql.catalog.CachedCatalogReader;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.jdbc.common.CommonConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;

public class CatalogReaderAccess {
    private static HashSet catalogReaderSet = new HashSet();

    private CatalogReaderAccess() {
    }

    public static CatalogReader getCatalogReader(Connection con) throws SQLException {
        if (con instanceof CommonConnection) {
            return ((CommonConnection)con).getCatalogReader();
        }
        CachedCatalogReader ccr = new CachedCatalogReader((CatalogReader)new DbCatalogReader(con));
        HashSet hashSet = catalogReaderSet;
        synchronized (hashSet) {
            catalogReaderSet.add(ccr);
        }
        return ccr;
    }

    public static void releaseCatalogReader(CatalogReader cr) {
        boolean closeReader = false;
        HashSet hashSet = catalogReaderSet;
        synchronized (hashSet) {
            if (catalogReaderSet.contains(cr)) {
                catalogReaderSet.remove(cr);
                closeReader = true;
            }
        }
        if (closeReader) {
            ((CachedCatalogReader)cr).close();
        }
    }
}

