/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal.engine;

import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.update.ui.forms.internal.engine.IImageSegment;
import org.eclipse.update.ui.forms.internal.engine.Locator;
import org.eclipse.update.ui.forms.internal.engine.ParagraphSegment;

public class ImageSegment
extends ParagraphSegment
implements IImageSegment {
    private int alignment = 3;
    private String imageId;

    public int getVerticalAlignment() {
        return this.alignment;
    }

    void setVerticalAlignment(int alignment) {
        this.alignment = alignment;
    }

    public Image getImage(Hashtable objectTable) {
        if (this.imageId == null) {
            return null;
        }
        Object obj = objectTable.get(this.imageId);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Image) {
            return (Image)obj;
        }
        return null;
    }

    public String getObjectId() {
        return this.imageId;
    }

    void setObjectId(String imageId) {
        this.imageId = imageId;
    }

    public void advanceLocator(GC gc, int wHint, Locator loc, Hashtable objectTable) {
        Image image = this.getImage(objectTable);
        int iwidth = 0;
        int iheight = 0;
        if (image != null) {
            Rectangle rect = image.getBounds();
            iwidth = rect.width;
            iheight = rect.height;
        }
        if (wHint != -1 && loc.x + iwidth > wHint) {
            loc.width = loc.x = loc.indent + iwidth;
            loc.y += loc.rowHeight;
            loc.rowHeight = iheight;
        } else {
            loc.x += iwidth;
            loc.rowHeight = Math.max(loc.rowHeight, iheight);
        }
    }

    public void paint(GC gc, int width, Locator loc, Hashtable objectTable, boolean selected) {
        Image image = this.getImage(objectTable);
        int iwidth = 0;
        int iheight = 0;
        if (image == null) {
            return;
        }
        Rectangle rect = image.getBounds();
        iwidth = rect.width;
        iheight = rect.height;
        loc.width = iwidth;
        loc.height = iheight;
        int ix = loc.x;
        int iy = loc.y;
        if (ix + iwidth > width) {
            ix = loc.indent + loc.marginWidth;
            iy += loc.rowHeight;
            loc.rowHeight = 0;
        }
        gc.drawImage(image, ix, iy);
        loc.x = ix + iwidth;
        loc.y = iy;
        loc.rowHeight = Math.max(loc.rowHeight, iheight);
    }
}

