/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.update.ui.forms.internal.AbstractSectionForm;
import org.eclipse.update.ui.forms.internal.SectionForm;

public class ScrollableSectionForm
extends SectionForm {
    private Composite container;
    private boolean verticalFit;
    private boolean scrollable = true;

    public Control createControl(Composite parent) {
        this.container = this.createParent(parent);
        Control formControl = super.createControl(this.container);
        if (this.container instanceof ScrolledComposite) {
            ScrolledComposite sc = (ScrolledComposite)this.container;
            sc.setContent(formControl);
        }
        GridData gd = new GridData(1808);
        formControl.setLayoutData((Object)gd);
        this.container.setBackground(formControl.getBackground());
        return this.container;
    }

    protected Composite createParent(Composite parent) {
        Composite result = null;
        if (this.isScrollable()) {
            ScrolledComposite scomp = new ScrolledComposite(parent, 768);
            if (this.isVerticalFit()) {
                scomp.setExpandHorizontal(true);
                scomp.setExpandVertical(true);
            }
            this.initializeScrollBars(scomp);
            result = scomp;
        } else {
            result = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            result.setLayout((Layout)layout);
        }
        result.setMenu(parent.getMenu());
        return result;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public boolean isVerticalFit() {
        return this.verticalFit;
    }

    public void setScrollable(boolean newScrollable) {
        this.scrollable = newScrollable;
    }

    public void setVerticalFit(boolean newVerticalFit) {
        this.verticalFit = newVerticalFit;
    }

    private void initializeScrollBars(ScrolledComposite scomp) {
        ScrollBar vbar;
        ScrollBar hbar = scomp.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(5);
        }
        if ((vbar = scomp.getVerticalBar()) != null) {
            vbar.setIncrement(64);
        }
        AbstractSectionForm.updatePageIncrement(scomp);
    }

    public void update() {
        super.update();
        if (this.container instanceof ScrolledComposite) {
            this.updateScrolledComposite();
        } else {
            this.container.layout(true);
        }
    }

    public void updateScrollBars() {
        if (this.container instanceof ScrolledComposite) {
            this.updateScrolledComposite();
        }
    }

    public void updateScrolledComposite() {
        ScrolledComposite sc = (ScrolledComposite)this.container;
        Control formControl = this.getControl();
        Point newSize = formControl.computeSize(-1, -1);
        formControl.setSize(newSize);
        sc.setMinSize(newSize);
        AbstractSectionForm.updatePageIncrement(sc);
    }
}

