/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class FormButton {
    private Button button;
    private Image image;
    private FormWidgetFactory factory;
    private Image hoverImage;
    private boolean inside;
    private Image disabledImage;

    public FormButton(Button button, FormWidgetFactory factory) {
        this.button = button;
        this.factory = factory;
        button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                FormButton.this.inside = true;
                FormButton.this.updateImage();
            }

            public void mouseExit(MouseEvent e) {
                FormButton.this.inside = false;
                FormButton.this.updateImage();
            }
        });
    }

    public Button getButton() {
        return this.button;
    }

    public Image getDisabledImage() {
        return this.disabledImage;
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public Image getImage() {
        return this.image;
    }

    public void setDisabledImage(Image newDisabledImage) {
        this.disabledImage = newDisabledImage;
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.updateImage();
    }

    public void setHoverImage(Image newHoverImage) {
        this.hoverImage = newHoverImage;
    }

    public void setImage(Image newImage) {
        this.image = newImage;
        if (this.hoverImage == null) {
            this.hoverImage = this.image;
        }
        if (this.disabledImage == null) {
            this.disabledImage = this.image;
        }
        this.updateImage();
    }

    public void updateImage() {
        boolean enabled = this.button.isEnabled();
        if (!enabled) {
            this.button.setImage(this.disabledImage);
        } else if (this.inside) {
            this.button.setCursor(this.factory.getHyperlinkCursor());
            this.button.setImage(this.hoverImage);
        } else {
            this.button.setCursor(null);
            this.button.setImage(this.image);
        }
    }
}

