/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.update.ui.forms.internal.AbstractForm;
import org.eclipse.update.ui.forms.internal.FormSection;

public abstract class AbstractSectionForm
extends AbstractForm {
    public static final int H_SCROLL_INCREMENT = 5;
    public static final int V_SCROLL_INCREMENT = 64;
    protected Vector sections = null;

    public void registerSection(FormSection section) {
        if (this.sections == null) {
            this.sections = new Vector();
        }
        if (!this.sections.contains(section)) {
            this.sections.add(section);
        }
    }

    public void unregisterSection(FormSection section) {
        if (this.sections != null && this.sections.contains(section)) {
            this.sections.remove(section);
        }
    }

    public void initialize(Object model) {
        if (this.sections != null) {
            Iterator iter = ((AbstractList)this.sections).iterator();
            while (iter.hasNext()) {
                FormSection section = (FormSection)iter.next();
                section.initialize(model);
            }
        }
    }

    public void setFocus() {
        if (this.sections != null && this.sections.size() > 0) {
            FormSection firstSection = (FormSection)this.sections.firstElement();
            firstSection.setFocus();
        }
    }

    public void update() {
        if (this.sections != null) {
            Iterator iter = ((AbstractList)this.sections).iterator();
            while (iter.hasNext()) {
                FormSection section = (FormSection)iter.next();
                section.update();
            }
        }
    }

    public void commitChanges(boolean onSave) {
        if (this.sections != null) {
            Iterator iter = ((AbstractList)this.sections).iterator();
            while (iter.hasNext()) {
                FormSection section = (FormSection)iter.next();
                if (!section.isDirty()) continue;
                section.commitChanges(onSave);
            }
        }
    }

    public boolean doGlobalAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return false;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return true;
        }
        Composite parent = focusControl.getParent();
        FormSection targetSection = null;
        while (parent != null) {
            Object data = parent.getData();
            if (data != null && data instanceof FormSection) {
                targetSection = (FormSection)data;
                break;
            }
            parent = parent.getParent();
        }
        if (targetSection != null) {
            return targetSection.doGlobalAction(actionId);
        }
        return false;
    }

    protected Control getFocusControl() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    public boolean canPaste(Clipboard clipboard) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return false;
        }
        Composite parent = focusControl.getParent();
        FormSection targetSection = null;
        while (parent != null) {
            Object data = parent.getData();
            if (data != null && data instanceof FormSection) {
                targetSection = (FormSection)data;
                break;
            }
            parent = parent.getParent();
        }
        if (targetSection != null) {
            return targetSection.canPaste(clipboard);
        }
        return false;
    }

    public void dispose() {
        if (this.sections != null) {
            Iterator iter = ((AbstractList)this.sections).iterator();
            while (iter.hasNext()) {
                FormSection section = (FormSection)iter.next();
                section.dispose();
            }
        }
        super.dispose();
    }

    public static void ensureVisible(ScrolledComposite scomp, Control control) {
        Point controlSize = control.getSize();
        Point controlOrigin = AbstractSectionForm.getControlLocation(scomp, control);
        AbstractSectionForm.ensureVisible(scomp, controlOrigin, controlSize);
    }

    public static void ensureVisible(ScrolledComposite scomp, Point controlOrigin, Point controlSize) {
        Rectangle area = scomp.getClientArea();
        Point scompOrigin = scomp.getOrigin();
        int x = scompOrigin.x;
        int y = scompOrigin.y;
        if (controlOrigin.x < scompOrigin.x) {
            x = controlOrigin.x;
        } else if (controlOrigin.x + controlSize.x > scompOrigin.x + area.width) {
            x = controlOrigin.x + controlSize.x - area.width;
        }
        if (controlOrigin.y < scompOrigin.y) {
            y = controlOrigin.y;
        } else if (controlOrigin.y + controlSize.y > scompOrigin.y + area.height) {
            y = controlOrigin.y + controlSize.y - area.height;
        }
        scomp.setOrigin(x, y);
    }

    public static Point getControlLocation(ScrolledComposite scomp, Control control) {
        int x = 0;
        int y = 0;
        for (Control currentControl = control; currentControl != scomp; currentControl = currentControl.getParent()) {
            if (currentControl.getLocation().x > 0) {
                x += currentControl.getLocation().x;
            }
            if (currentControl.getLocation().y <= 0) continue;
            y += currentControl.getLocation().y;
        }
        return new Point(x, y);
    }

    public static void scrollVertical(ScrolledComposite scomp, boolean up) {
        AbstractSectionForm.scroll(scomp, 0, up ? -64 : 64);
    }

    public static void scrollHorizontal(ScrolledComposite scomp, boolean left) {
        AbstractSectionForm.scroll(scomp, left ? -5 : 5, 0);
    }

    public static void scrollPage(ScrolledComposite scomp, boolean up) {
        Rectangle clientArea = scomp.getClientArea();
        int increment = up ? -clientArea.height : clientArea.height;
        AbstractSectionForm.scroll(scomp, 0, increment);
    }

    private static void scroll(ScrolledComposite scomp, int xoffset, int yoffset) {
        Point origin = scomp.getOrigin();
        Point contentSize = scomp.getContent().getSize();
        int xorigin = origin.x + xoffset;
        int yorigin = origin.y + yoffset;
        xorigin = Math.max(xorigin, 0);
        xorigin = Math.min(xorigin, contentSize.x - 1);
        yorigin = Math.max(yorigin, 0);
        yorigin = Math.min(yorigin, contentSize.y - 1);
        scomp.setOrigin(xorigin, yorigin);
    }

    public static void updatePageIncrement(ScrolledComposite scomp) {
        ScrollBar vbar = scomp.getVerticalBar();
        if (vbar != null) {
            Rectangle clientArea = scomp.getClientArea();
            int increment = clientArea.height - 5;
            vbar.setPageIncrement(increment);
        }
    }
}

