/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ViewsetHierarchyNodeState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewsetPropertyState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ViewsetState
extends ViewsetHierarchyNodeState {
    private HashMap mViewsetProperties = new HashMap();
    private Reference mViewsetDefinitionRef = null;

    ViewsetState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        ViewsetState lState = (ViewsetState)((Object)super.clone());
        lState.mViewsetProperties = new HashMap();
        Iterator it = this.mViewsetProperties.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mViewsetProperties.put(lKey, ((ViewsetPropertyState)((Object)this.mViewsetProperties.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mViewsetProperties.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mViewsetProperties.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mViewsetProperties.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mViewsetDefinitionRef != null) {
            if (clipboardService.isExcluded(this.mViewsetDefinitionRef)) {
                this.mViewsetDefinitionRef = null;
            } else if (innerObjectKeys.contains(this.mViewsetDefinitionRef.toReferenceString())) {
                this.mViewsetDefinitionRef = clipboardService.refactor(this.mViewsetDefinitionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mViewsetDefinitionRef != null && this.mViewsetDefinitionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mViewsetDefinitionRef != null) {
            this.mViewsetDefinitionRef = refactoringService.refactor(this.mViewsetDefinitionRef);
        }
    }

    void addViewsetProperty(ViewsetPropertyState state) {
        this.mViewsetProperties.put(state.getName().toLowerCase(), state);
    }

    int getViewsetPropertyCount() {
        return this.mViewsetProperties.size();
    }

    ViewsetPropertyState getViewsetProperty(String name) {
        return (ViewsetPropertyState)((Object)this.mViewsetProperties.get(name.toLowerCase()));
    }

    Vector getViewsetProperties() {
        return new Vector(this.mViewsetProperties.values());
    }

    void removeViewsetProperty(String aggregationKey) {
        this.mViewsetProperties.remove(aggregationKey.toLowerCase());
    }

    void removeViewsetProperty(ViewsetPropertyState state) {
        this.mViewsetProperties.remove(state.getName().toLowerCase());
    }

    void removeAllViewsetProperties() {
        this.mViewsetProperties.clear();
    }

    Reference getViewsetDefinition() {
        return this.mViewsetDefinitionRef;
    }

    void setViewsetDefinition(Reference reference) {
        this.mViewsetDefinitionRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ViewsetProperties")) {
            this.addViewsetProperty((ViewsetPropertyState)((Object)data));
        } else if (roleName.equals("ViewsetDefinition")) {
            this.setViewsetDefinition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

