/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.ArrayList;

class ViewsetPropertyState
extends CommonDevelopmentObjectState {
    private String mValue = null;
    private boolean mHasValue = false;
    private Reference mViewsetPropertyDefinitionRef = null;

    ViewsetPropertyState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewsetPropertyState lState = (ViewsetPropertyState)object;
        return String.valueOf(this.mValue).equals(String.valueOf(lState.mValue));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewsetPropertyState lState = (ViewsetPropertyState)object;
        if (!String.valueOf(this.mValue).equals(String.valueOf(lState.mValue))) {
            compareContext.addPropertyDelta(sourceObject, "value", (Object)lState.mValue);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ViewsetPropertyState lState = (ViewsetPropertyState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mViewsetPropertyDefinitionRef != null) {
            if (clipboardService.isExcluded(this.mViewsetPropertyDefinitionRef)) {
                this.mViewsetPropertyDefinitionRef = null;
            } else if (innerObjectKeys.contains(this.mViewsetPropertyDefinitionRef.toReferenceString())) {
                this.mViewsetPropertyDefinitionRef = clipboardService.refactor(this.mViewsetPropertyDefinitionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mViewsetPropertyDefinitionRef != null && this.mViewsetPropertyDefinitionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mViewsetPropertyDefinitionRef != null) {
            this.mViewsetPropertyDefinitionRef = refactoringService.refactor(this.mViewsetPropertyDefinitionRef);
        }
    }

    void setValue(String value) {
        if (value == null) {
            this.unsetValue();
            return;
        }
        this.mValue = value;
        this.mHasValue = true;
    }

    String getValue() {
        return this.mValue;
    }

    boolean hasValue() {
        return this.mHasValue;
    }

    void unsetValue() {
        this.mValue = null;
        this.mHasValue = false;
    }

    Reference getViewsetPropertyDefinition() {
        return this.mViewsetPropertyDefinitionRef;
    }

    void setViewsetPropertyDefinition(Reference reference) {
        this.mViewsetPropertyDefinitionRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("value")) {
            this.setValue((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ViewsetPropertyDefinition")) {
            this.setViewsetPropertyDefinition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

