/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ViewElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class ViewElementAggregationState
extends CommonDevelopmentObjectState {
    private Vector mAggregatedObjects = new Vector();
    private Reference mDefinitionRef = null;

    ViewElementAggregationState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewElementAggregationState lState = (ViewElementAggregationState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewElementAggregationState lState = (ViewElementAggregationState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        ViewElementAggregationState lState = (ViewElementAggregationState)((Object)super.clone());
        lState.mAggregatedObjects = new Vector();
        int i = 0;
        while (i < this.mAggregatedObjects.size()) {
            lState.mAggregatedObjects.add(((ViewElementState)((Object)this.mAggregatedObjects.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mAggregatedObjects).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mAggregatedObjects).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mAggregatedObjects).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mDefinitionRef != null) {
            if (clipboardService.isExcluded(this.mDefinitionRef)) {
                this.mDefinitionRef = null;
            } else if (innerObjectKeys.contains(this.mDefinitionRef.toReferenceString())) {
                this.mDefinitionRef = clipboardService.refactor(this.mDefinitionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mDefinitionRef != null && this.mDefinitionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mDefinitionRef != null) {
            this.mDefinitionRef = refactoringService.refactor(this.mDefinitionRef);
        }
    }

    void addAggregatedObject(ViewElementState state) {
        this.mAggregatedObjects.add(state);
    }

    void addAggregatedObject(ViewElementState state, int position) {
        this.mAggregatedObjects.add(position, state);
    }

    int getAggregatedObjectCount() {
        return this.mAggregatedObjects.size();
    }

    ViewElementState getAggregatedObject(String name) {
        int i = 0;
        while (i < this.mAggregatedObjects.size()) {
            ViewElementState lState = (ViewElementState)((Object)this.mAggregatedObjects.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getAggregatedObjects() {
        return this.mAggregatedObjects;
    }

    void removeAggregatedObject(ViewElementState state) {
        this.mAggregatedObjects.remove((Object)state);
    }

    void removeAllAggregatedObjects() {
        this.mAggregatedObjects.clear();
    }

    void moveAggregatedObject(int fromPosition, int toPosition) {
        this.mAggregatedObjects.add(toPosition, this.mAggregatedObjects.remove(fromPosition));
    }

    Reference getDefinition() {
        return this.mDefinitionRef;
    }

    void setDefinition(Reference reference) {
        this.mDefinitionRef = reference;
    }

    void reorderAggregatedObjects(Vector orderedStates) {
        this.mAggregatedObjects = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("AggregatedObjects")) {
            this.addAggregatedObject((ViewElementState)((Object)data));
        } else if (roleName.equals("Definition")) {
            this.setDefinition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

