/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.EventBindingState;
import java.util.ArrayList;

class UIElementEventBindingState
extends EventBindingState {
    private Reference mBoundActionRef = null;
    private Reference mUIElementEventRef = null;

    UIElementEventBindingState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        UIElementEventBindingState lState = (UIElementEventBindingState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mBoundActionRef != null) {
            if (clipboardService.isExcluded(this.mBoundActionRef)) {
                this.mBoundActionRef = null;
            } else if (innerObjectKeys.contains(this.mBoundActionRef.toReferenceString())) {
                this.mBoundActionRef = clipboardService.refactor(this.mBoundActionRef);
            }
        }
        if (this.mUIElementEventRef != null) {
            if (clipboardService.isExcluded(this.mUIElementEventRef)) {
                this.mUIElementEventRef = null;
            } else if (innerObjectKeys.contains(this.mUIElementEventRef.toReferenceString())) {
                this.mUIElementEventRef = clipboardService.refactor(this.mUIElementEventRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mBoundActionRef != null && this.mBoundActionRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mUIElementEventRef != null && this.mUIElementEventRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mBoundActionRef != null) {
            this.mBoundActionRef = refactoringService.refactor(this.mBoundActionRef);
        }
        if (this.mUIElementEventRef != null) {
            this.mUIElementEventRef = refactoringService.refactor(this.mUIElementEventRef);
        }
    }

    Reference getBoundAction() {
        return this.mBoundActionRef;
    }

    void setBoundAction(Reference reference) {
        this.mBoundActionRef = reference;
    }

    Reference getUIElementEvent() {
        return this.mUIElementEventRef;
    }

    void setUIElementEvent(Reference reference) {
        this.mUIElementEventRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("BoundAction")) {
            this.setBoundAction((Reference)data);
        } else if (roleName.equals("UIElementEvent")) {
            this.setUIElementEvent((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

