/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.LayoutState;
import com.sap.ide.metamodel.webdynpro.implementation.UIElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class UIElementContainerState
extends UIElementState {
    private String mHeight = null;
    private boolean mHasHeight = false;
    private String mWidth = null;
    private boolean mHasWidth = false;
    private Vector mChildren = new Vector();
    private LayoutState mLayout = null;

    UIElementContainerState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        UIElementContainerState lState = (UIElementContainerState)object;
        if (!String.valueOf(this.mHeight).equals(String.valueOf(lState.mHeight))) {
            return false;
        }
        return String.valueOf(this.mWidth).equals(String.valueOf(lState.mWidth));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        UIElementContainerState lState = (UIElementContainerState)object;
        if (!String.valueOf(this.mHeight).equals(String.valueOf(lState.mHeight))) {
            compareContext.addPropertyDelta(sourceObject, "height", (Object)lState.mHeight);
        }
        if (!String.valueOf(this.mWidth).equals(String.valueOf(lState.mWidth))) {
            compareContext.addPropertyDelta(sourceObject, "width", (Object)lState.mWidth);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UIElementContainerState lState = (UIElementContainerState)((Object)super.clone());
        lState.mChildren = new Vector();
        int i = 0;
        while (i < this.mChildren.size()) {
            lState.mChildren.add(((UIElementState)((Object)this.mChildren.get(i))).clone());
            ++i;
        }
        if (this.mLayout != null) {
            lState.mLayout = (LayoutState)((Object)this.mLayout.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mChildren).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mLayout != null) {
            this.mLayout.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mChildren).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        if (this.mLayout != null) {
            if (clipboardService.isExcluded((Reference)this.mLayout.getProxyReference())) {
                this.mLayout = null;
            } else {
                this.mLayout.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mChildren).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mLayout != null) {
            this.mLayout.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setHeight(String value) {
        if (value == null) {
            this.unsetHeight();
            return;
        }
        this.mHeight = value;
        this.mHasHeight = true;
    }

    String getHeight() {
        return this.mHeight;
    }

    boolean hasHeight() {
        return this.mHasHeight;
    }

    void unsetHeight() {
        this.mHeight = null;
        this.mHasHeight = false;
    }

    void setWidth(String value) {
        if (value == null) {
            this.unsetWidth();
            return;
        }
        this.mWidth = value;
        this.mHasWidth = true;
    }

    String getWidth() {
        return this.mWidth;
    }

    boolean hasWidth() {
        return this.mHasWidth;
    }

    void unsetWidth() {
        this.mWidth = null;
        this.mHasWidth = false;
    }

    void setLayout(LayoutState state) {
        this.mLayout = state;
    }

    LayoutState getLayout() {
        return this.mLayout;
    }

    void addChild(UIElementState state) {
        this.mChildren.add(state);
    }

    void addChild(UIElementState state, int position) {
        this.mChildren.add(position, state);
    }

    int getChildCount() {
        return this.mChildren.size();
    }

    UIElementState getChild(String name) {
        int i = 0;
        while (i < this.mChildren.size()) {
            UIElementState lState = (UIElementState)((Object)this.mChildren.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getChildren() {
        return this.mChildren;
    }

    void removeChild(UIElementState state) {
        this.mChildren.remove((Object)state);
    }

    void removeAllChildren() {
        this.mChildren.clear();
    }

    void moveChild(int fromPosition, int toPosition) {
        this.mChildren.add(toPosition, this.mChildren.remove(fromPosition));
    }

    void reorderChildren(Vector orderedStates) {
        this.mChildren = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("height")) {
            this.setHeight((String)value);
        } else if (propertyName.equals("width")) {
            this.setWidth((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Children")) {
            this.addChild((UIElementState)((Object)data));
        } else if (roleName.equals("Layout")) {
            this.setLayout((LayoutState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

