/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TrayDesign;
import com.sap.ide.metamodel.webdynpro.implementation.CaptionState;
import com.sap.ide.metamodel.webdynpro.implementation.ScrollContainerState;
import com.sap.ide.metamodel.webdynpro.implementation.ToolBarState;
import java.util.ArrayList;

class TrayState
extends ScrollContainerState {
    private String mDesign = "transparent";
    private boolean mHasDesign = false;
    private boolean mExpanded = true;
    private boolean mHasExpanded = false;
    private boolean mHasContentPadding = true;
    private boolean mHasHasContentPadding = false;
    private CaptionState mHeader = null;
    private ToolBarState mToolBar = null;

    TrayState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        TrayState lState = (TrayState)object;
        if (!String.valueOf(this.mDesign).equals(String.valueOf(lState.mDesign))) {
            return false;
        }
        if (!String.valueOf(this.mExpanded).equals(String.valueOf(lState.mExpanded))) {
            return false;
        }
        return String.valueOf(this.mHasContentPadding).equals(String.valueOf(lState.mHasContentPadding));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        TrayState lState = (TrayState)object;
        if (!String.valueOf(this.mDesign).equals(String.valueOf(lState.mDesign))) {
            compareContext.addPropertyDelta(sourceObject, "design", (Object)TrayDesign.valueOf(lState.mDesign));
        }
        if (!String.valueOf(this.mExpanded).equals(String.valueOf(lState.mExpanded))) {
            compareContext.addPropertyDelta(sourceObject, "expanded", (Object)new Boolean(lState.mExpanded));
        }
        if (!String.valueOf(this.mHasContentPadding).equals(String.valueOf(lState.mHasContentPadding))) {
            compareContext.addPropertyDelta(sourceObject, "hasContentPadding", (Object)new Boolean(lState.mHasContentPadding));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TrayState lState = (TrayState)((Object)super.clone());
        if (this.mHeader != null) {
            lState.mHeader = (CaptionState)((Object)this.mHeader.clone());
        }
        if (this.mToolBar != null) {
            lState.mToolBar = (ToolBarState)((Object)this.mToolBar.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mHeader != null) {
            this.mHeader.removeExternalReferences(innerObjectKeys);
        }
        if (this.mToolBar != null) {
            this.mToolBar.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mHeader != null) {
            if (clipboardService.isExcluded((Reference)this.mHeader.getProxyReference())) {
                this.mHeader = null;
            } else {
                this.mHeader.refactor(clipboardService);
            }
        }
        if (this.mToolBar != null) {
            if (clipboardService.isExcluded((Reference)this.mToolBar.getProxyReference())) {
                this.mToolBar = null;
            } else {
                this.mToolBar.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mHeader != null) {
            this.mHeader.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mToolBar != null) {
            this.mToolBar.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setDesign(String value) {
        this.mDesign = value;
        this.mHasDesign = true;
    }

    String getDesign() {
        return this.mDesign;
    }

    boolean hasDesign() {
        return this.mHasDesign;
    }

    void setExpanded(boolean value) {
        this.mExpanded = value;
        this.mHasExpanded = true;
    }

    boolean getExpanded() {
        return this.mExpanded;
    }

    boolean hasExpanded() {
        return this.mHasExpanded;
    }

    void setHasContentPadding(boolean value) {
        this.mHasContentPadding = value;
        this.mHasHasContentPadding = true;
    }

    boolean getHasContentPadding() {
        return this.mHasContentPadding;
    }

    boolean hasHasContentPadding() {
        return this.mHasHasContentPadding;
    }

    void setHeader(CaptionState state) {
        this.mHeader = state;
    }

    CaptionState getHeader() {
        return this.mHeader;
    }

    void setToolBar(ToolBarState state) {
        this.mToolBar = state;
    }

    ToolBarState getToolBar() {
        return this.mToolBar;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("design")) {
            if (TrayDesign.valueOf((String)value) != null) {
                this.setDesign((String)value);
            }
        } else if (propertyName.equals("expanded")) {
            this.setExpanded(new Boolean((String)value));
        } else if (propertyName.equals("hasContentPadding")) {
            this.setHasContentPadding(new Boolean((String)value));
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Header")) {
            this.setHeader((CaptionState)((Object)data));
        } else if (roleName.equals("ToolBar")) {
            this.setToolBar((ToolBarState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

