/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TableDesign;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TableSelectionMode;
import com.sap.ide.metamodel.webdynpro.implementation.CaptionState;
import com.sap.ide.metamodel.webdynpro.implementation.TableColumnState;
import com.sap.ide.metamodel.webdynpro.implementation.ToolBarState;
import com.sap.ide.metamodel.webdynpro.implementation.UIElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class TableState
extends UIElementState {
    private String mDesign = "standard";
    private boolean mHasDesign = false;
    private int mFirstVisibleRow = 0;
    private boolean mHasFirstVisibleRow = false;
    private boolean mFooterVisible = true;
    private boolean mHasFooterVisible = false;
    private boolean mReadOnly = false;
    private boolean mHasReadOnly = false;
    private String mSelectionMode = "auto";
    private boolean mHasSelectionMode = false;
    private int mVisibleRowCount = 5;
    private boolean mHasVisibleRowCount = false;
    private String mWidth = null;
    private boolean mHasWidth = false;
    private Vector mColumns = new Vector();
    private CaptionState mHeader = null;
    private ToolBarState mToolBar = null;

    TableState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        TableState lState = (TableState)object;
        if (!String.valueOf(this.mDesign).equals(String.valueOf(lState.mDesign))) {
            return false;
        }
        if (!String.valueOf(this.mFirstVisibleRow).equals(String.valueOf(lState.mFirstVisibleRow))) {
            return false;
        }
        if (!String.valueOf(this.mFooterVisible).equals(String.valueOf(lState.mFooterVisible))) {
            return false;
        }
        if (!String.valueOf(this.mReadOnly).equals(String.valueOf(lState.mReadOnly))) {
            return false;
        }
        if (!String.valueOf(this.mSelectionMode).equals(String.valueOf(lState.mSelectionMode))) {
            return false;
        }
        if (!String.valueOf(this.mVisibleRowCount).equals(String.valueOf(lState.mVisibleRowCount))) {
            return false;
        }
        return String.valueOf(this.mWidth).equals(String.valueOf(lState.mWidth));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        TableState lState = (TableState)object;
        if (!String.valueOf(this.mDesign).equals(String.valueOf(lState.mDesign))) {
            compareContext.addPropertyDelta(sourceObject, "design", (Object)TableDesign.valueOf(lState.mDesign));
        }
        if (!String.valueOf(this.mFirstVisibleRow).equals(String.valueOf(lState.mFirstVisibleRow))) {
            compareContext.addPropertyDelta(sourceObject, "firstVisibleRow", (Object)new Integer(lState.mFirstVisibleRow));
        }
        if (!String.valueOf(this.mFooterVisible).equals(String.valueOf(lState.mFooterVisible))) {
            compareContext.addPropertyDelta(sourceObject, "footerVisible", (Object)new Boolean(lState.mFooterVisible));
        }
        if (!String.valueOf(this.mReadOnly).equals(String.valueOf(lState.mReadOnly))) {
            compareContext.addPropertyDelta(sourceObject, "readOnly", (Object)new Boolean(lState.mReadOnly));
        }
        if (!String.valueOf(this.mSelectionMode).equals(String.valueOf(lState.mSelectionMode))) {
            compareContext.addPropertyDelta(sourceObject, "selectionMode", (Object)TableSelectionMode.valueOf(lState.mSelectionMode));
        }
        if (!String.valueOf(this.mVisibleRowCount).equals(String.valueOf(lState.mVisibleRowCount))) {
            compareContext.addPropertyDelta(sourceObject, "visibleRowCount", (Object)new Integer(lState.mVisibleRowCount));
        }
        if (!String.valueOf(this.mWidth).equals(String.valueOf(lState.mWidth))) {
            compareContext.addPropertyDelta(sourceObject, "width", (Object)lState.mWidth);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TableState lState = (TableState)((Object)super.clone());
        lState.mColumns = new Vector();
        int i = 0;
        while (i < this.mColumns.size()) {
            lState.mColumns.add(((TableColumnState)((Object)this.mColumns.get(i))).clone());
            ++i;
        }
        if (this.mHeader != null) {
            lState.mHeader = (CaptionState)((Object)this.mHeader.clone());
        }
        if (this.mToolBar != null) {
            lState.mToolBar = (ToolBarState)((Object)this.mToolBar.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mColumns).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mHeader != null) {
            this.mHeader.removeExternalReferences(innerObjectKeys);
        }
        if (this.mToolBar != null) {
            this.mToolBar.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mColumns).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        if (this.mHeader != null) {
            if (clipboardService.isExcluded((Reference)this.mHeader.getProxyReference())) {
                this.mHeader = null;
            } else {
                this.mHeader.refactor(clipboardService);
            }
        }
        if (this.mToolBar != null) {
            if (clipboardService.isExcluded((Reference)this.mToolBar.getProxyReference())) {
                this.mToolBar = null;
            } else {
                this.mToolBar.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mColumns).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mHeader != null) {
            this.mHeader.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mToolBar != null) {
            this.mToolBar.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setDesign(String value) {
        this.mDesign = value;
        this.mHasDesign = true;
    }

    String getDesign() {
        return this.mDesign;
    }

    boolean hasDesign() {
        return this.mHasDesign;
    }

    void setFirstVisibleRow(int value) {
        this.mFirstVisibleRow = value;
        this.mHasFirstVisibleRow = true;
    }

    int getFirstVisibleRow() {
        return this.mFirstVisibleRow;
    }

    boolean hasFirstVisibleRow() {
        return this.mHasFirstVisibleRow;
    }

    void setFooterVisible(boolean value) {
        this.mFooterVisible = value;
        this.mHasFooterVisible = true;
    }

    boolean getFooterVisible() {
        return this.mFooterVisible;
    }

    boolean hasFooterVisible() {
        return this.mHasFooterVisible;
    }

    void setReadOnly(boolean value) {
        this.mReadOnly = value;
        this.mHasReadOnly = true;
    }

    boolean getReadOnly() {
        return this.mReadOnly;
    }

    boolean hasReadOnly() {
        return this.mHasReadOnly;
    }

    void setSelectionMode(String value) {
        this.mSelectionMode = value;
        this.mHasSelectionMode = true;
    }

    String getSelectionMode() {
        return this.mSelectionMode;
    }

    boolean hasSelectionMode() {
        return this.mHasSelectionMode;
    }

    void setVisibleRowCount(int value) {
        this.mVisibleRowCount = value;
        this.mHasVisibleRowCount = true;
    }

    int getVisibleRowCount() {
        return this.mVisibleRowCount;
    }

    boolean hasVisibleRowCount() {
        return this.mHasVisibleRowCount;
    }

    void setWidth(String value) {
        if (value == null) {
            this.unsetWidth();
            return;
        }
        this.mWidth = value;
        this.mHasWidth = true;
    }

    String getWidth() {
        return this.mWidth;
    }

    boolean hasWidth() {
        return this.mHasWidth;
    }

    void unsetWidth() {
        this.mWidth = null;
        this.mHasWidth = false;
    }

    void setHeader(CaptionState state) {
        this.mHeader = state;
    }

    CaptionState getHeader() {
        return this.mHeader;
    }

    void setToolBar(ToolBarState state) {
        this.mToolBar = state;
    }

    ToolBarState getToolBar() {
        return this.mToolBar;
    }

    void addColumn(TableColumnState state) {
        this.mColumns.add(state);
    }

    void addColumn(TableColumnState state, int position) {
        this.mColumns.add(position, state);
    }

    int getColumnCount() {
        return this.mColumns.size();
    }

    TableColumnState getColumn(String name) {
        int i = 0;
        while (i < this.mColumns.size()) {
            TableColumnState lState = (TableColumnState)((Object)this.mColumns.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getColumns() {
        return this.mColumns;
    }

    void removeColumn(TableColumnState state) {
        this.mColumns.remove((Object)state);
    }

    void removeAllColumns() {
        this.mColumns.clear();
    }

    void moveColumn(int fromPosition, int toPosition) {
        this.mColumns.add(toPosition, this.mColumns.remove(fromPosition));
    }

    void reorderColumns(Vector orderedStates) {
        this.mColumns = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("design")) {
            if (TableDesign.valueOf((String)value) != null) {
                this.setDesign((String)value);
            }
        } else if (propertyName.equals("firstVisibleRow")) {
            this.setFirstVisibleRow(new Integer((String)value));
        } else if (propertyName.equals("footerVisible")) {
            this.setFooterVisible(new Boolean((String)value));
        } else if (propertyName.equals("readOnly")) {
            this.setReadOnly(new Boolean((String)value));
        } else if (propertyName.equals("selectionMode")) {
            if (TableSelectionMode.valueOf((String)value) != null) {
                this.setSelectionMode((String)value);
            }
        } else if (propertyName.equals("visibleRowCount")) {
            this.setVisibleRowCount(new Integer((String)value));
        } else if (propertyName.equals("width")) {
            this.setWidth((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Columns")) {
            this.addColumn((TableColumnState)((Object)data));
        } else if (roleName.equals("Header")) {
            this.setHeader((CaptionState)((Object)data));
        } else if (roleName.equals("ToolBar")) {
            this.setToolBar((ToolBarState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

