/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ViewsetPropertyDefinitionState;
import java.util.ArrayList;

class SimplePropertyDefinitionState
extends ViewsetPropertyDefinitionState {
    private boolean mIsTranslatable = false;
    private boolean mHasIsTranslatable = false;
    private Reference mDimensionXRef = null;
    private Reference mDimensionYRef = null;
    private Reference mDimensionZRef = null;

    SimplePropertyDefinitionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        SimplePropertyDefinitionState lState = (SimplePropertyDefinitionState)object;
        return String.valueOf(this.mIsTranslatable).equals(String.valueOf(lState.mIsTranslatable));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        SimplePropertyDefinitionState lState = (SimplePropertyDefinitionState)object;
        if (!String.valueOf(this.mIsTranslatable).equals(String.valueOf(lState.mIsTranslatable))) {
            compareContext.addPropertyDelta(sourceObject, "isTranslatable", (Object)new Boolean(lState.mIsTranslatable));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SimplePropertyDefinitionState lState = (SimplePropertyDefinitionState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mDimensionXRef != null) {
            if (clipboardService.isExcluded(this.mDimensionXRef)) {
                this.mDimensionXRef = null;
            } else if (innerObjectKeys.contains(this.mDimensionXRef.toReferenceString())) {
                this.mDimensionXRef = clipboardService.refactor(this.mDimensionXRef);
            }
        }
        if (this.mDimensionYRef != null) {
            if (clipboardService.isExcluded(this.mDimensionYRef)) {
                this.mDimensionYRef = null;
            } else if (innerObjectKeys.contains(this.mDimensionYRef.toReferenceString())) {
                this.mDimensionYRef = clipboardService.refactor(this.mDimensionYRef);
            }
        }
        if (this.mDimensionZRef != null) {
            if (clipboardService.isExcluded(this.mDimensionZRef)) {
                this.mDimensionZRef = null;
            } else if (innerObjectKeys.contains(this.mDimensionZRef.toReferenceString())) {
                this.mDimensionZRef = clipboardService.refactor(this.mDimensionZRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mDimensionXRef != null && this.mDimensionXRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        if (this.mDimensionYRef != null && this.mDimensionYRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mDimensionZRef != null && this.mDimensionZRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mDimensionXRef != null) {
            this.mDimensionXRef = refactoringService.refactor(this.mDimensionXRef);
        }
        if (this.mDimensionYRef != null) {
            this.mDimensionYRef = refactoringService.refactor(this.mDimensionYRef);
        }
        if (this.mDimensionZRef != null) {
            this.mDimensionZRef = refactoringService.refactor(this.mDimensionZRef);
        }
    }

    void setIsTranslatable(boolean value) {
        this.mIsTranslatable = value;
        this.mHasIsTranslatable = true;
    }

    boolean getIsTranslatable() {
        return this.mIsTranslatable;
    }

    boolean hasIsTranslatable() {
        return this.mHasIsTranslatable;
    }

    Reference getDimensionX() {
        return this.mDimensionXRef;
    }

    void setDimensionX(Reference reference) {
        this.mDimensionXRef = reference;
    }

    Reference getDimensionY() {
        return this.mDimensionYRef;
    }

    void setDimensionY(Reference reference) {
        this.mDimensionYRef = reference;
    }

    Reference getDimensionZ() {
        return this.mDimensionZRef;
    }

    void setDimensionZ(Reference reference) {
        this.mDimensionZRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("isTranslatable")) {
            this.setIsTranslatable(new Boolean((String)value));
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("DimensionX")) {
            this.setDimensionX((Reference)data);
        } else if (roleName.equals("DimensionY")) {
            this.setDimensionY((Reference)data);
        } else if (roleName.equals("DimensionZ")) {
            this.setDimensionZ((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

