/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.implementation.NativeTypeState;
import com.sap.ide.metamodel.webdynpro.implementation.ParameterizedFeatureState;
import java.util.ArrayList;

abstract class ProcedureState
extends ParameterizedFeatureState {
    private String mCodeBody = null;
    private boolean mHasCodeBody = false;
    private String mVisibility = "public";
    private boolean mHasVisibility = false;
    private NativeTypeState mNativeType = null;
    private Reference mReturnTypeRef = null;

    ProcedureState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ProcedureState lState = (ProcedureState)object;
        if (!String.valueOf(this.mCodeBody).equals(String.valueOf(lState.mCodeBody))) {
            return false;
        }
        return String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ProcedureState lState = (ProcedureState)object;
        if (!String.valueOf(this.mCodeBody).equals(String.valueOf(lState.mCodeBody))) {
            compareContext.addPropertyDelta(sourceObject, "codeBody", (Object)lState.mCodeBody);
        }
        if (!String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility))) {
            compareContext.addPropertyDelta(sourceObject, "visibility", (Object)VisibilityEnum.valueOf(lState.mVisibility));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ProcedureState lState = (ProcedureState)((Object)super.clone());
        if (this.mNativeType != null) {
            lState.mNativeType = (NativeTypeState)((Object)this.mNativeType.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mNativeType != null) {
            this.mNativeType.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mNativeType != null) {
            if (clipboardService.isExcluded((Reference)this.mNativeType.getProxyReference())) {
                this.mNativeType = null;
            } else {
                this.mNativeType.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mNativeType != null) {
            this.mNativeType.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mReturnTypeRef != null) {
            if (clipboardService.isExcluded(this.mReturnTypeRef)) {
                this.mReturnTypeRef = null;
            } else if (innerObjectKeys.contains(this.mReturnTypeRef.toReferenceString())) {
                this.mReturnTypeRef = clipboardService.refactor(this.mReturnTypeRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mReturnTypeRef != null && this.mReturnTypeRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mReturnTypeRef != null) {
            this.mReturnTypeRef = refactoringService.refactor(this.mReturnTypeRef);
        }
    }

    void setCodeBody(String value) {
        if (value == null) {
            this.unsetCodeBody();
            return;
        }
        this.mCodeBody = value;
        this.mHasCodeBody = true;
    }

    String getCodeBody() {
        return this.mCodeBody;
    }

    boolean hasCodeBody() {
        return this.mHasCodeBody;
    }

    void unsetCodeBody() {
        this.mCodeBody = null;
        this.mHasCodeBody = false;
    }

    void setVisibility(String value) {
        this.mVisibility = value;
        this.mHasVisibility = true;
    }

    String getVisibility() {
        return this.mVisibility;
    }

    boolean hasVisibility() {
        return this.mHasVisibility;
    }

    void setNativeType(NativeTypeState state) {
        this.mNativeType = state;
    }

    NativeTypeState getNativeType() {
        return this.mNativeType;
    }

    Reference getReturnType() {
        return this.mReturnTypeRef;
    }

    void setReturnType(Reference reference) {
        this.mReturnTypeRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("visibility")) {
            if (VisibilityEnum.valueOf((String)value) != null) {
                this.setVisibility((String)value);
            }
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("NativeType")) {
            this.setNativeType((NativeTypeState)((Object)data));
        } else if (roleName.equals("ReturnType")) {
            this.setReturnType((Reference)data);
        } else if (roleName.equals("CodeBody")) {
            this.setCodeBody((String)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

