/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.NavigationLinkState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class NavigationLinksState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Reference mParent;
    private HashMap mNavigationLinks = new HashMap();

    NavigationLinksState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        NavigationLinksState lState = (NavigationLinksState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        NavigationLinksState lState = (NavigationLinksState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NavigationLinksState lState = (NavigationLinksState)((Object)super.clone());
        lState.mNavigationLinks = new HashMap();
        Iterator it = this.mNavigationLinks.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mNavigationLinks.put(lKey, ((NavigationLinkState)((Object)this.mNavigationLinks.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mNavigationLinks.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mNavigationLinks.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mNavigationLinks.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mParent != null) {
            this.mParent = clipboardService.refactor(this.mParent);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mParent != null) {
            this.mParent = refactoringService.refactor(this.mParent);
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return this.mParent;
    }

    public void setParent(Reference parentReference) {
        this.mParent = parentReference;
    }

    void addNavigationsLink(NavigationLinkState state) {
        this.mNavigationLinks.put(state.getName().toLowerCase(), state);
    }

    int getNavigationsLinkCount() {
        return this.mNavigationLinks.size();
    }

    NavigationLinkState getNavigationsLink(String name) {
        return (NavigationLinkState)((Object)this.mNavigationLinks.get(name.toLowerCase()));
    }

    Vector getNavigationLinks() {
        return new Vector(this.mNavigationLinks.values());
    }

    void removeNavigationsLink(String aggregationKey) {
        this.mNavigationLinks.remove(aggregationKey.toLowerCase());
    }

    void removeNavigationsLink(NavigationLinkState state) {
        this.mNavigationLinks.remove(state.getName().toLowerCase());
    }

    void removeAllNavigationLinks() {
        this.mNavigationLinks.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Parent")) {
            this.setParent((Reference)data);
        } else if (roleName.equals("NavigationLinks")) {
            this.addNavigationsLink((NavigationLinkState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

