/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ModelRelationState;
import com.sap.ide.metamodel.webdynpro.implementation.ModelSettingState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ModelState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private HashMap mModelClassRefs = new HashMap();
    private HashMap mModelRelations = new HashMap();
    private HashMap mSettings = new HashMap();
    private Reference mLogicalDictionaryRef = null;
    private Reference mModelTypeRef = null;
    private HashMap mUsedModelRefs = new HashMap();

    ModelState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ModelState lState = (ModelState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ModelState lState = (ModelState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ModelState lState = (ModelState)((Object)super.clone());
        lState.mModelClassRefs = (HashMap)this.mModelClassRefs.clone();
        lState.mModelRelations = new HashMap();
        Iterator it = this.mModelRelations.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mModelRelations.put(lKey, ((ModelRelationState)((Object)this.mModelRelations.get(lKey))).clone());
        }
        lState.mSettings = new HashMap();
        Iterator it2 = this.mSettings.keySet().iterator();
        while (it2.hasNext()) {
            String lKey = (String)it2.next();
            lState.mSettings.put(lKey, ((ModelSettingState)((Object)this.mSettings.get(lKey))).clone());
        }
        lState.mUsedModelRefs = (HashMap)this.mUsedModelRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mModelRelations.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mSettings.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mModelClassRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it.remove();
        }
        Iterator it2 = this.mModelRelations.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = this.mSettings.values().iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mModelClassRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = clipboardService.refactor((Reference)it.next());
            lHashMap.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mModelClassRefs = lHashMap;
        Iterator it2 = this.mModelRelations.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        it = this.mSettings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mLogicalDictionaryRef != null) {
            if (clipboardService.isExcluded(this.mLogicalDictionaryRef)) {
                this.mLogicalDictionaryRef = null;
            } else if (innerObjectKeys.contains(this.mLogicalDictionaryRef.toReferenceString())) {
                this.mLogicalDictionaryRef = clipboardService.refactor(this.mLogicalDictionaryRef);
            }
        }
        if (this.mModelTypeRef != null) {
            if (clipboardService.isExcluded(this.mModelTypeRef)) {
                this.mModelTypeRef = null;
            } else if (innerObjectKeys.contains(this.mModelTypeRef.toReferenceString())) {
                this.mModelTypeRef = clipboardService.refactor(this.mModelTypeRef);
            }
        }
        HashMap<String, Reference> lHashMap2 = new HashMap<String, Reference>();
        Iterator it3 = this.mUsedModelRefs.values().iterator();
        while (it3.hasNext()) {
            Reference lReference = (Reference)it3.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lHashMap2.put(lReference.toString(), lReference);
        }
        this.mUsedModelRefs = lHashMap2;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = this.mModelClassRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        if (this.mLogicalDictionaryRef != null && this.mLogicalDictionaryRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        if (this.mModelTypeRef != null && this.mModelTypeRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        Iterator it2 = this.mUsedModelRefs.values().iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mLogicalDictionaryRef != null) {
            this.mLogicalDictionaryRef = refactoringService.refactor(this.mLogicalDictionaryRef);
        }
        if (this.mModelTypeRef != null) {
            this.mModelTypeRef = refactoringService.refactor(this.mModelTypeRef);
        }
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mUsedModelRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = refactoringService.refactor((Reference)it.next());
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mUsedModelRefs = lHashMap;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void addModelClass(Reference reference) {
        this.mModelClassRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getModelClassCount() {
        return this.mModelClassRefs.size();
    }

    Reference getModelClass(String _package, String name) {
        return (Reference)this.mModelClassRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getModelClasses() {
        return new Vector(this.mModelClassRefs.values());
    }

    void removeModelClass(Reference reference) {
        this.mModelClassRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeModelClass(String aggregationKey) {
        this.mModelClassRefs.remove(aggregationKey);
    }

    void removeModelClass(String _package, String name) {
        this.mModelClassRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllModelClasses() {
        this.mModelClassRefs.clear();
    }

    void addModelRelation(ModelRelationState state) {
        this.mModelRelations.put(state.getName().toLowerCase(), state);
    }

    int getModelRelationCount() {
        return this.mModelRelations.size();
    }

    ModelRelationState getModelRelation(String name) {
        return (ModelRelationState)((Object)this.mModelRelations.get(name.toLowerCase()));
    }

    Vector getModelRelations() {
        return new Vector(this.mModelRelations.values());
    }

    void removeModelRelation(String aggregationKey) {
        this.mModelRelations.remove(aggregationKey.toLowerCase());
    }

    void removeModelRelation(ModelRelationState state) {
        this.mModelRelations.remove(state.getName().toLowerCase());
    }

    void removeAllModelRelations() {
        this.mModelRelations.clear();
    }

    void addSetting(ModelSettingState state) {
        this.mSettings.put(state.getName().toLowerCase(), state);
    }

    int getSettingCount() {
        return this.mSettings.size();
    }

    ModelSettingState getSetting(String name) {
        return (ModelSettingState)((Object)this.mSettings.get(name.toLowerCase()));
    }

    Vector getSettings() {
        return new Vector(this.mSettings.values());
    }

    void removeSetting(String aggregationKey) {
        this.mSettings.remove(aggregationKey.toLowerCase());
    }

    void removeSetting(ModelSettingState state) {
        this.mSettings.remove(state.getName().toLowerCase());
    }

    void removeAllSettings() {
        this.mSettings.clear();
    }

    Reference getLogicalDictionary() {
        return this.mLogicalDictionaryRef;
    }

    void setLogicalDictionary(Reference reference) {
        this.mLogicalDictionaryRef = reference;
    }

    Reference getModelType() {
        return this.mModelTypeRef;
    }

    void setModelType(Reference reference) {
        this.mModelTypeRef = reference;
    }

    void addUsedModel(Reference reference) {
        this.mUsedModelRefs.put(reference.toString(), reference);
    }

    int getUsedModelCount() {
        return this.mUsedModelRefs.size();
    }

    Reference getUsedModel(Reference reference) {
        return (Reference)this.mUsedModelRefs.get(reference.toString());
    }

    Vector getUsedModels() {
        return new Vector(this.mUsedModelRefs.values());
    }

    void removeUsedModel(Reference reference) {
        this.mUsedModelRefs.remove(reference.toString());
    }

    void removeAllUsedModels() {
        this.mUsedModelRefs.clear();
    }

    void replaceUsedModel(Reference oldReference, Reference newReference) {
        this.mUsedModelRefs.remove(oldReference.toString());
        this.mUsedModelRefs.put(newReference.toString(), newReference);
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ModelClasses")) {
            this.addModelClass((Reference)data);
        } else if (roleName.equals("ModelRelations")) {
            this.addModelRelation((ModelRelationState)((Object)data));
        } else if (roleName.equals("Settings")) {
            this.addSetting((ModelSettingState)((Object)data));
        } else if (roleName.equals("LogicalDictionary")) {
            this.setLogicalDictionary((Reference)data);
        } else if (roleName.equals("ModelType")) {
            this.setModelType((Reference)data);
        } else if (roleName.equals("UsedModels")) {
            this.addUsedModel((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

