/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.LayoutDataDefinitionState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewElementDefinitionState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class LayoutDefinitionState
extends ViewElementDefinitionState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Reference mParent;
    private Vector mLayoutDataDefinitions = new Vector();
    private Reference mDefaultDataDefinitionRef = null;

    LayoutDefinitionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        LayoutDefinitionState lState = (LayoutDefinitionState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        LayoutDefinitionState lState = (LayoutDefinitionState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LayoutDefinitionState lState = (LayoutDefinitionState)((Object)super.clone());
        lState.mLayoutDataDefinitions = new Vector();
        int i = 0;
        while (i < this.mLayoutDataDefinitions.size()) {
            lState.mLayoutDataDefinitions.add(((LayoutDataDefinitionState)((Object)this.mLayoutDataDefinitions.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mDefaultDataDefinitionRef != null && !innerObjectKeys.contains(this.mDefaultDataDefinitionRef.toString())) {
            this.mDefaultDataDefinitionRef = null;
        }
        Iterator it = ((AbstractList)this.mLayoutDataDefinitions).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mLayoutDataDefinitions).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mLayoutDataDefinitions).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mParent != null) {
            this.mParent = clipboardService.refactor(this.mParent);
        }
        if (this.mDefaultDataDefinitionRef != null) {
            if (clipboardService.isExcluded(this.mDefaultDataDefinitionRef)) {
                this.mDefaultDataDefinitionRef = null;
            } else if (innerObjectKeys.contains(this.mDefaultDataDefinitionRef.toReferenceString())) {
                this.mDefaultDataDefinitionRef = clipboardService.refactor(this.mDefaultDataDefinitionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mDefaultDataDefinitionRef != null && this.mDefaultDataDefinitionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mParent != null) {
            this.mParent = refactoringService.refactor(this.mParent);
        }
        if (this.mDefaultDataDefinitionRef != null) {
            this.mDefaultDataDefinitionRef = refactoringService.refactor(this.mDefaultDataDefinitionRef);
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return this.mParent;
    }

    public void setParent(Reference parentReference) {
        this.mParent = parentReference;
    }

    void addLayoutDataDefinition(LayoutDataDefinitionState state) {
        this.mLayoutDataDefinitions.add(state);
    }

    void addLayoutDataDefinition(LayoutDataDefinitionState state, int position) {
        this.mLayoutDataDefinitions.add(position, state);
    }

    int getLayoutDataDefinitionCount() {
        return this.mLayoutDataDefinitions.size();
    }

    LayoutDataDefinitionState getLayoutDataDefinition(String name) {
        int i = 0;
        while (i < this.mLayoutDataDefinitions.size()) {
            LayoutDataDefinitionState lState = (LayoutDataDefinitionState)((Object)this.mLayoutDataDefinitions.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getLayoutDataDefinitions() {
        return this.mLayoutDataDefinitions;
    }

    void removeLayoutDataDefinition(LayoutDataDefinitionState state) {
        this.mLayoutDataDefinitions.remove((Object)state);
    }

    void removeAllLayoutDataDefinitions() {
        this.mLayoutDataDefinitions.clear();
    }

    void moveLayoutDataDefinition(int fromPosition, int toPosition) {
        this.mLayoutDataDefinitions.add(toPosition, this.mLayoutDataDefinitions.remove(fromPosition));
    }

    Reference getDefaultDataDefinition() {
        return this.mDefaultDataDefinitionRef;
    }

    void setDefaultDataDefinition(Reference reference) {
        this.mDefaultDataDefinitionRef = reference;
    }

    void reorderLayoutDataDefinitions(Vector orderedStates) {
        this.mLayoutDataDefinitions = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Parent")) {
            this.setParent((Reference)data);
        } else if (roleName.equals("LayoutDataDefinitions")) {
            this.addLayoutDataDefinition((LayoutDataDefinitionState)((Object)data));
        } else if (roleName.equals("DefaultDataDefinition")) {
            this.setDefaultDataDefinition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

