/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.FrameworkEventState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class FrameworkObjectDefinitionState
extends CommonDevelopmentObjectState {
    private boolean mAbstract = false;
    private boolean mHasAbstract = false;
    private HashMap mEvents = new HashMap();
    private Reference mSuperClassRef = null;

    FrameworkObjectDefinitionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        FrameworkObjectDefinitionState lState = (FrameworkObjectDefinitionState)object;
        return String.valueOf(this.mAbstract).equals(String.valueOf(lState.mAbstract));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        FrameworkObjectDefinitionState lState = (FrameworkObjectDefinitionState)object;
        if (!String.valueOf(this.mAbstract).equals(String.valueOf(lState.mAbstract))) {
            compareContext.addPropertyDelta(sourceObject, "abstract", (Object)new Boolean(lState.mAbstract));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FrameworkObjectDefinitionState lState = (FrameworkObjectDefinitionState)((Object)super.clone());
        lState.mEvents = new HashMap();
        Iterator it = this.mEvents.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mEvents.put(lKey, ((FrameworkEventState)((Object)this.mEvents.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mEvents.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mEvents.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mEvents.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSuperClassRef != null) {
            if (clipboardService.isExcluded(this.mSuperClassRef)) {
                this.mSuperClassRef = null;
            } else if (innerObjectKeys.contains(this.mSuperClassRef.toReferenceString())) {
                this.mSuperClassRef = clipboardService.refactor(this.mSuperClassRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mSuperClassRef != null && this.mSuperClassRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mSuperClassRef != null) {
            this.mSuperClassRef = refactoringService.refactor(this.mSuperClassRef);
        }
    }

    void setAbstract(boolean value) {
        this.mAbstract = value;
        this.mHasAbstract = true;
    }

    boolean getAbstract() {
        return this.mAbstract;
    }

    boolean hasAbstract() {
        return this.mHasAbstract;
    }

    void addEvent(FrameworkEventState state) {
        this.mEvents.put(state.getName().toLowerCase(), state);
    }

    int getEventCount() {
        return this.mEvents.size();
    }

    FrameworkEventState getEvent(String name) {
        return (FrameworkEventState)((Object)this.mEvents.get(name.toLowerCase()));
    }

    Vector getEvents() {
        return new Vector(this.mEvents.values());
    }

    void removeEvent(String aggregationKey) {
        this.mEvents.remove(aggregationKey.toLowerCase());
    }

    void removeEvent(FrameworkEventState state) {
        this.mEvents.remove(state.getName().toLowerCase());
    }

    void removeAllEvents() {
        this.mEvents.clear();
    }

    Reference getSuperClass() {
        return this.mSuperClassRef;
    }

    void setSuperClass(Reference reference) {
        this.mSuperClassRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("abstract")) {
            this.setAbstract(new Boolean((String)value));
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Events")) {
            this.addEvent((FrameworkEventState)((Object)data));
        } else if (roleName.equals("SuperClass")) {
            this.setSuperClass((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

