/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class FieldGroupState
extends CommonDevelopmentObjectState {
    private Vector mAttributeRefs = new Vector();
    private Reference mValidatorRef = null;

    FieldGroupState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        FieldGroupState lState = (FieldGroupState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        FieldGroupState lState = (FieldGroupState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        FieldGroupState lState = (FieldGroupState)((Object)super.clone());
        lState.mAttributeRefs = (Vector)this.mAttributeRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Vector<Reference> lVector = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mAttributeRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lVector.add(lReference);
        }
        this.mAttributeRefs = lVector;
        if (this.mValidatorRef != null) {
            if (clipboardService.isExcluded(this.mValidatorRef)) {
                this.mValidatorRef = null;
            } else if (innerObjectKeys.contains(this.mValidatorRef.toReferenceString())) {
                this.mValidatorRef = clipboardService.refactor(this.mValidatorRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = ((AbstractList)this.mAttributeRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return this.mValidatorRef != null && this.mValidatorRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        Vector<Reference> lList = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mAttributeRefs).iterator();
        while (it.hasNext()) {
            lList.add(refactoringService.refactor((Reference)it.next()));
        }
        this.mAttributeRefs = lList;
        if (this.mValidatorRef != null) {
            this.mValidatorRef = refactoringService.refactor(this.mValidatorRef);
        }
    }

    void moveAttribute(int fromPosition, int toPosition) {
        this.mAttributeRefs.add(toPosition, this.mAttributeRefs.remove(fromPosition));
    }

    Reference getValidator() {
        return this.mValidatorRef;
    }

    void setValidator(Reference reference) {
        this.mValidatorRef = reference;
    }

    void addAttribute(Reference reference) {
        this.mAttributeRefs.add(reference);
    }

    void addAttribute(Reference reference, int position) {
        this.mAttributeRefs.add(position, reference);
    }

    int getAttributeCount() {
        return this.mAttributeRefs.size();
    }

    Reference getAttribute(Reference reference) {
        int i = 0;
        while (i < this.mAttributeRefs.size()) {
            Reference lReference = (Reference)this.mAttributeRefs.get(i);
            if (lReference.equals(reference)) {
                return lReference;
            }
            ++i;
        }
        return null;
    }

    Vector getAttributes() {
        return this.mAttributeRefs;
    }

    void removeAttribute(Reference reference) {
        Reference lReference = this.getAttribute(reference);
        if (lReference != null) {
            this.mAttributeRefs.remove(lReference);
        }
    }

    void removeAllAttributes() {
        this.mAttributeRefs.clear();
    }

    void replaceAttribute(Reference oldReference, Reference newReference) {
        int lPos = this.mAttributeRefs.indexOf(oldReference);
        this.mAttributeRefs.remove(lPos);
        this.mAttributeRefs.add(lPos, newReference);
    }

    void reorderAttributes(Vector orderedReferences) {
        this.mAttributeRefs = orderedReferences;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Attributes")) {
            this.addAttribute((Reference)data);
        } else if (roleName.equals("Validator")) {
            this.setValidator((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

