/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ContextAttributeState;
import com.sap.ide.metamodel.webdynpro.implementation.NativeTypeState;
import java.util.ArrayList;

class ContextValueAttributeState
extends ContextAttributeState {
    private NativeTypeState mNativeType = null;
    private Reference mCalculatedAttributeProviderRef = null;
    private Reference mStructureElementRef = null;
    private Reference mTypeRef = null;

    ContextValueAttributeState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        ContextValueAttributeState lState = (ContextValueAttributeState)((Object)super.clone());
        if (this.mNativeType != null) {
            lState.mNativeType = (NativeTypeState)((Object)this.mNativeType.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mCalculatedAttributeProviderRef != null && !innerObjectKeys.contains(this.mCalculatedAttributeProviderRef.toString())) {
            this.mCalculatedAttributeProviderRef = null;
        }
        if (this.mNativeType != null) {
            this.mNativeType.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mNativeType != null) {
            if (clipboardService.isExcluded((Reference)this.mNativeType.getProxyReference())) {
                this.mNativeType = null;
            } else {
                this.mNativeType.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mNativeType != null) {
            this.mNativeType.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mCalculatedAttributeProviderRef != null) {
            if (clipboardService.isExcluded(this.mCalculatedAttributeProviderRef)) {
                this.mCalculatedAttributeProviderRef = null;
            } else if (innerObjectKeys.contains(this.mCalculatedAttributeProviderRef.toReferenceString())) {
                this.mCalculatedAttributeProviderRef = clipboardService.refactor(this.mCalculatedAttributeProviderRef);
            }
        }
        if (this.mStructureElementRef != null) {
            if (clipboardService.isExcluded(this.mStructureElementRef)) {
                this.mStructureElementRef = null;
            } else if (innerObjectKeys.contains(this.mStructureElementRef.toReferenceString())) {
                this.mStructureElementRef = clipboardService.refactor(this.mStructureElementRef);
            }
        }
        if (this.mTypeRef != null) {
            if (clipboardService.isExcluded(this.mTypeRef)) {
                this.mTypeRef = null;
            } else if (innerObjectKeys.contains(this.mTypeRef.toReferenceString())) {
                this.mTypeRef = clipboardService.refactor(this.mTypeRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mCalculatedAttributeProviderRef != null && this.mCalculatedAttributeProviderRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        if (this.mStructureElementRef != null && this.mStructureElementRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mTypeRef != null && this.mTypeRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mCalculatedAttributeProviderRef != null) {
            this.mCalculatedAttributeProviderRef = refactoringService.refactor(this.mCalculatedAttributeProviderRef);
        }
        if (this.mStructureElementRef != null) {
            this.mStructureElementRef = refactoringService.refactor(this.mStructureElementRef);
        }
        if (this.mTypeRef != null) {
            this.mTypeRef = refactoringService.refactor(this.mTypeRef);
        }
    }

    void setNativeType(NativeTypeState state) {
        this.mNativeType = state;
    }

    NativeTypeState getNativeType() {
        return this.mNativeType;
    }

    Reference getCalculatedAttributeProvider() {
        return this.mCalculatedAttributeProviderRef;
    }

    void setCalculatedAttributeProvider(Reference reference) {
        this.mCalculatedAttributeProviderRef = reference;
    }

    Reference getStructureElement() {
        return this.mStructureElementRef;
    }

    void setStructureElement(Reference reference) {
        this.mStructureElementRef = reference;
    }

    Reference getType() {
        return this.mTypeRef;
    }

    void setType(Reference reference) {
        this.mTypeRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("NativeType")) {
            this.setNativeType((NativeTypeState)((Object)data));
        } else if (roleName.equals("CalculatedAttributeProvider")) {
            this.setCalculatedAttributeProvider((Reference)data);
        } else if (roleName.equals("StructureElement")) {
            this.setStructureElement((Reference)data);
        } else if (roleName.equals("Type")) {
            this.setType((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

