/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.enum.CollectionTypeEnum;
import com.sap.ide.metamodel.webdynpro.implementation.AbstractContextNodeState;
import com.sap.ide.metamodel.webdynpro.implementation.ContextAttributeState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

abstract class ContextNodeState
extends AbstractContextNodeState {
    private String mCardinality = "_0_n";
    private boolean mHasCardinality = false;
    private String mCollectionType = "list";
    private boolean mHasCollectionType = false;
    private boolean mInitializeLeadSelection = true;
    private boolean mHasInitializeLeadSelection = false;
    private String mSelection = "_0_1";
    private boolean mHasSelection = false;
    private boolean mSingleton = true;
    private boolean mHasSingleton = false;
    private boolean mTypedAccessRequired = true;
    private boolean mHasTypedAccessRequired = false;
    private Vector mAttributes = new Vector();
    private Vector mChildNodes = new Vector();
    private Reference mSupplyFunctionRef = null;

    ContextNodeState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ContextNodeState lState = (ContextNodeState)object;
        if (!String.valueOf(this.mCardinality).equals(String.valueOf(lState.mCardinality))) {
            return false;
        }
        if (!String.valueOf(this.mCollectionType).equals(String.valueOf(lState.mCollectionType))) {
            return false;
        }
        if (!String.valueOf(this.mInitializeLeadSelection).equals(String.valueOf(lState.mInitializeLeadSelection))) {
            return false;
        }
        if (!String.valueOf(this.mSelection).equals(String.valueOf(lState.mSelection))) {
            return false;
        }
        if (!String.valueOf(this.mSingleton).equals(String.valueOf(lState.mSingleton))) {
            return false;
        }
        return String.valueOf(this.mTypedAccessRequired).equals(String.valueOf(lState.mTypedAccessRequired));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ContextNodeState lState = (ContextNodeState)object;
        if (!String.valueOf(this.mCardinality).equals(String.valueOf(lState.mCardinality))) {
            compareContext.addPropertyDelta(sourceObject, "cardinality", (Object)CardinalityEnum.valueOf(lState.mCardinality));
        }
        if (!String.valueOf(this.mCollectionType).equals(String.valueOf(lState.mCollectionType))) {
            compareContext.addPropertyDelta(sourceObject, "collectionType", (Object)CollectionTypeEnum.valueOf(lState.mCollectionType));
        }
        if (!String.valueOf(this.mInitializeLeadSelection).equals(String.valueOf(lState.mInitializeLeadSelection))) {
            compareContext.addPropertyDelta(sourceObject, "initializeLeadSelection", (Object)new Boolean(lState.mInitializeLeadSelection));
        }
        if (!String.valueOf(this.mSelection).equals(String.valueOf(lState.mSelection))) {
            compareContext.addPropertyDelta(sourceObject, "selection", (Object)CardinalityEnum.valueOf(lState.mSelection));
        }
        if (!String.valueOf(this.mSingleton).equals(String.valueOf(lState.mSingleton))) {
            compareContext.addPropertyDelta(sourceObject, "singleton", (Object)new Boolean(lState.mSingleton));
        }
        if (!String.valueOf(this.mTypedAccessRequired).equals(String.valueOf(lState.mTypedAccessRequired))) {
            compareContext.addPropertyDelta(sourceObject, "typedAccessRequired", (Object)new Boolean(lState.mTypedAccessRequired));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ContextNodeState lState = (ContextNodeState)((Object)super.clone());
        lState.mAttributes = new Vector();
        int i = 0;
        while (i < this.mAttributes.size()) {
            lState.mAttributes.add(((ContextAttributeState)((Object)this.mAttributes.get(i))).clone());
            ++i;
        }
        lState.mChildNodes = new Vector();
        int i2 = 0;
        while (i2 < this.mChildNodes.size()) {
            lState.mChildNodes.add(((AbstractContextNodeState)((Object)this.mChildNodes.get(i2))).clone());
            ++i2;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mSupplyFunctionRef != null && !innerObjectKeys.contains(this.mSupplyFunctionRef.toString())) {
            this.mSupplyFunctionRef = null;
        }
        Iterator it = ((AbstractList)this.mAttributes).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = ((AbstractList)this.mChildNodes).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mAttributes).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mChildNodes).iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mAttributes).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mChildNodes).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSupplyFunctionRef != null) {
            if (clipboardService.isExcluded(this.mSupplyFunctionRef)) {
                this.mSupplyFunctionRef = null;
            } else if (innerObjectKeys.contains(this.mSupplyFunctionRef.toReferenceString())) {
                this.mSupplyFunctionRef = clipboardService.refactor(this.mSupplyFunctionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mSupplyFunctionRef != null && this.mSupplyFunctionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mSupplyFunctionRef != null) {
            this.mSupplyFunctionRef = refactoringService.refactor(this.mSupplyFunctionRef);
        }
    }

    void setCardinality(String value) {
        this.mCardinality = value;
        this.mHasCardinality = true;
    }

    String getCardinality() {
        return this.mCardinality;
    }

    boolean hasCardinality() {
        return this.mHasCardinality;
    }

    void setCollectionType(String value) {
        this.mCollectionType = value;
        this.mHasCollectionType = true;
    }

    String getCollectionType() {
        return this.mCollectionType;
    }

    boolean hasCollectionType() {
        return this.mHasCollectionType;
    }

    void setInitializeLeadSelection(boolean value) {
        this.mInitializeLeadSelection = value;
        this.mHasInitializeLeadSelection = true;
    }

    boolean getInitializeLeadSelection() {
        return this.mInitializeLeadSelection;
    }

    boolean hasInitializeLeadSelection() {
        return this.mHasInitializeLeadSelection;
    }

    void setSelection(String value) {
        this.mSelection = value;
        this.mHasSelection = true;
    }

    String getSelection() {
        return this.mSelection;
    }

    boolean hasSelection() {
        return this.mHasSelection;
    }

    void setSingleton(boolean value) {
        this.mSingleton = value;
        this.mHasSingleton = true;
    }

    boolean getSingleton() {
        return this.mSingleton;
    }

    boolean hasSingleton() {
        return this.mHasSingleton;
    }

    void setTypedAccessRequired(boolean value) {
        this.mTypedAccessRequired = value;
        this.mHasTypedAccessRequired = true;
    }

    boolean getTypedAccessRequired() {
        return this.mTypedAccessRequired;
    }

    boolean hasTypedAccessRequired() {
        return this.mHasTypedAccessRequired;
    }

    void addAttribute(ContextAttributeState state) {
        this.mAttributes.add(state);
    }

    void addAttribute(ContextAttributeState state, int position) {
        this.mAttributes.add(position, state);
    }

    int getAttributeCount() {
        return this.mAttributes.size();
    }

    ContextAttributeState getAttribute(String name) {
        int i = 0;
        while (i < this.mAttributes.size()) {
            ContextAttributeState lState = (ContextAttributeState)((Object)this.mAttributes.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getAttributes() {
        return this.mAttributes;
    }

    void removeAttribute(ContextAttributeState state) {
        this.mAttributes.remove((Object)state);
    }

    void removeAllAttributes() {
        this.mAttributes.clear();
    }

    void addChildNode(AbstractContextNodeState state) {
        this.mChildNodes.add(state);
    }

    void addChildNode(AbstractContextNodeState state, int position) {
        this.mChildNodes.add(position, state);
    }

    int getChildNodeCount() {
        return this.mChildNodes.size();
    }

    AbstractContextNodeState getChildNode(String name) {
        int i = 0;
        while (i < this.mChildNodes.size()) {
            AbstractContextNodeState lState = (AbstractContextNodeState)((Object)this.mChildNodes.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getChildNodes() {
        return this.mChildNodes;
    }

    void removeChildNode(AbstractContextNodeState state) {
        this.mChildNodes.remove((Object)state);
    }

    void removeAllChildNodes() {
        this.mChildNodes.clear();
    }

    void moveAttribute(int fromPosition, int toPosition) {
        this.mAttributes.add(toPosition, this.mAttributes.remove(fromPosition));
    }

    void moveChildNode(int fromPosition, int toPosition) {
        this.mChildNodes.add(toPosition, this.mChildNodes.remove(fromPosition));
    }

    Reference getSupplyFunction() {
        return this.mSupplyFunctionRef;
    }

    void setSupplyFunction(Reference reference) {
        this.mSupplyFunctionRef = reference;
    }

    void reorderAttributes(Vector orderedStates) {
        this.mAttributes = orderedStates;
    }

    void reorderChildNodes(Vector orderedStates) {
        this.mChildNodes = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("cardinality")) {
            if (CardinalityEnum.valueOf((String)value) != null) {
                this.setCardinality((String)value);
            }
        } else if (propertyName.equals("collectionType")) {
            if (CollectionTypeEnum.valueOf((String)value) != null) {
                this.setCollectionType((String)value);
            }
        } else if (propertyName.equals("initializeLeadSelection")) {
            this.setInitializeLeadSelection(new Boolean((String)value));
        } else if (propertyName.equals("selection")) {
            if (CardinalityEnum.valueOf((String)value) != null) {
                this.setSelection((String)value);
            }
        } else if (propertyName.equals("singleton")) {
            this.setSingleton(new Boolean((String)value));
        } else if (propertyName.equals("typedAccessRequired")) {
            this.setTypedAccessRequired(new Boolean((String)value));
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Attributes")) {
            this.addAttribute((ContextAttributeState)((Object)data));
        } else if (roleName.equals("ChildNodes")) {
            this.addChildNode((AbstractContextNodeState)((Object)data));
        } else if (roleName.equals("SupplyFunction")) {
            this.setSupplyFunction((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

