/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.ContextElementMappingTypeEnum;
import java.util.ArrayList;

class ContextElementMappingState
extends CommonDevelopmentObjectState {
    private String mMappingType = "not_applicable";
    private boolean mHasMappingType = false;
    private Reference mMappedElementRef = null;
    private Reference mOwnElementRef = null;

    ContextElementMappingState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ContextElementMappingState lState = (ContextElementMappingState)object;
        return String.valueOf(this.mMappingType).equals(String.valueOf(lState.mMappingType));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ContextElementMappingState lState = (ContextElementMappingState)object;
        if (!String.valueOf(this.mMappingType).equals(String.valueOf(lState.mMappingType))) {
            compareContext.addPropertyDelta(sourceObject, "mappingType", (Object)ContextElementMappingTypeEnum.valueOf(lState.mMappingType));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ContextElementMappingState lState = (ContextElementMappingState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mOwnElementRef != null && !innerObjectKeys.contains(this.mOwnElementRef.toString())) {
            this.mOwnElementRef = null;
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mMappedElementRef != null) {
            if (clipboardService.isExcluded(this.mMappedElementRef)) {
                this.mMappedElementRef = null;
            } else if (innerObjectKeys.contains(this.mMappedElementRef.toReferenceString())) {
                this.mMappedElementRef = clipboardService.refactor(this.mMappedElementRef);
            }
        }
        if (this.mOwnElementRef != null) {
            if (clipboardService.isExcluded(this.mOwnElementRef)) {
                this.mOwnElementRef = null;
            } else if (innerObjectKeys.contains(this.mOwnElementRef.toReferenceString())) {
                this.mOwnElementRef = clipboardService.refactor(this.mOwnElementRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mMappedElementRef != null && this.mMappedElementRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mOwnElementRef != null && this.mOwnElementRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mMappedElementRef != null) {
            this.mMappedElementRef = refactoringService.refactor(this.mMappedElementRef);
        }
        if (this.mOwnElementRef != null) {
            this.mOwnElementRef = refactoringService.refactor(this.mOwnElementRef);
        }
    }

    void setMappingType(String value) {
        this.mMappingType = value;
        this.mHasMappingType = true;
    }

    String getMappingType() {
        return this.mMappingType;
    }

    boolean hasMappingType() {
        return this.mHasMappingType;
    }

    Reference getMappedElement() {
        return this.mMappedElementRef;
    }

    void setMappedElement(Reference reference) {
        this.mMappedElementRef = reference;
    }

    Reference getOwnElement() {
        return this.mOwnElementRef;
    }

    void setOwnElement(Reference reference) {
        this.mOwnElementRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mappingType")) {
            if (ContextElementMappingTypeEnum.valueOf((String)value) != null) {
                this.setMappingType((String)value);
            }
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("MappedElement")) {
            this.setMappedElement((Reference)data);
        } else if (roleName.equals("OwnElement")) {
            this.setOwnElement((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

