/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.ComponentLifecycleEnum;
import com.sap.ide.metamodel.webdynpro.implementation.ComponentControllerUsageState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ComponentUsageState
extends CommonDevelopmentObjectState {
    private String mLifecycleControl = "manual";
    private boolean mHasLifecycleControl = false;
    private HashMap mComponentControllerUsages = new HashMap();
    private Reference mUsedComponentRef = null;

    ComponentUsageState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ComponentUsageState lState = (ComponentUsageState)object;
        return String.valueOf(this.mLifecycleControl).equals(String.valueOf(lState.mLifecycleControl));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ComponentUsageState lState = (ComponentUsageState)object;
        if (!String.valueOf(this.mLifecycleControl).equals(String.valueOf(lState.mLifecycleControl))) {
            compareContext.addPropertyDelta(sourceObject, "lifecycleControl", (Object)ComponentLifecycleEnum.valueOf(lState.mLifecycleControl));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentUsageState lState = (ComponentUsageState)((Object)super.clone());
        lState.mComponentControllerUsages = new HashMap();
        Iterator it = this.mComponentControllerUsages.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mComponentControllerUsages.put(lKey, ((ComponentControllerUsageState)((Object)this.mComponentControllerUsages.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mComponentControllerUsages.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mComponentControllerUsages.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mComponentControllerUsages.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mUsedComponentRef != null) {
            if (clipboardService.isExcluded(this.mUsedComponentRef)) {
                this.mUsedComponentRef = null;
            } else if (innerObjectKeys.contains(this.mUsedComponentRef.toReferenceString())) {
                this.mUsedComponentRef = clipboardService.refactor(this.mUsedComponentRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mUsedComponentRef != null && this.mUsedComponentRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mUsedComponentRef != null) {
            this.mUsedComponentRef = refactoringService.refactor(this.mUsedComponentRef);
        }
    }

    void setLifecycleControl(String value) {
        this.mLifecycleControl = value;
        this.mHasLifecycleControl = true;
    }

    String getLifecycleControl() {
        return this.mLifecycleControl;
    }

    boolean hasLifecycleControl() {
        return this.mHasLifecycleControl;
    }

    void addComponentControllerUsage(ComponentControllerUsageState state) {
        this.mComponentControllerUsages.put(state.getName().toLowerCase(), state);
    }

    int getComponentControllerUsageCount() {
        return this.mComponentControllerUsages.size();
    }

    ComponentControllerUsageState getComponentControllerUsage(String name) {
        return (ComponentControllerUsageState)((Object)this.mComponentControllerUsages.get(name.toLowerCase()));
    }

    Vector getComponentControllerUsages() {
        return new Vector(this.mComponentControllerUsages.values());
    }

    void removeComponentControllerUsage(String aggregationKey) {
        this.mComponentControllerUsages.remove(aggregationKey.toLowerCase());
    }

    void removeComponentControllerUsage(ComponentControllerUsageState state) {
        this.mComponentControllerUsages.remove(state.getName().toLowerCase());
    }

    void removeAllComponentControllerUsages() {
        this.mComponentControllerUsages.clear();
    }

    Reference getUsedComponent() {
        return this.mUsedComponentRef;
    }

    void setUsedComponent(Reference reference) {
        this.mUsedComponentRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("lifecycleControl")) {
            if (ComponentLifecycleEnum.valueOf((String)value) != null) {
                this.setLifecycleControl((String)value);
            }
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ComponentControllerUsages")) {
            this.addComponentControllerUsage((ComponentControllerUsageState)((Object)data));
        } else if (roleName.equals("UsedComponent")) {
            this.setUsedComponent((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

