/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ComponentUsageState;
import com.sap.ide.metamodel.webdynpro.implementation.EmptyViewState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ComponentState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Reference mComponentInterfaceRef = null;
    private HashMap mComponentUsages = new HashMap();
    private HashMap mControllerRefs = new HashMap();
    private EmptyViewState mEmptyView = null;
    private Reference mMessagePoolRef = null;
    private HashMap mViewRefs = new HashMap();
    private HashMap mWindowRefs = new HashMap();
    private Reference mComponentControllerRef = null;
    private HashMap mUsedModelRefs = new HashMap();
    private HashMap mUsedUIELibraryRefs = new HashMap();

    ComponentState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ComponentState lState = (ComponentState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ComponentState lState = (ComponentState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentState lState = (ComponentState)((Object)super.clone());
        lState.mComponentUsages = new HashMap();
        Iterator it = this.mComponentUsages.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mComponentUsages.put(lKey, ((ComponentUsageState)((Object)this.mComponentUsages.get(lKey))).clone());
        }
        lState.mControllerRefs = (HashMap)this.mControllerRefs.clone();
        if (this.mEmptyView != null) {
            lState.mEmptyView = (EmptyViewState)((Object)this.mEmptyView.clone());
        }
        lState.mViewRefs = (HashMap)this.mViewRefs.clone();
        lState.mWindowRefs = (HashMap)this.mWindowRefs.clone();
        lState.mUsedModelRefs = (HashMap)this.mUsedModelRefs.clone();
        lState.mUsedUIELibraryRefs = (HashMap)this.mUsedUIELibraryRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mComponentControllerRef != null && !innerObjectKeys.contains(this.mComponentControllerRef.toString())) {
            this.mComponentControllerRef = null;
        }
        Iterator it = this.mComponentUsages.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mEmptyView != null) {
            this.mEmptyView.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mComponentInterfaceRef != null && clipboardService.isExcluded(this.mComponentInterfaceRef)) {
            this.mComponentInterfaceRef = null;
        }
        Iterator it = this.mComponentUsages.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mControllerRefs.values().iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it2.remove();
        }
        if (this.mEmptyView != null) {
            if (clipboardService.isExcluded((Reference)this.mEmptyView.getProxyReference())) {
                this.mEmptyView = null;
            } else {
                this.mEmptyView.refactor(clipboardService);
            }
        }
        if (this.mMessagePoolRef != null && clipboardService.isExcluded(this.mMessagePoolRef)) {
            this.mMessagePoolRef = null;
        }
        Iterator it3 = this.mViewRefs.values().iterator();
        while (it3.hasNext()) {
            Reference lReference = (Reference)it3.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it3.remove();
        }
        Iterator it4 = this.mWindowRefs.values().iterator();
        while (it4.hasNext()) {
            Reference lReference = (Reference)it4.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it4.remove();
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        Reference lReference;
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mComponentInterfaceRef != null) {
            this.mComponentInterfaceRef = clipboardService.refactor(this.mComponentInterfaceRef);
        }
        Iterator it = this.mComponentUsages.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it2 = this.mControllerRefs.values().iterator();
        while (it2.hasNext()) {
            lReference = clipboardService.refactor((Reference)it2.next());
            lHashMap.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mControllerRefs = lHashMap;
        if (this.mEmptyView != null) {
            this.mEmptyView.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mMessagePoolRef != null) {
            this.mMessagePoolRef = clipboardService.refactor(this.mMessagePoolRef);
        }
        lHashMap = new HashMap();
        it2 = this.mViewRefs.values().iterator();
        while (it2.hasNext()) {
            lReference = clipboardService.refactor((Reference)it2.next());
            lHashMap.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mViewRefs = lHashMap;
        lHashMap = new HashMap();
        it2 = this.mWindowRefs.values().iterator();
        while (it2.hasNext()) {
            lReference = clipboardService.refactor((Reference)it2.next());
            lHashMap.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mWindowRefs = lHashMap;
        if (this.mComponentControllerRef != null) {
            if (clipboardService.isExcluded(this.mComponentControllerRef)) {
                this.mComponentControllerRef = null;
            } else if (innerObjectKeys.contains(this.mComponentControllerRef.toReferenceString())) {
                this.mComponentControllerRef = clipboardService.refactor(this.mComponentControllerRef);
            }
        }
        lHashMap = new HashMap();
        it2 = this.mUsedModelRefs.values().iterator();
        while (it2.hasNext()) {
            lReference = (Reference)it2.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mUsedModelRefs = lHashMap;
        lHashMap = new HashMap();
        it2 = this.mUsedUIELibraryRefs.values().iterator();
        while (it2.hasNext()) {
            lReference = (Reference)it2.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mUsedUIELibraryRefs = lHashMap;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mComponentInterfaceRef != null && this.mComponentInterfaceRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        Iterator it = this.mControllerRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        if (this.mMessagePoolRef != null && this.mMessagePoolRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        Iterator it2 = this.mViewRefs.values().iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it3 = this.mWindowRefs.values().iterator();
        while (it3.hasNext()) {
            Reference lReference = (Reference)it3.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        if (this.mComponentControllerRef != null && this.mComponentControllerRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        Iterator it4 = this.mUsedModelRefs.values().iterator();
        while (it4.hasNext()) {
            Reference lReference = (Reference)it4.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it5 = this.mUsedUIELibraryRefs.values().iterator();
        while (it5.hasNext()) {
            Reference lReference = (Reference)it5.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        Reference lReference;
        super.refactorReferences(refactoringService);
        if (this.mComponentControllerRef != null) {
            this.mComponentControllerRef = refactoringService.refactor(this.mComponentControllerRef);
        }
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mUsedModelRefs.values().iterator();
        while (it.hasNext()) {
            lReference = refactoringService.refactor((Reference)it.next());
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mUsedModelRefs = lHashMap;
        lHashMap = new HashMap();
        it = this.mUsedUIELibraryRefs.values().iterator();
        while (it.hasNext()) {
            lReference = refactoringService.refactor((Reference)it.next());
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mUsedUIELibraryRefs = lHashMap;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void setComponentInterface(Reference reference) {
        this.mComponentInterfaceRef = reference;
    }

    Reference getComponentInterface() {
        return this.mComponentInterfaceRef;
    }

    void setEmptyView(EmptyViewState state) {
        this.mEmptyView = state;
    }

    EmptyViewState getEmptyView() {
        return this.mEmptyView;
    }

    void setMessagePool(Reference reference) {
        this.mMessagePoolRef = reference;
    }

    Reference getMessagePool() {
        return this.mMessagePoolRef;
    }

    void addComponentUsage(ComponentUsageState state) {
        this.mComponentUsages.put(state.getName().toLowerCase(), state);
    }

    int getComponentUsageCount() {
        return this.mComponentUsages.size();
    }

    ComponentUsageState getComponentUsage(String name) {
        return (ComponentUsageState)((Object)this.mComponentUsages.get(name.toLowerCase()));
    }

    Vector getComponentUsages() {
        return new Vector(this.mComponentUsages.values());
    }

    void removeComponentUsage(String aggregationKey) {
        this.mComponentUsages.remove(aggregationKey.toLowerCase());
    }

    void removeComponentUsage(ComponentUsageState state) {
        this.mComponentUsages.remove(state.getName().toLowerCase());
    }

    void removeAllComponentUsages() {
        this.mComponentUsages.clear();
    }

    void addController(Reference reference) {
        this.mControllerRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getControllerCount() {
        return this.mControllerRefs.size();
    }

    Reference getController(String _package, String name) {
        return (Reference)this.mControllerRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getControllers() {
        return new Vector(this.mControllerRefs.values());
    }

    void removeController(Reference reference) {
        this.mControllerRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeController(String aggregationKey) {
        this.mControllerRefs.remove(aggregationKey);
    }

    void removeController(String _package, String name) {
        this.mControllerRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllControllers() {
        this.mControllerRefs.clear();
    }

    void addView(Reference reference) {
        this.mViewRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getViewCount() {
        return this.mViewRefs.size();
    }

    Reference getView(String _package, String name) {
        return (Reference)this.mViewRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getViews() {
        return new Vector(this.mViewRefs.values());
    }

    void removeView(Reference reference) {
        this.mViewRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeView(String aggregationKey) {
        this.mViewRefs.remove(aggregationKey);
    }

    void removeView(String _package, String name) {
        this.mViewRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllViews() {
        this.mViewRefs.clear();
    }

    void addWindow(Reference reference) {
        this.mWindowRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getWindowCount() {
        return this.mWindowRefs.size();
    }

    Reference getWindow(String _package, String name) {
        return (Reference)this.mWindowRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getWindows() {
        return new Vector(this.mWindowRefs.values());
    }

    void removeWindow(Reference reference) {
        this.mWindowRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeWindow(String aggregationKey) {
        this.mWindowRefs.remove(aggregationKey);
    }

    void removeWindow(String _package, String name) {
        this.mWindowRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllWindows() {
        this.mWindowRefs.clear();
    }

    Reference getComponentController() {
        return this.mComponentControllerRef;
    }

    void setComponentController(Reference reference) {
        this.mComponentControllerRef = reference;
    }

    void addUsedModel(Reference reference) {
        this.mUsedModelRefs.put(reference.toString(), reference);
    }

    int getUsedModelCount() {
        return this.mUsedModelRefs.size();
    }

    Reference getUsedModel(Reference reference) {
        return (Reference)this.mUsedModelRefs.get(reference.toString());
    }

    Vector getUsedModels() {
        return new Vector(this.mUsedModelRefs.values());
    }

    void removeUsedModel(Reference reference) {
        this.mUsedModelRefs.remove(reference.toString());
    }

    void removeAllUsedModels() {
        this.mUsedModelRefs.clear();
    }

    void replaceUsedModel(Reference oldReference, Reference newReference) {
        this.mUsedModelRefs.remove(oldReference.toString());
        this.mUsedModelRefs.put(newReference.toString(), newReference);
    }

    void addUsedUIELibrary(Reference reference) {
        this.mUsedUIELibraryRefs.put(reference.toString(), reference);
    }

    int getUsedUIELibraryCount() {
        return this.mUsedUIELibraryRefs.size();
    }

    Reference getUsedUIELibrary(Reference reference) {
        return (Reference)this.mUsedUIELibraryRefs.get(reference.toString());
    }

    Vector getUsedUIELibraries() {
        return new Vector(this.mUsedUIELibraryRefs.values());
    }

    void removeUsedUIELibrary(Reference reference) {
        this.mUsedUIELibraryRefs.remove(reference.toString());
    }

    void removeAllUsedUIELibraries() {
        this.mUsedUIELibraryRefs.clear();
    }

    void replaceUsedUIELibrary(Reference oldReference, Reference newReference) {
        this.mUsedUIELibraryRefs.remove(oldReference.toString());
        this.mUsedUIELibraryRefs.put(newReference.toString(), newReference);
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ComponentInterface")) {
            this.setComponentInterface((Reference)data);
        } else if (roleName.equals("ComponentUsages")) {
            this.addComponentUsage((ComponentUsageState)((Object)data));
        } else if (roleName.equals("Controllers")) {
            this.addController((Reference)data);
        } else if (roleName.equals("EmptyView")) {
            this.setEmptyView((EmptyViewState)((Object)data));
        } else if (roleName.equals("MessagePool")) {
            this.setMessagePool((Reference)data);
        } else if (roleName.equals("Views")) {
            this.addView((Reference)data);
        } else if (roleName.equals("Windows")) {
            this.addWindow((Reference)data);
        } else if (roleName.equals("ComponentController")) {
            this.setComponentController((Reference)data);
        } else if (roleName.equals("UsedModels")) {
            this.addUsedModel((Reference)data);
        } else if (roleName.equals("UsedUIELibraries")) {
            this.addUsedUIELibrary((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

