/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class ComponentInterfaceState
extends CommonDevelopmentObjectState {
    private HashMap mControllerRefs = new HashMap();
    private HashMap mInterfaceViewRefs = new HashMap();
    private Reference mConfigurationControllerRef = null;
    private Reference mInterfaceControllerRef = null;

    ComponentInterfaceState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ComponentInterfaceState lState = (ComponentInterfaceState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ComponentInterfaceState lState = (ComponentInterfaceState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentInterfaceState lState = (ComponentInterfaceState)((Object)super.clone());
        lState.mControllerRefs = (HashMap)this.mControllerRefs.clone();
        lState.mInterfaceViewRefs = (HashMap)this.mInterfaceViewRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mConfigurationControllerRef != null && !innerObjectKeys.contains(this.mConfigurationControllerRef.toString())) {
            this.mConfigurationControllerRef = null;
        }
        if (this.mInterfaceControllerRef != null && !innerObjectKeys.contains(this.mInterfaceControllerRef.toString())) {
            this.mInterfaceControllerRef = null;
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mControllerRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it.remove();
        }
        Iterator it2 = this.mInterfaceViewRefs.values().iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it2.remove();
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        Reference lReference;
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mControllerRefs.values().iterator();
        while (it.hasNext()) {
            lReference = clipboardService.refactor((Reference)it.next());
            lHashMap.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mControllerRefs = lHashMap;
        lHashMap = new HashMap();
        it = this.mInterfaceViewRefs.values().iterator();
        while (it.hasNext()) {
            lReference = clipboardService.refactor((Reference)it.next());
            lHashMap.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mInterfaceViewRefs = lHashMap;
        if (this.mConfigurationControllerRef != null) {
            if (clipboardService.isExcluded(this.mConfigurationControllerRef)) {
                this.mConfigurationControllerRef = null;
            } else if (innerObjectKeys.contains(this.mConfigurationControllerRef.toReferenceString())) {
                this.mConfigurationControllerRef = clipboardService.refactor(this.mConfigurationControllerRef);
            }
        }
        if (this.mInterfaceControllerRef != null) {
            if (clipboardService.isExcluded(this.mInterfaceControllerRef)) {
                this.mInterfaceControllerRef = null;
            } else if (innerObjectKeys.contains(this.mInterfaceControllerRef.toReferenceString())) {
                this.mInterfaceControllerRef = clipboardService.refactor(this.mInterfaceControllerRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = this.mControllerRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it2 = this.mInterfaceViewRefs.values().iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        if (this.mConfigurationControllerRef != null && this.mConfigurationControllerRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mInterfaceControllerRef != null && this.mInterfaceControllerRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mConfigurationControllerRef != null) {
            this.mConfigurationControllerRef = refactoringService.refactor(this.mConfigurationControllerRef);
        }
        if (this.mInterfaceControllerRef != null) {
            this.mInterfaceControllerRef = refactoringService.refactor(this.mInterfaceControllerRef);
        }
    }

    void addController(Reference reference) {
        this.mControllerRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getControllerCount() {
        return this.mControllerRefs.size();
    }

    Reference getController(String _package, String name) {
        return (Reference)this.mControllerRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getControllers() {
        return new Vector(this.mControllerRefs.values());
    }

    void removeController(Reference reference) {
        this.mControllerRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeController(String aggregationKey) {
        this.mControllerRefs.remove(aggregationKey);
    }

    void removeController(String _package, String name) {
        this.mControllerRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllControllers() {
        this.mControllerRefs.clear();
    }

    void addInterfaceView(Reference reference) {
        this.mInterfaceViewRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getInterfaceViewCount() {
        return this.mInterfaceViewRefs.size();
    }

    Reference getInterfaceView(String _package, String name) {
        return (Reference)this.mInterfaceViewRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getInterfaceViews() {
        return new Vector(this.mInterfaceViewRefs.values());
    }

    void removeInterfaceView(Reference reference) {
        this.mInterfaceViewRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeInterfaceView(String aggregationKey) {
        this.mInterfaceViewRefs.remove(aggregationKey);
    }

    void removeInterfaceView(String _package, String name) {
        this.mInterfaceViewRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllInterfaceViews() {
        this.mInterfaceViewRefs.clear();
    }

    Reference getConfigurationController() {
        return this.mConfigurationControllerRef;
    }

    void setConfigurationController(Reference reference) {
        this.mConfigurationControllerRef = reference;
    }

    Reference getInterfaceController() {
        return this.mInterfaceControllerRef;
    }

    void setInterfaceController(Reference reference) {
        this.mInterfaceControllerRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Controllers")) {
            this.addController((Reference)data);
        } else if (roleName.equals("InterfaceViews")) {
            this.addInterfaceView((Reference)data);
        } else if (roleName.equals("ConfigurationController")) {
            this.setConfigurationController((Reference)data);
        } else if (roleName.equals("InterfaceController")) {
            this.setInterfaceController((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

